package org.pathwaycommons.trans.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

import org.pathwaycommons.trans.PSIMITags;

/**
 * Implementation for the PSIMI Miner (geared towards BIND models),  using the
 * XML model.
 * This miner works only with PSI-MI files that are in the 'expanded' format.
 *
 * @author rashadbadrawi
 */

public class PSIMIMinerXML extends PSIMIMiner {
//
    //handy atts
    private Element interactionE;
    private Namespace psins = Namespace.getNamespace(PSIMITags.PSIMI_NS);

    protected PSIMIMinerXML (String inputFileName, String reportFileName,
                 String miningType) throws Exception {

        super (inputFileName, reportFileName, miningType);
    }

    protected void minePSIMI (String inputFileName) throws IOException, JDOMException {

        super.termMap = new TreeMap <String, Integer> ();
        super.interactionCnt = 0;
        Element entrySetE = XMLUtil.readSchemaBasedXML(inputFileName);
        Element entryE = (Element)entrySetE.getChild (PSIMITags.ENTRY, this.psins); //only one
        ArrayList <Element> interactionsList = new ArrayList <Element> ();
        interactionsList.addAll (entryE.getChild
                        (PSIMITags.INT_LIST, this.psins).getChildren(PSIMITags.INT, psins));
        for (int i = 0; i < interactionsList.size(); i++) {
            this.interactionE = interactionsList.get (i);
            if (getAtt (PSIMITags.ATT_COMPLEX_SUBUNIT_CNT) != null) {
                if (!PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                    //System.out.println ("Skipping complex: " + super.interactionCnt);
                    super.skipCnt++;
                    continue;
                } else {
                    super.interactionCnt++;
                }
            }
            if (!PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                super.interactionCnt++;
            }
            //System.out.println(this.interactionE.getChild
            //               (PSIMITags.NAMES, psins).getChild (PSIMITags.SHORT_LABEL, psins).getTextTrim());
            if (PSIMIMiner.MINING_INT_DET_METHOD.equals (super.miningType)) {
                mineDetMethod ();
            } else if (PSIMIMiner.MINING_INTERACTOR_TYPE.equals (super.miningType)) {
                mineInteractorType ();
            } else if (PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                mineComplexSubunits ();
            } else if (PSIMIMiner.MINING_BIND_DIV.equals (super.miningType)) {
                mineBINDDivCategory ();
            } else if (PSIMIMiner.MINING_INT_XREF.equals (super.miningType)) {
                mineInteractorXRef ();
            } else throw new IllegalArgumentException
                             ("Unsupported mining request: " + super.miningType);
        }
        super.incrementCounts(inputFileName);
    }

    protected void mineDetMethod () {

        ArrayList <Element> expDescList = new ArrayList <Element> ();
        expDescList.addAll (this.interactionE.getChild(PSIMITags.EXP_LIST, psins)
                                          .getChildren (PSIMITags.EXP_DESC, psins));
        for (int i = 0; i < expDescList.size (); i++) {
            Element intDetMetE = expDescList.get (i).getChild (PSIMITags.INT_DET_METHOD, psins);
            String detMethod = intDetMetE.getChild (PSIMITags.NAMES, psins)
                         .getChild (PSIMITags.SHORT_LABEL, psins).getTextTrim ();
            trackTermCnt (detMethod);
        }
    }

    protected void mineInteractorType () {

        ArrayList <Element> partList = new ArrayList <Element> ();
        partList.addAll (this.interactionE
                                       .getChild (PSIMITags.PARTLIST, psins)
                                       .getChildren (PSIMITags.PART, psins));
        for (int i = 0; i < partList.size(); i++) {
            Element interactorE = partList.get (i).getChild (PSIMITags.INTERACTOR, psins);
            Element interTypeE = interactorE.getChild (PSIMITags.INT_TYPE, psins);
            trackTermCnt (interTypeE.getChild (PSIMITags.NAMES, psins)
                         .getChild (PSIMITags.SHORT_LABEL, psins).getTextTrim ());
        }
    }

    protected void mineInteractorXRef () {

        ArrayList <Element> partList = new ArrayList <Element> ();
        partList.addAll (this.interactionE
                                       .getChild (PSIMITags.PARTLIST, psins)
                                       .getChildren (PSIMITags.PART, psins));
        for (int i = 0; i < partList.size(); i++) {
            Element interactorE = partList.get (i).getChild (PSIMITags.INTERACTOR, psins);
            if (interactorE == null) {
                System.err.println ("No interactor. InteractorRef not supported: " +
                                     partList.get (i));
                return;
            }
            ArrayList <Element> xrefList = new ArrayList <Element> ();
            Element xrefE = interactorE.getChild (PSIMITags.XREF, psins);
            if (xrefE != null) {
                xrefList.add (xrefE.getChild(PSIMITags.PREF, psins));
                xrefList.addAll (xrefE.getChildren(PSIMITags.SREF, psins));
            }
            for (int j = 0; j < xrefList.size (); j++) {
                trackTermCnt (xrefList.get(j).getAttributeValue(PSIMITags.DB_ATT));
            }
        }
    }
    
    protected void trackAtt (String attName) {

        String attVal = getAtt (attName);
        if (attVal != null) {
            trackTermCnt (attVal);
        }
    }

    protected String getAtt (String attName) {

        Element attListE = this.interactionE.getChild (PSIMITags.ATTLIST, psins);
        ArrayList <Element> attList = new ArrayList <Element> ();
        attList.addAll (attListE.getChildren(PSIMITags.ATT, psins));
        String attVal = null;
        for (int i = 0; i < attList.size (); i++) {
            Element attE = attList.get (i);
            if (attE.getAttributeValue (PSIMITags.NAME_ATT).trim().equals (attName)) {
               attVal = attE.getValue();
               break;
            }
        }

        return attVal;
    }
}