/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

class FTPBinaryInputStream
extends AbstractFTPInputStream {
    private static Logger log = Logger.getLogger("FTPBinaryInputStream");
    private static int SKIP_THRESHOLD = 65536;
    private long mark = -1L;
    private int skipThreshold = SKIP_THRESHOLD;

    public FTPBinaryInputStream(FTPClient fTPClient, String string) {
        this(fTPClient, string, 0L);
    }

    public FTPBinaryInputStream(FTPClient fTPClient, String string, long l2) {
        super(fTPClient, string);
        this.pos = l2;
    }

    public final int read() {
        byte[] byArray;
        if (!this.started) {
            this.start();
        }
        if (this.client.readChunk(this.in, byArray = new byte[1], 0, byArray.length) < 0) {
            return -1;
        }
        ++this.monitorCount;
        ++this.pos;
        this.checkMonitor();
        return 0xFF & byArray[0];
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (!this.started) {
            this.start();
        }
        int n3 = this.client.readChunk(this.in, byArray, n, n2);
        this.monitorCount += (long)n3;
        this.pos += (long)n3;
        this.checkMonitor();
        return n3;
    }

    public final long skip(long l2) {
        log.debug("Skipping " + l2 + " bytes");
        if (this.started) {
            this.stop();
        }
        long l3 = l2;
        long l4 = 0L;
        this.pos += l2;
        try {
            l4 = this.client.size(this.getRemoteFile());
            if (this.pos > l4) {
                l3 = l4 - this.pos;
                this.pos = l4;
            }
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        return l3;
    }

    public final synchronized void mark(int n) {
        this.mark = this.pos;
        log.debug("Mark set at " + this.pos + " bytes in file");
    }

    public final synchronized void reset() {
        log.debug("Reset called - resetting to " + this.mark + " bytes");
        if (this.mark < 0L) {
            throw new IOException("mark not called before reset()");
        }
        if (this.started) {
            this.stop();
        }
        this.pos = this.mark;
        this.mark = -1L;
    }

    public final boolean markSupported() {
        return true;
    }

    private void stop() {
        this.client.closeDataSocket(this.in);
        try {
            this.client.readReply();
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        this.started = false;
        this.closed = true;
    }
}

