/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.BandwidthThrottler;
import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.DirectoryEmptyStrings;
import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPClient$DirectoryCallback;
import com.enterprisedt.net.ftp.FTPClient$DirectoryCallbackImpl;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileNotFoundStrings;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.MLSXEntryParser;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.TransferCompleteStrings;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.133 2012/11/30 05:00:55 bruceb Exp $";
    public static final int DEFAULT_MONITOR_INTERVAL = 65535;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_PORT = 65535;
    public static final int DEFAULT_TIMEOUT = 60000;
    private static final int SHORT_TIMEOUT = 500;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_DELAY = 5000;
    public static final int DEFAULT_TCP_BUFFER_SIZE = 131072;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final byte[] FTP_LINE_SEPARATOR = new byte[]{13, 10};
    private static final String STOU_FILENAME_MARKER = "FILE:";
    private static final String STORE_CMD = "STOR ";
    private static final String STORE_UNIQ_CMD = "STOU ";
    private static final String MODTIME_STR = "modtime";
    public static Locale[] DEFAULT_LISTING_LOCALES;
    private static Logger log;
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    protected int timeout = 60000;
    protected int serverWakeupInterval = 0;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected String id;
    private static int masterId;
    protected int controlPort = 21;
    private boolean autoPassiveIPSubstitution = true;
    private String activeIP = null;
    protected String controlEncoding = "US-ASCII";
    private boolean strictReturnCodes = false;
    protected DirectoryEmptyStrings dirEmptyStrings = new DirectoryEmptyStrings();
    protected TransferCompleteStrings transferCompleteStrings = new TransferCompleteStrings();
    protected FileNotFoundStrings fileNotFoundStrings = new FileNotFoundStrings();
    private boolean cancelTransfer = false;
    private boolean resume = false;
    private boolean mdtmSupported = true;
    private boolean sizeSupported = true;
    private boolean cdupSupported = true;
    private long resumeMarker = 0L;
    private boolean deleteOnFailure = true;
    protected boolean detectTransferMode = false;
    protected boolean fileLockingEnabled = true;
    private int lowPort = -1;
    private int highPort = -1;
    private String storeCommand = "STOR ";
    protected long monitorInterval = 65535L;
    protected int transferBufferSize = 16384;
    protected int dataReceiveBufferSize = 131072;
    protected int dataSendBufferSize = 131072;
    private int downloadCount = 0;
    private int uploadCount = 0;
    private int deleteCount = 0;
    private int retryCount = 3;
    private int retryDelay = 5000;
    private boolean listenOnAllInterfaces = true;
    private FTPFileFactory fileFactory = null;
    private Locale[] listingLocales;
    private MLSXEntryParser mlsxParser = new MLSXEntryParser();
    protected FTPProgressMonitor monitor = null;
    protected FTPMessageListener messageListener = null;
    protected FTPProgressMonitorEx monitorEx = null;
    protected FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    protected FTPReply lastReply;
    protected String user;
    protected String password;
    protected BandwidthThrottler throttler = null;
    protected DataChannelCallback dataChannelCallback = null;

    public static final int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static final String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String string) {
        this(string, 21, 0);
    }

    public FTPClient(String string, int n) {
        this(string, n, 0);
    }

    public FTPClient(String string, int n, int n2) {
        this(InetAddress.getByName(string), n, n2);
    }

    public FTPClient(String string, int n, int n2, String string2) {
        this(InetAddress.getByName(string), n, n2, string2);
    }

    public FTPClient(InetAddress inetAddress) {
        this(inetAddress, 21, 0);
    }

    public FTPClient(InetAddress inetAddress, int n) {
        this(inetAddress, n, 0);
    }

    public FTPClient(InetAddress inetAddress, int n, int n2) {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (n < 0) {
            n = 21;
        }
        this.initialize(new FTPControlSocket(inetAddress, n, n2, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress inetAddress, int n, int n2, String string) {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (n < 0) {
            n = 21;
        }
        this.initialize(new FTPControlSocket(inetAddress, n, n2, string, null));
    }

    public FTPClient() {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        log.debug(VersionDetails.report(this));
    }

    public final void connect() {
        this.checkConnection(false);
        if (this.remoteAddr == null) {
            this.remoteAddr = InetAddress.getByName(this.remoteHost);
        }
        log.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public final boolean connected() {
        if (this.control == null) {
            return false;
        }
        return this.control.controlSock == null ? false : this.control.controlSock.isConnected();
    }

    protected final void checkConnection(boolean bl) {
        if (bl && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!bl && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected final void initialize(FTPControlSocket fTPControlSocket) {
        this.control = fTPControlSocket;
        fTPControlSocket.setMessageListener(this.messageListener);
        fTPControlSocket.setStrictReturnCodes(this.strictReturnCodes);
        fTPControlSocket.setListenOnAllInterfaces(this.listenOnAllInterfaces);
        fTPControlSocket.setTimeout(this.timeout);
        fTPControlSocket.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
        fTPControlSocket.setDataChannelCallback(this.dataChannelCallback);
        if (this.activeIP != null) {
            fTPControlSocket.setActivePortIPAddress(this.activeIP);
        }
        if (this.lowPort > 0 && this.highPort > 0) {
            fTPControlSocket.setActivePortRange(this.lowPort, this.highPort);
        }
    }

    public final void debugResponses(boolean bl) {
        if (bl) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String string) {
        this.id = string;
    }

    public final int getDownloadCount() {
        return this.downloadCount;
    }

    public final void resetDownloadCount() {
        this.downloadCount = 0;
    }

    public final int getUploadCount() {
        return this.uploadCount;
    }

    public final void resetUploadCount() {
        this.uploadCount = 0;
    }

    public final int getDeleteCount() {
        return this.deleteCount;
    }

    public final void resetDeleteCount() {
        this.deleteCount = 0;
    }

    public final void setDataChannelCallback(DataChannelCallback dataChannelCallback) {
        this.dataChannelCallback = dataChannelCallback;
        if (this.control != null) {
            this.control.setDataChannelCallback(dataChannelCallback);
        }
    }

    public final void setStrictReturnCodes(boolean bl) {
        this.strictReturnCodes = bl;
        if (this.control != null) {
            this.control.setStrictReturnCodes(bl);
        }
    }

    public final boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public final void setListenOnAllInterfaces(boolean bl) {
        this.listenOnAllInterfaces = bl;
        if (this.control != null) {
            this.control.setListenOnAllInterfaces(bl);
        }
    }

    public final boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    public final FileNotFoundStrings getFileNotFoundMessages() {
        return this.fileNotFoundStrings;
    }

    public final void setFileNotFoundMessages(FileNotFoundStrings fileNotFoundStrings) {
        this.fileNotFoundStrings = fileNotFoundStrings;
    }

    public final TransferCompleteStrings getTransferCompleteMessages() {
        return this.transferCompleteStrings;
    }

    public final void setTransferCompleteMessages(TransferCompleteStrings transferCompleteStrings) {
        this.transferCompleteStrings = transferCompleteStrings;
    }

    public final DirectoryEmptyStrings getDirectoryEmptyMessages() {
        return this.dirEmptyStrings;
    }

    public final void setDirectoryEmptyMessages(DirectoryEmptyStrings directoryEmptyStrings) {
        this.dirEmptyStrings = directoryEmptyStrings;
    }

    public final void setDetectTransferMode(boolean bl) {
        this.detectTransferMode = bl;
    }

    public final boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    public final void setFileLockingEnabled(boolean bl) {
        this.fileLockingEnabled = bl;
    }

    public final boolean getFileLockingEnabled() {
        return this.fileLockingEnabled;
    }

    public final void setForceUniqueNames(boolean bl) {
        this.storeCommand = bl ? STORE_UNIQ_CMD : STORE_CMD;
    }

    protected final FTPTransferType chooseTransferMode(String string) {
        if (this.detectTransferMode) {
            if (string == null) {
                log.warn("Cannot choose transfer mode as filename not supplied");
                return this.getType();
            }
            if (FileTypes.ASCII.matches(string) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.setType(FTPTransferType.ASCII);
                log.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(string) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.setType(FTPTransferType.BINARY);
                log.debug("Autodetect on - changed transfer type to binary");
            }
        }
        return this.getType();
    }

    public final void setTimeout(int n) {
        this.timeout = n;
        if (this.control != null) {
            this.control.setTimeout(n);
        }
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final int getRemotePort() {
        return this.controlPort;
    }

    public final void setRemotePort(int n) {
        this.checkConnection(false);
        this.controlPort = n;
    }

    public final int getControlPort() {
        return this.controlPort;
    }

    public final void setControlPort(int n) {
        this.checkConnection(false);
        this.controlPort = n;
    }

    public final InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public final void setRemoteAddr(InetAddress inetAddress) {
        this.checkConnection(false);
        this.remoteAddr = inetAddress;
        this.remoteHost = inetAddress.getHostAddress();
    }

    public final String getRemoteHost() {
        return this.remoteHost;
    }

    public final void setRemoteHost(String string) {
        this.checkConnection(false);
        this.remoteHost = string;
    }

    public final boolean isAutoPassiveIPSubstitution() {
        return this.autoPassiveIPSubstitution;
    }

    public final void setAutoPassiveIPSubstitution(boolean bl) {
        this.autoPassiveIPSubstitution = bl;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(bl);
        }
    }

    public final int getServerWakeupInterval() {
        return this.serverWakeupInterval;
    }

    public final void setServerWakeupInterval(int n) {
        this.serverWakeupInterval = n;
    }

    public final String getControlEncoding() {
        return this.controlEncoding;
    }

    public final int getNetworkBufferSize() {
        return this.dataReceiveBufferSize;
    }

    public final void setNetworkBufferSize(int n) {
        this.dataReceiveBufferSize = this.dataSendBufferSize = n;
    }

    public final void setDataReceiveBufferSize(int n) {
        this.dataReceiveBufferSize = n;
    }

    public final int getDataReceiveBufferSize() {
        return this.dataReceiveBufferSize;
    }

    public final void setDataSendBufferSize(int n) {
        this.dataSendBufferSize = n;
    }

    public final int getDataSendBufferSize() {
        return this.dataSendBufferSize;
    }

    public final void setControlEncoding(String string) {
        this.checkConnection(false);
        this.controlEncoding = string;
    }

    public final FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public final void setMessageListener(FTPMessageListener fTPMessageListener) {
        this.messageListener = fTPMessageListener;
        if (this.control != null) {
            this.control.setMessageListener(fTPMessageListener);
        }
    }

    public final FTPProgressMonitorEx getProgressMonitorEx() {
        return this.monitorEx;
    }

    public final void setProgressMonitorEx(FTPProgressMonitorEx fTPProgressMonitorEx) {
        this.monitorEx = fTPProgressMonitorEx;
        this.monitor = fTPProgressMonitorEx;
    }

    public final void setConnectMode(FTPConnectMode fTPConnectMode) {
        this.connectMode = fTPConnectMode;
    }

    public final FTPConnectMode getConnectMode() {
        return this.connectMode;
    }

    public final void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor, long l2) {
        this.monitor = fTPProgressMonitor;
        this.monitorInterval = l2;
    }

    public final void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor) {
        this.monitor = fTPProgressMonitor;
    }

    public final FTPProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public final long getMonitorInterval() {
        return this.monitorInterval;
    }

    public final void setMonitorInterval(long l2) {
        this.monitorInterval = l2;
    }

    public final void setTransferBufferSize(int n) {
        this.transferBufferSize = n;
    }

    public final int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public final void cancelTransfer() {
        this.cancelTransfer = true;
        log.warn("cancelTransfer() called");
    }

    public final boolean isTransferCancelled() {
        return this.cancelTransfer;
    }

    public final boolean isDeleteOnFailure() {
        return this.deleteOnFailure;
    }

    public final void setDeleteOnFailure(boolean bl) {
        this.deleteOnFailure = bl;
    }

    public final void setPORTIP(String string) {
        this.setActiveIPAddress(string);
    }

    public final void setActiveIPAddress(String string) {
        this.activeIP = string;
        if (this.control != null) {
            this.control.setActivePortIPAddress(string);
        }
    }

    public final String getActiveIPAddress() {
        return this.activeIP;
    }

    public final void setActivePortRange(int n, int n2) {
        this.lowPort = n;
        this.highPort = n2;
        if (n < 0 || n > n2 || n2 > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        if (this.control != null) {
            this.control.setActivePortRange(n, n2);
        }
        log.debug("setActivePortRange(" + n + "," + n2 + ")");
    }

    public final int getActiveLowPort() {
        return this.lowPort;
    }

    public final int getActiveHighPort() {
        return this.highPort;
    }

    public final void login(String string, String string2) {
        this.checkConnection(true);
        this.user = string;
        this.password = string2;
        this.user(string);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(string2);
    }

    public final void login(String string, String string2, String string3) {
        this.checkConnection(true);
        this.user = string;
        this.password = string2;
        this.user(string);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(string2);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(string3);
        }
    }

    public final void user(String string) {
        this.checkConnection(true);
        this.user = string;
        this.lastReply = this.control.sendCommand("USER " + string);
        String[] stringArray = new String[]{"230", "232", "331"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public final void password(String string) {
        this.checkConnection(true);
        this.password = string;
        this.lastReply = this.control.sendCommand("PASS " + string);
        String[] stringArray = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public final void account(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ACCT " + string);
        String[] stringArray = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public static final void initSOCKS(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put(SOCKS_PORT, string);
        properties.put(SOCKS_HOST, string2);
        System.setProperties(properties);
    }

    public static final void initSOCKSAuthentication(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put("java.net.socks.username", string);
        properties.put("java.net.socks.password", string2);
        System.setProperties(properties);
    }

    public static final void clearSOCKS() {
        Properties properties = System.getProperties();
        properties.remove(SOCKS_HOST);
        properties.remove(SOCKS_PORT);
        System.setProperties(properties);
    }

    private final String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public final String quote(String string, String[] stringArray) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand(string);
        this.lastValidReply = stringArray != null ? this.control.validateReply(this.lastReply, stringArray) : this.lastReply;
        return this.lastValidReply.getReplyText();
    }

    public final String quote(String string) {
        this.checkConnection(true);
        this.lastValidReply = this.control.sendCommand(string);
        return this.lastValidReply.getRawReply();
    }

    public final String executeCommand(String string) {
        return this.quote(string);
    }

    public final boolean existsFile(String string) {
        char c2;
        this.checkConnection(true);
        if (this.sizeSupported) {
            this.lastReply = this.control.sendCommand("SIZE " + string);
            c2 = this.lastReply.getReplyCode().charAt(0);
            if (c2 == '2') {
                return true;
            }
            if (c2 == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.sizeSupported = false;
            log.debug("SIZE not supported - trying MDTM");
        }
        if (this.mdtmSupported) {
            this.lastReply = this.control.sendCommand("MDTM " + string);
            c2 = this.lastReply.getReplyCode().charAt(0);
            if (c2 == '2') {
                return true;
            }
            if (c2 == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.mdtmSupported = false;
            log.debug("MDTM not supported - trying LIST");
        }
        try {
            FTPFile[] fTPFileArray = this.dirDetails(".");
            for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                if (!fTPFileArray[i2].getName().equals(string)) continue;
                return fTPFileArray[i2].isFile();
            }
            return false;
        }
        catch (ParseException parseException) {
            log.warn(parseException.getMessage());
            return false;
        }
    }

    public final boolean existsDirectory(String string) {
        String string2 = this.pwd();
        try {
            this.chdir(string);
        }
        catch (Exception exception) {
            return false;
        }
        this.chdir(string2);
        return true;
    }

    public final boolean exists(String string) {
        return this.existsFile(string);
    }

    final FTPReply readReply() {
        return this.control.readReply();
    }

    private final String getPASVAddress(String string) {
        int n;
        int n2 = -1;
        for (n = 0; n < string.length(); ++n) {
            if (!Character.isDigit(string.charAt(n))) continue;
            n2 = n;
            break;
        }
        int n3 = -1;
        for (n = string.length() - 1; n >= 0; --n) {
            if (!Character.isDigit(string.charAt(n))) continue;
            n3 = n;
            break;
        }
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        return string.substring(n2, n3 + 1);
    }

    public final FTPReply sendCommand(String string) {
        return this.control.sendCommand(string);
    }

    public final void validateReply(FTPReply fTPReply, String string) {
        this.control.validateReply(fTPReply, string);
    }

    public final void validateReply(FTPReply fTPReply, String[] stringArray) {
        this.control.validateReply(fTPReply, stringArray);
    }

    public final long size(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SIZE " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        String string2 = this.lastValidReply.getReplyText();
        int n = string2.indexOf(32);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FTPException("Failed to parse reply: " + string2);
        }
    }

    public final void resume() {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.resume = true;
        log.info("Resume=true");
    }

    public final void resumeNextDownload(long l2) {
        this.resume();
        if (l2 < 0L) {
            throw new FTPException("Offset must be >= 0");
        }
        this.resumeMarker = l2;
    }

    public final void cancelResume() {
        try {
            this.restart(0L);
        }
        catch (FTPException fTPException) {
            log.debug("REST failed which is ok (" + fTPException.getMessage() + ")");
        }
        this.resumeMarker = 0L;
        this.resume = false;
    }

    protected final void forceResumeOff() {
        this.resume = false;
        this.resumeMarker = 0L;
    }

    public final void restart(long l2) {
        this.lastReply = this.control.sendCommand("REST " + l2);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final void setRetryCount(int n) {
        this.retryCount = n;
    }

    public final int getRetryDelay() {
        return this.retryDelay;
    }

    public final void setRetryDelay(int n) {
        this.retryDelay = n;
    }

    private boolean processTransferException(Exception exception, int n) {
        if (n <= this.retryCount + 1) {
            if (this.retryDelay > 0) {
                try {
                    log.debug("Sleeping for " + this.retryDelay + " ms prior to retry");
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            log.error("Transfer error on attempt #" + n + " retrying: ", exception);
            return true;
        }
        if (n > 0) {
            log.info("Failed " + n + " attempts - giving up");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get(String string, String string2) {
        FTPTransferType fTPTransferType;
        block12: {
            String string3 = this.safePwd();
            FTPTransferType fTPTransferType2 = this.transferType;
            fTPTransferType = this.chooseTransferMode(string2);
            File file = new File(string);
            if (file.isDirectory()) {
                string = string + File.separator + string2;
                log.debug("Setting local path to " + string);
            }
            try {
                if (this.retryCount == 0) {
                    this.getFile(string, string2);
                    break block12;
                }
                int n = 1;
                while (true) {
                    block13: {
                        try {
                            if (n > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + n);
                            this.getFile(string, string2);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.processControlChannelException(string3, controlChannelIOException, n)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.processTransferException(iOException, n)) break block13;
                            throw iOException;
                        }
                    }
                    ++n;
                }
            }
            finally {
                this.resetTransferMode(fTPTransferType2);
            }
        }
        this.postTransferChecks(string, string2, fTPTransferType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String put(InputStream inputStream, String string, boolean bl) {
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(string);
        try {
            String string2 = this.putStream(inputStream, string, bl);
            return string2;
        }
        finally {
            this.resetTransferMode(fTPTransferType);
        }
    }

    private boolean processControlChannelException(String string, Exception exception, int n) {
        if (n <= this.retryCount + 1) {
            if (this.retryDelay > 0) {
                try {
                    log.debug("Sleeping for " + this.retryDelay + " ms prior to retry");
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            log.error("Transfer error on attempt #" + n + ": reconnecting & retrying: ", exception);
            this.reconnect(string);
            return true;
        }
        log.info("Failed " + n + " attempts - giving up");
        return false;
    }

    protected final void reconnect(String string) {
        try {
            this.quitImmediately();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Reconnecting");
        this.connect();
        this.login(this.user, this.password);
        this.setType(this.transferType);
        if (string != null) {
            this.chdir(string);
        }
    }

    public final String put(String string, String string2) {
        return this.put(string, string2, false);
    }

    public final String put(InputStream inputStream, String string) {
        return this.put(inputStream, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String put(String string, String string2, boolean bl) {
        FTPTransferType fTPTransferType;
        block11: {
            String string3 = this.safePwd();
            FTPTransferType fTPTransferType2 = this.transferType;
            fTPTransferType = this.chooseTransferMode(string2);
            try {
                FileInputStream fileInputStream = null;
                if (this.retryCount == 0 || bl) {
                    fileInputStream = new FileInputStream(string);
                    string2 = this.putStream(fileInputStream, string2, bl);
                    break block11;
                }
                int n = 1;
                while (true) {
                    block12: {
                        try {
                            if (n > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + n);
                            fileInputStream = new FileInputStream(string);
                            string2 = this.putStream(fileInputStream, string2, bl);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.processControlChannelException(string3, controlChannelIOException, n)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.processTransferException(iOException, n)) break block12;
                            throw iOException;
                        }
                    }
                    ++n;
                }
            }
            finally {
                this.resetTransferMode(fTPTransferType2);
            }
        }
        this.postTransferChecks(string, string2, fTPTransferType, bl);
        return string2;
    }

    private String putStream(InputStream inputStream, String string, boolean bl) {
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.UPLOAD, string);
            }
            string = this.putData(inputStream, string, bl);
            this.validateTransfer();
            ++this.uploadCount;
        }
        catch (FTPException fTPException) {
            throw fTPException;
        }
        catch (ControlChannelIOException controlChannelIOException) {
            throw controlChannelIOException;
        }
        catch (IOException iOException) {
            this.validateTransferOnError(iOException);
            throw iOException;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, string);
            }
        }
        return string;
    }

    public final void validateTransfer() {
        this.checkConnection(true);
        String[] stringArray = new String[]{"225", "226", "250"};
        this.lastReply = this.control.readReply();
        if (this.cancelTransfer) {
            this.lastValidReply = this.lastReply;
            log.warn("Transfer has been cancelled!");
            throw new FTPTransferCancelledException();
        }
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void validateTransferOnError(IOException iOException) {
        log.debug("Validate transfer on error after exception", iOException);
        this.checkConnection(true);
        this.control.setTimeout(500);
        try {
            this.validateTransfer();
        }
        catch (Exception exception) {
            log.warn("Validate transfer on error failed", exception);
        }
        finally {
            this.control.setTimeout(this.timeout);
        }
    }

    private void closeDataSocket() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException iOException) {
                log.warn("Caught exception closing data socket", iOException);
            }
        }
    }

    protected final void closeDataSocket(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn("Caught exception closing data socket", iOException);
            }
        }
        this.closeDataSocket();
    }

    protected final void closeDataSocket(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                log.warn("Caught exception closing data socket", iOException);
            }
        }
        this.closeDataSocket();
    }

    protected final void setupDataSocket() {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        if (this.dataReceiveBufferSize > 0) {
            this.data.setReceiveBufferSize(this.dataReceiveBufferSize);
        }
        if (this.dataSendBufferSize > 0) {
            this.data.setSendBufferSize(this.dataSendBufferSize);
        }
    }

    protected final String initPut(String string, boolean bl) {
        boolean bl2;
        this.checkConnection(true);
        boolean bl3 = bl2 = string == null || string.length() == 0;
        if (bl2) {
            string = "";
            if (bl) {
                String string2 = "A remote filename must be supplied when appending";
                log.error(string2);
                throw new FTPException(string2);
            }
        }
        this.cancelTransfer = false;
        boolean bl4 = false;
        try {
            this.resumeMarker = 0L;
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                try {
                    this.resumeMarker = this.size(string);
                }
                catch (FTPException fTPException) {
                    this.resumeMarker = 0L;
                    this.resume = false;
                    log.warn("SIZE failed '" + string + "' - resume will not be used (" + fTPException.getMessage() + ")");
                }
            }
            this.setupDataSocket();
            if (this.resume) {
                try {
                    this.restart(this.resumeMarker);
                }
                catch (FTPException fTPException) {
                    this.resumeMarker = 0L;
                    this.resume = false;
                    log.warn("REST failed - resume will not be used (" + fTPException.getMessage() + ")");
                }
            }
            String string3 = bl ? "APPE " : (bl2 ? "STOU" : this.storeCommand);
            this.lastReply = this.control.sendCommand(string3 + string);
            String[] stringArray = new String[]{"125", "150", "151", "350"};
            this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            String string4 = this.lastValidReply.getReplyText();
            if (bl2) {
                int n = string4.indexOf(STOU_FILENAME_MARKER);
                if (n >= 0) {
                    string = string4.substring(n += STOU_FILENAME_MARKER.length()).trim();
                } else {
                    log.debug("Could not find FILE: in reply - using last word instead.");
                    n = string4.lastIndexOf(32);
                    string = string4.substring(++n);
                    int n2 = string.length();
                    if (n2 > 0 && string.charAt(n2 - 1) == '.') {
                        string = string.substring(0, n2 - 1);
                    }
                }
            }
            String string5 = string;
            return string5;
        }
        catch (IOException iOException) {
            bl4 = true;
            log.error("Caught and rethrowing exception in initPut()", iOException);
            throw iOException;
        }
        catch (FTPException fTPException) {
            bl4 = true;
            log.error("Caught and rethrowing exception in initPut()", fTPException);
            throw fTPException;
        }
        finally {
            if (bl4) {
                this.resume = false;
                this.resumeMarker = 0L;
                this.closeDataSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String putData(InputStream inputStream, String string, boolean bl) {
        block31: {
            long l2;
            BufferedOutputStream bufferedOutputStream;
            BufferedInputStream bufferedInputStream;
            IOException iOException;
            block29: {
                iOException = null;
                bufferedInputStream = null;
                bufferedOutputStream = null;
                l2 = 0L;
                bufferedInputStream = new BufferedInputStream(inputStream);
                string = this.initPut(string, bl);
                bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.getOutputStream()), this.transferBufferSize * 2);
                if (this.resume && this.resumeMarker > 0L) {
                    bufferedInputStream.skip(this.resumeMarker);
                } else {
                    this.resumeMarker = 0L;
                }
                byte[] byArray = new byte[this.transferBufferSize];
                byte[] byArray2 = new byte[FTP_LINE_SEPARATOR.length];
                int n = 0;
                long l3 = 0L;
                int n2 = 0;
                boolean bl2 = this.getType() == FTPTransferType.ASCII;
                long l4 = System.currentTimeMillis();
                if (this.throttler != null) {
                    this.throttler.reset();
                }
                while ((n2 = bufferedInputStream.read(byArray)) > 0 && !this.cancelTransfer) {
                    if (bl2) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (byArray[i2] == 10 && n == 0) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                                continue;
                            }
                            if (byArray[i2] == FTP_LINE_SEPARATOR[n]) {
                                byArray2[n] = byArray[i2];
                                if (++n != FTP_LINE_SEPARATOR.length) continue;
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                                n = 0;
                                continue;
                            }
                            if (n > 0) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                            }
                            bufferedOutputStream.write(byArray[i2]);
                            ++l2;
                            ++l3;
                            n = 0;
                        }
                    } else {
                        bufferedOutputStream.write(byArray, 0, n2);
                        l2 += (long)n2;
                        l3 += (long)n2;
                    }
                    if (this.throttler != null) {
                        this.throttler.throttleTransfer(l2);
                    }
                    if (this.monitor != null && l3 > this.monitorInterval) {
                        this.monitor.bytesTransferred(l2);
                        l3 = 0L;
                    }
                    if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - l4 <= (long)(this.serverWakeupInterval * 1000)) continue;
                    l4 = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
                if (!bl2 || n <= 0) break block29;
                bufferedOutputStream.write(13);
                bufferedOutputStream.write(10);
                l2 += 2L;
                l3 += 2L;
            }
            Object var20_17 = null;
            this.resume = false;
            this.resumeMarker = 0L;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException2) {
                log.warn("Caught exception closing input stream", iOException2);
            }
            this.closeDataSocket(bufferedOutputStream);
            if (iOException != null) {
                throw iOException;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(l2);
            }
            log.debug("Transferred " + l2 + " bytes to remote host");
            {
                break block31;
                catch (IOException iOException3) {
                    iOException = iOException3;
                    log.error("Caught and rethrowing exception in getDataAfterInitGet()", iOException3);
                    Object var20_18 = null;
                    this.resume = false;
                    this.resumeMarker = 0L;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException4) {
                        log.warn("Caught exception closing input stream", iOException4);
                    }
                    this.closeDataSocket(bufferedOutputStream);
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(l2);
                    }
                    log.debug("Transferred " + l2 + " bytes to remote host");
                }
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                this.resume = false;
                this.resumeMarker = 0L;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    log.warn("Caught exception closing input stream", iOException5);
                }
                this.closeDataSocket(bufferedOutputStream);
                if (iOException != null) {
                    throw iOException;
                }
                if (this.monitor != null) {
                    this.monitor.bytesTransferred(l2);
                }
                log.debug("Transferred " + l2 + " bytes to remote host");
                throw throwable;
            }
        }
        return string;
    }

    public final String put(byte[] byArray, String string) {
        return this.put(byArray, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String put(byte[] byArray, String string, boolean bl) {
        String string2 = this.safePwd();
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(string);
        String string3 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.retryCount == 0 || bl) {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                string3 = this.putStream(byteArrayInputStream, string, bl);
            } else {
                int n = 1;
                while (true) {
                    block11: {
                        try {
                            if (n > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            log.debug("Attempt #" + n);
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            string3 = this.putStream(byteArrayInputStream, string, bl);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.processControlChannelException(string2, controlChannelIOException, n)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.processTransferException(iOException, n)) break block11;
                            throw iOException;
                        }
                    }
                    ++n;
                }
            }
            Object var12_14 = null;
            this.resetTransferMode(fTPTransferType);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.postTransferChecks(byArray, string, fTPTransferType2, bl);
        return string3;
    }

    private void getFile(String string, String string2) {
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, string2);
                }
                this.getData(string, string2);
                this.validateTransfer();
                ++this.downloadCount;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                this.validateTransferOnError(iOException);
                throw iOException;
            }
            Object var5_3 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string2);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string2);
            }
            throw throwable;
        }
    }

    protected final void postTransferChecks(String string, String string2, FTPTransferType fTPTransferType, boolean bl) {
    }

    protected final void postTransferChecks(byte[] byArray, String string, FTPTransferType fTPTransferType, boolean bl) {
    }

    public final void get(OutputStream outputStream, String string) {
        FTPTransferType fTPTransferType = this.transferType;
        this.chooseTransferMode(string);
        boolean bl = true;
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, string);
                }
                this.getData(outputStream, string);
                this.validateTransfer();
                ++this.downloadCount;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                bl = false;
                this.validateTransferOnError(iOException);
                throw iOException;
            }
            Object var7_5 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string);
            }
            if (bl) {
                this.resetTransferMode(fTPTransferType);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string);
            }
            if (bl) {
                this.resetTransferMode(fTPTransferType);
            }
            throw throwable;
        }
    }

    public final void resetTransferMode(FTPTransferType fTPTransferType) {
        if (!this.transferType.equals(fTPTransferType)) {
            this.setType(fTPTransferType);
        }
    }

    protected final void initGet(String string) {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean bl = false;
        try {
            try {
                this.setupDataSocket();
                if (this.resume) {
                    if (this.transferType.equals(FTPTransferType.ASCII)) {
                        throw new FTPException("Resume only supported for BINARY transfers");
                    }
                    try {
                        this.restart(this.resumeMarker);
                    }
                    catch (FTPException fTPException) {
                        this.resumeMarker = 0L;
                        this.resume = false;
                        log.warn("REST failed - resume will not be used (" + fTPException.getMessage() + ")");
                    }
                } else {
                    this.resumeMarker = 0L;
                }
                this.lastReply = this.control.sendCommand("RETR " + string);
                String[] stringArray = new String[]{"125", "150"};
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            }
            catch (IOException iOException) {
                bl = true;
                log.error("Caught and rethrowing exception in initGet()", iOException);
                throw iOException;
            }
            catch (FTPException fTPException) {
                bl = true;
                log.error("Caught and rethrowing exception in initGet()", fTPException);
                throw fTPException;
            }
            Object var5_7 = null;
            if (bl) {
                this.resume = false;
                this.resumeMarker = 0L;
                this.closeDataSocket();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (bl) {
                this.resume = false;
                this.resumeMarker = 0L;
                this.closeDataSocket();
            }
            throw throwable;
        }
    }

    private void getData(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new FTPException(string + " is readonly - cannot write");
            }
            if (this.resume) {
                if (this.resumeMarker == 0L) {
                    this.resumeMarker = file.length();
                } else {
                    log.debug("Resume marker already set explicitly: " + this.resumeMarker);
                }
            } else {
                this.resumeMarker = 0L;
            }
        }
        this.initGet(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(string, this.resume);
        if (this.fileLockingEnabled) {
            String string3 = "Failed to obtain an exclusive write lock: " + string;
            try {
                if (fileOutputStream.getChannel().tryLock() == null) {
                    log.warn(string3);
                }
            }
            catch (Exception exception) {
                log.warn(string3);
            }
        }
        try {
            this.getDataAfterInitGet(fileOutputStream);
        }
        catch (IOException iOException) {
            if (this.deleteOnFailure) {
                file.delete();
                log.debug("Deleting local file '" + file.getAbsolutePath() + "'");
            } else {
                log.debug("Possibly partial local file not deleted");
            }
            throw iOException;
        }
    }

    private void getData(OutputStream outputStream, String string) {
        this.initGet(string);
        this.getDataAfterInitGet(outputStream);
    }

    protected final InputStream getInputStream() {
        return this.data.getInputStream();
    }

    protected final OutputStream getOutputStream() {
        return this.data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getDataAfterInitGet(OutputStream outputStream) {
        block28: {
            IOException iOException;
            long l2;
            BufferedInputStream bufferedInputStream;
            BufferedOutputStream bufferedOutputStream;
            block26: {
                int n;
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                bufferedInputStream = null;
                l2 = 0L;
                iOException = null;
                bufferedInputStream = new BufferedInputStream(new DataInputStream(this.getInputStream()));
                long l3 = 0L;
                byte[] byArray = new byte[this.transferBufferSize];
                boolean bl = this.getType() == FTPTransferType.ASCII;
                long l4 = System.currentTimeMillis();
                if (this.throttler != null) {
                    this.throttler.reset();
                }
                byte[] byArray2 = new byte[FTP_LINE_SEPARATOR.length];
                int n2 = 0;
                while ((n = this.readChunk(bufferedInputStream, byArray, this.transferBufferSize)) >= 0 && !this.cancelTransfer) {
                    if (bl) {
                        for (int i2 = 0; i2 < n; ++i2) {
                            if (byArray[i2] == FTP_LINE_SEPARATOR[n2]) {
                                byArray2[n2] = byArray[i2];
                                if (++n2 != FTP_LINE_SEPARATOR.length) continue;
                                bufferedOutputStream.write(LINE_SEPARATOR);
                                l2 += (long)LINE_SEPARATOR.length;
                                l3 += (long)LINE_SEPARATOR.length;
                                n2 = 0;
                                continue;
                            }
                            if (n2 > 0) {
                                bufferedOutputStream.write(byArray2, 0, n2);
                                l2 += (long)n2;
                                l3 += (long)n2;
                            }
                            bufferedOutputStream.write(byArray[i2]);
                            ++l2;
                            ++l3;
                            n2 = 0;
                        }
                    } else {
                        bufferedOutputStream.write(byArray, 0, n);
                        l2 += (long)n;
                        l3 += (long)n;
                    }
                    if (this.throttler != null) {
                        this.throttler.throttleTransfer(l2);
                    }
                    if (this.monitor != null && l3 > this.monitorInterval) {
                        this.monitor.bytesTransferred(l2);
                        l3 = 0L;
                    }
                    if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - l4 <= (long)(this.serverWakeupInterval * 1000)) continue;
                    l4 = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
                if (!bl || n2 <= 0) break block26;
                bufferedOutputStream.write(byArray2, 0, n2);
                l2 += (long)n2;
                l3 += (long)n2;
            }
            Object var18_15 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                log.warn("Caught exception closing output stream", iOException2);
            }
            this.resume = false;
            this.resumeMarker = 0L;
            this.closeDataSocket(bufferedInputStream);
            if (iOException != null) {
                throw iOException;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(l2);
            }
            log.debug("Transferred " + l2 + " bytes from remote host");
            {
                break block28;
                catch (IOException iOException3) {
                    iOException = iOException3;
                    log.error("Caught and rethrowing exception in getDataAfterInitGet()", iOException3);
                    Object var18_16 = null;
                    try {
                        if (bufferedOutputStream != null) {
                            bufferedOutputStream.close();
                        }
                    }
                    catch (IOException iOException4) {
                        log.warn("Caught exception closing output stream", iOException4);
                    }
                    this.resume = false;
                    this.resumeMarker = 0L;
                    this.closeDataSocket(bufferedInputStream);
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(l2);
                    }
                    log.debug("Transferred " + l2 + " bytes from remote host");
                }
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                try {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    log.warn("Caught exception closing output stream", iOException5);
                }
                this.resume = false;
                this.resumeMarker = 0L;
                this.closeDataSocket(bufferedInputStream);
                if (iOException != null) {
                    throw iOException;
                }
                if (this.monitor != null) {
                    this.monitor.bytesTransferred(l2);
                }
                log.debug("Transferred " + l2 + " bytes from remote host");
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] get(String string) {
        FTPTransferType fTPTransferType = this.transferType;
        this.chooseTransferMode(string);
        boolean bl = true;
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, string);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.transferBufferSize);
                this.getData(byteArrayOutputStream, string);
                this.validateTransfer();
                ++this.downloadCount;
                byte[] byArray = byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
                Object var7_9 = null;
                if (this.monitorEx != null) {
                    this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string);
                }
                if (!bl) return byArray;
                this.resetTransferMode(fTPTransferType);
                return byArray;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                bl = false;
                this.validateTransferOnError(iOException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string);
            }
            if (!bl) throw throwable;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
    }

    public final boolean site(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SITE " + string);
        String[] stringArray = new String[]{"200", "202", "250", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastReply.getReplyCode().equals("200");
    }

    public final String list(String string) {
        return this.list(string, false);
    }

    public final String list(String string, boolean bl) {
        String[] stringArray = this.dir(string, bl);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public final void setFTPFileFactory(FTPFileFactory fTPFileFactory) {
        this.fileFactory = fTPFileFactory;
        log.debug("Set new FTPFileFactory: " + fTPFileFactory.toString());
    }

    public final void setParserLocale(Locale locale) {
        this.listingLocales = new Locale[1];
        this.listingLocales[0] = locale;
    }

    public final void setParserLocales(Locale[] localeArray) {
        this.listingLocales = localeArray;
    }

    public final FTPFile fileDetails(String string) {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("MLST " + string);
            this.lastValidReply = this.control.validateReply(this.lastReply, "250");
            String[] stringArray = this.lastReply.getReplyData();
            if (stringArray != null && stringArray.length >= 2) {
                return this.mlsxParser.parse(this.lastReply.getReplyData()[1]);
            }
            throw new FTPException("Failed to retrieve data");
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            log.debug("MLST failed: " + exception.getMessage() + " Trying SIZE");
            try {
                String string2 = this.safePwd();
                long l2 = this.size(string);
                Date date = this.modtime(string);
                FTPFile fTPFile = new FTPFile("");
                fTPFile.setName(string);
                fTPFile.setLastModified(date);
                fTPFile.setSize(l2);
                fTPFile.setPath(string2);
                return fTPFile;
            }
            catch (FTPException fTPException) {
                String string3 = "Failed to retrieve file details for " + string + ": " + fTPException.getMessage();
                log.debug(string3);
                throw new FTPException(string3);
            }
        }
    }

    public final void dirDetails(String string, DirectoryListCallback directoryListCallback) {
        String string2 = this.setupDirDetails(string);
        FTPClient$DirectoryCallbackImpl fTPClient$DirectoryCallbackImpl = new FTPClient$DirectoryCallbackImpl(this, this.fileFactory, directoryListCallback, string2);
        this.dir(string, true, null, fTPClient$DirectoryCallbackImpl);
    }

    public final FTPFile[] dirDetails(String string) {
        String string2 = this.setupDirDetails(string);
        FTPFile[] fTPFileArray = this.fileFactory.parse(this.dir(string, true));
        if (string2 != null) {
            for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                fTPFileArray[i2].setPath(string2);
            }
        }
        return fTPFileArray;
    }

    private String setupDirDetails(String string) {
        if (this.fileFactory == null) {
            try {
                this.fileFactory = new FTPFileFactory(this.system());
            }
            catch (FTPException fTPException) {
                log.warn("SYST command failed - setting Unix as default parser", fTPException);
                this.fileFactory = new FTPFileFactory("UNIX");
            }
        }
        this.fileFactory.setLocales(this.listingLocales);
        String string2 = this.safePwd();
        if (string2 != null && string != null && string.length() > 0 && string.indexOf(42) < 0 && string.indexOf(63) < 0 && !string.equals(".")) {
            string2 = string2 + "/" + string;
        }
        log.debug("setupDirDetails(" + string + ") returning: " + string2);
        return string2;
    }

    public final String[] dir() {
        return this.dir(null, false);
    }

    public final String[] dir(String string) {
        return this.dir(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dir(String string, boolean bl, Vector vector, FTPClient$DirectoryCallback fTPClient$DirectoryCallback) {
        this.checkConnection(true);
        this.cancelTransfer = false;
        try {
            String string2;
            this.setupDataSocket();
            String string3 = string2 = bl ? "LIST " : "NLST ";
            if (string != null) {
                string2 = string2 + string;
            }
            string2 = string2.trim();
            this.lastReply = this.control.sendCommand(string2);
            String[] stringArray = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            Object[] objectArray = new String[]{};
            String string4 = this.lastValidReply.getReplyCode();
            if (!(string4.equals("450") || string4.equals("550") || string4.equals("226"))) {
                String[] stringArray2;
                block19: {
                    BufferedReader bufferedReader = null;
                    bufferedReader = new LineNumberReader(new InputStreamReader(this.getInputStream(), this.controlEncoding));
                    stringArray2 = null;
                    while ((stringArray2 = this.readLine((LineNumberReader)bufferedReader)) != null && !this.cancelTransfer) {
                        DirectoryListArgument directoryListArgument;
                        if (vector != null) {
                            vector.addElement(stringArray2);
                        }
                        if (fTPClient$DirectoryCallback != null && (directoryListArgument = fTPClient$DirectoryCallback.listEntry((String)stringArray2)) != null && directoryListArgument.isListingAborted()) {
                            log.warn("Aborting listing");
                            this.cancelTransfer = true;
                        }
                        log.log(Level.ALL, (String)stringArray2, null);
                    }
                    Object var13_14 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {
                        log.error("Failed to close socket in dir()", iOException);
                    }
                    {
                        break block19;
                        catch (IOException iOException) {
                            this.validateTransferOnError(iOException);
                            throw iOException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            log.error("Failed to close socket in dir()", iOException);
                        }
                        this.closeDataSocket();
                        throw throwable;
                    }
                }
                this.closeDataSocket();
                stringArray2 = new String[]{"226", "250"};
                this.lastReply = this.control.readReply();
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray2);
                if (vector != null && !vector.isEmpty()) {
                    objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                }
            } else {
                String string5 = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.dirEmptyStrings.matches(string5) && !this.transferCompleteStrings.matches(string5)) {
                    throw new FTPException(this.lastReply);
                }
            }
            Object var16_19 = null;
            this.closeDataSocket();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.closeDataSocket();
            throw throwable;
        }
    }

    public final String[] dir(String string, boolean bl) {
        Vector vector = new Vector();
        try {
            this.dir(string, bl, vector, null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Object[] objectArray = new String[]{};
        if (!vector.isEmpty()) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public final int readChunk(BufferedInputStream bufferedInputStream, byte[] byArray, int n) {
        return bufferedInputStream.read(byArray, 0, n);
    }

    public final int readChunk(BufferedInputStream bufferedInputStream, byte[] byArray, int n, int n2) {
        return bufferedInputStream.read(byArray, n, n2);
    }

    protected final int readChar(LineNumberReader lineNumberReader) {
        return lineNumberReader.read();
    }

    protected final String readLine(LineNumberReader lineNumberReader) {
        return lineNumberReader.readLine();
    }

    public final FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public final FTPReply getLastReply() {
        return this.lastReply;
    }

    public final FTPTransferType getType() {
        return this.transferType;
    }

    public final void setType(FTPTransferType fTPTransferType) {
        this.checkConnection(true);
        String string = FTPTransferType.ASCII_CHAR;
        if (fTPTransferType.equals(FTPTransferType.BINARY)) {
            string = FTPTransferType.BINARY_CHAR;
        }
        String[] stringArray = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("TYPE " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        this.transferType = fTPTransferType;
    }

    public final void delete(String string) {
        this.checkConnection(true);
        String[] stringArray = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("DELE " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        ++this.deleteCount;
    }

    public final void rename(String string, String string2) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RNFR " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
        this.lastReply = this.control.sendCommand("RNTO " + string2);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public final void rmdir(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RMD " + string);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public final void mkdir(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MKD " + string);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public final void chdir(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CWD " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public final void cdup() {
        this.checkConnection(true);
        if (this.cdupSupported) {
            this.lastReply = this.control.sendCommand("CDUP");
            String[] stringArray = new String[]{"200", "250"};
            try {
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            }
            catch (FTPException fTPException) {
                this.cdupSupported = false;
                log.debug("CDUP failed: " + fTPException.getMessage() + ". Trying CD");
            }
        }
        if (!this.cdupSupported) {
            this.chdir("..");
        }
    }

    public final Date modtime(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MDTM " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        Date date = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return date;
    }

    public final void setModTime(String string, Date date) {
        this.checkConnection(true);
        String string2 = this.tsFormat.format(date);
        this.lastReply = this.control.sendCommand("MFMT " + string2 + " " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
    }

    public final String pwd() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(this.lastReply, "257");
        String string = this.lastValidReply.getReplyText();
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        if (n >= 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string;
    }

    private String safePwd() {
        String string = null;
        try {
            string = this.pwd();
        }
        catch (FTPException fTPException) {
            log.debug("Ignoring exception: " + fTPException.getMessage());
        }
        return string;
    }

    public final String[] features() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("FEAT");
        String[] stringArray = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            String[] stringArray2 = null;
            String[] stringArray3 = this.lastValidReply.getReplyData();
            if (stringArray3 != null && stringArray3.length > 2) {
                stringArray2 = new String[stringArray3.length - 2];
                for (int i2 = 0; i2 < stringArray3.length - 2; ++i2) {
                    stringArray2[i2] = stringArray3[i2 + 1].trim();
                }
            } else {
                stringArray2 = new String[]{};
            }
            return stringArray2;
        }
        throw new FTPException(this.lastReply);
    }

    public final String system() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SYST");
        String[] stringArray = new String[]{"200", "213", "215", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    public final void noOperation() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("NOOP");
        String[] stringArray = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public final String stat() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("STAT");
        String[] stringArray = new String[]{"211", "212", "213"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    public final void sendServerWakeup() {
        this.noOperation();
    }

    public final void keepAlive() {
        log.debug("keepAlive() called");
        int n = (int)Math.ceil(Math.random() * 2.0);
        switch (n) {
            case 1: {
                this.noOperation();
                break;
            }
            case 2: {
                this.pwd();
                break;
            }
            default: {
                this.pwd();
            }
        }
    }

    public final String help(String string) {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("HELP " + string);
        String[] stringArray = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    protected final void abort() {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ABOR");
        String[] stringArray = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void quit() {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("QUIT");
            String[] stringArray = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.control.logout();
                Object var5_6 = null;
                this.control = null;
            }
            catch (Throwable throwable2) {
                Object var5_7 = null;
                this.control = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.control.logout();
            Object var5_4 = null;
            this.control = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.control = null;
            throw throwable;
        }
        this.closeDataSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void quitImmediately() {
        this.cancelTransfer();
        try {
            if (this.control != null && this.control.controlSock != null) {
                this.control.controlSock.close();
            }
            Object var2_1 = null;
            this.control = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.control = null;
            throw throwable;
        }
        this.closeDataSocket();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("FTP").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    static {
        log = Logger.getLogger("FTPClient");
        masterId = 0;
        DEFAULT_LISTING_LOCALES = new Locale[2];
        FTPClient.DEFAULT_LISTING_LOCALES[0] = Locale.ENGLISH;
        FTPClient.DEFAULT_LISTING_LOCALES[1] = Locale.getDefault();
    }
}

