/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPConnectionClosedException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.IPEndpoint;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.internal.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.internal.FTPPassiveDataSocket;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.PlainSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Random;
import java.util.Vector;

public class FTPControlSocket {
    public static final String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.61 2011-12-14 07:22:52 bruceb Exp $";
    static final String EOL = "\r\n";
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte LINE_FEED = 10;
    public static final int MAX_ACTIVE_RETRY = 100;
    public static final int CONTROL_PORT = 21;
    private static final String DEBUG_ARROW = "---> ";
    private static final String PASSWORD_MESSAGE = "---> PASS";
    private static final String ACCT_MESSAGE = "---> ACCT";
    private static Logger log = Logger.getLogger("FTPControlSocket");
    private boolean strictReturnCodes = true;
    protected boolean listenOnAllInterfaces = true;
    protected StreamSocket controlSock = null;
    protected Writer writer = null;
    protected Reader reader = null;
    private FTPMessageListener messageListener = null;
    protected String forcedActiveIP;
    private int lowPort = -1;
    private int highPort = -1;
    private int nextPort = 0;
    private String encoding;
    protected InetAddress remoteAddr;
    protected boolean autoPassiveIPSubstitution = false;
    protected DataChannelCallback dataChannelCallback = null;

    protected FTPControlSocket(InetAddress inetAddress, int n, int n2, String string, FTPMessageListener fTPMessageListener) {
        this(inetAddress, PlainSocket.createPlainSocket(inetAddress, n, n2), n2, string, fTPMessageListener);
    }

    protected FTPControlSocket(InetAddress inetAddress, StreamSocket streamSocket, int n, String string, FTPMessageListener fTPMessageListener) {
        this.remoteAddr = inetAddress;
        this.controlSock = streamSocket;
        this.messageListener = fTPMessageListener;
        this.encoding = string;
        try {
            this.setTimeout(n);
            this.initStreams();
            this.validateConnection();
        }
        catch (IOException iOException) {
            log.error("Failed to initialize control socket", iOException);
            streamSocket.close();
            streamSocket = null;
            throw iOException;
        }
        catch (FTPException fTPException) {
            log.error("Failed to initialize control socket", fTPException);
            streamSocket.close();
            streamSocket = null;
            throw fTPException;
        }
    }

    protected final void setAutoPassiveIPSubstitution(boolean bl) {
        this.autoPassiveIPSubstitution = bl;
    }

    private void validateConnection() {
        FTPReply fTPReply = this.readReply();
        String[] stringArray = new String[]{"220", "230"};
        this.validateReply(fTPReply, stringArray);
    }

    protected final void initStreams() {
        InputStream inputStream = this.controlSock.getInputStream();
        this.reader = new InputStreamReader(inputStream, this.encoding);
        OutputStream outputStream = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(outputStream, this.encoding);
    }

    public final boolean isSecureMode() {
        return false;
    }

    final String getRemoteHostName() {
        InetAddress inetAddress = this.controlSock.getInetAddress();
        return inetAddress.getHostName();
    }

    final void setStrictReturnCodes(boolean bl) {
        this.strictReturnCodes = bl;
    }

    final void setListenOnAllInterfaces(boolean bl) {
        this.listenOnAllInterfaces = bl;
    }

    private final boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    final void setTimeout(int n) {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(n);
    }

    final void setMessageListener(FTPMessageListener fTPMessageListener) {
        this.messageListener = fTPMessageListener;
    }

    public final void close() {
        this.controlSock.close();
    }

    public final void logout() {
        IOException iOException = null;
        try {
            this.writer.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException iOException4) {
            iOException = iOException4;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    final FTPDataSocket createDataSocket(FTPConnectMode fTPConnectMode) {
        if (fTPConnectMode == FTPConnectMode.ACTIVE) {
            return this.createDataSocketActive();
        }
        return this.createDataSocketPASV();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final FTPDataSocket createDataSocketActive() {
        try {
            FTPDataSocket fTPDataSocket;
            block6: {
                int n;
                int n2 = 0;
                int n3 = 100;
                if (this.lowPort >= 0 && this.highPort >= 0 && (n = this.highPort - this.lowPort + 1) < 100) {
                    n3 = n;
                }
                while (n2 < n3) {
                    ++n2;
                    try {
                        FTPDataSocket fTPDataSocket2 = this.newActiveDataSocket(this.nextPort);
                        int n4 = fTPDataSocket2.getLocalPort();
                        InetAddress inetAddress = fTPDataSocket2.getLocalAddress();
                        this.sendPORTCommand(inetAddress, n4);
                        fTPDataSocket = fTPDataSocket2;
                        break block6;
                    }
                    catch (SocketException socketException) {
                        if (n2 >= n3) continue;
                        log.warn("Detected socket in use - retrying and selecting new port");
                        this.setNextAvailablePortFromRange();
                    }
                }
                throw new FTPException("Exhausted active port retry count - giving up");
            }
            Object var8_9 = null;
            this.setNextAvailablePortFromRange();
            return fTPDataSocket;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.setNextAvailablePortFromRange();
            throw throwable;
        }
    }

    private void setNextAvailablePortFromRange() {
        if (this.lowPort < 0 && this.highPort < 0) {
            return;
        }
        this.nextPort = this.nextPort == 0 ? this.lowPort + new Random().nextInt(this.highPort - this.lowPort) : ++this.nextPort;
        if (this.nextPort > this.highPort) {
            this.nextPort = this.lowPort;
        }
        log.debug("Next active port will be: " + this.nextPort);
    }

    private final void sendPORTCommand(InetAddress inetAddress, int n) {
        this.setDataPort(inetAddress, n);
    }

    private short toUnsignedShort(byte by) {
        return by < 0 ? (short)(by + 256) : (short)by;
    }

    protected final byte[] toByteArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    final void setDataChannelCallback(DataChannelCallback dataChannelCallback) {
        this.dataChannelCallback = dataChannelCallback;
    }

    final void setActivePortIPAddress(String string) {
        this.forcedActiveIP = string;
    }

    public final void setActivePortRange(int n, int n2) {
        this.lowPort = n;
        this.highPort = n2;
        this.nextPort = this.lowPort;
    }

    private byte[] getIPAddressBytes(String string) {
        byte[] byArray = new byte[4];
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n && n2 <= 4; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
            if (c2 != '.' && i2 + 1 != n) continue;
            try {
                byArray[n2++] = (byte)Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Incorrectly formatted IP address: " + string);
            }
        }
        return byArray;
    }

    protected final void setDataPort(InetAddress inetAddress, int n) {
        Object object;
        Object object2;
        String string = inetAddress.getHostAddress();
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = this.toByteArray(n);
        if (this.forcedActiveIP != null) {
            log.info("Forcing use of fixed IP for PORT command");
            byArray = this.getIPAddressBytes(this.forcedActiveIP);
            string = this.forcedActiveIP;
        }
        if (this.dataChannelCallback != null) {
            object2 = new IPEndpoint(string, n);
            object = this.dataChannelCallback.onPORTCommand((IPEndpoint)object2);
            byArray = this.getIPAddressBytes(((IPEndpoint)object).getIPAddress());
            byArray2 = this.toByteArray(((IPEndpoint)object).getPort());
            log.info("Changed PORT endpoint from " + ((IPEndpoint)object2).toString() + " => " + ((IPEndpoint)object).toString());
        }
        object2 = "PORT " + this.toUnsignedShort(byArray[0]) + "," + this.toUnsignedShort(byArray[1]) + "," + this.toUnsignedShort(byArray[2]) + "," + this.toUnsignedShort(byArray[3]) + "," + this.toUnsignedShort(byArray2[0]) + "," + this.toUnsignedShort(byArray2[1]);
        object = this.sendCommand((String)object2);
        String[] stringArray = new String[]{"200", "250"};
        this.validateReply((FTPReply)object, stringArray);
    }

    protected final FTPDataSocket createDataSocketPASV() {
        Object object;
        FTPReply fTPReply = this.sendCommand("PASV");
        this.validateReply(fTPReply, "227");
        String string = fTPReply.getReplyText();
        int[] nArray = this.getPASVParts(string);
        String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        int n = (nArray[4] << 8) + nArray[5];
        String string3 = string2;
        if (this.autoPassiveIPSubstitution) {
            if (this.usingProxy()) {
                string3 = this.controlSock.getRemoteHost();
                log.debug("Using proxy");
            } else {
                string3 = this.remoteAddr.getHostAddress();
            }
            object = new StringBuffer("Substituting server supplied IP (");
            ((StringBuffer)object).append(string2).append(") with remote host IP (").append(string3).append(")");
            log.info(((StringBuffer)object).toString());
        }
        if (this.dataChannelCallback != null) {
            object = new IPEndpoint(string3, n);
            IPEndpoint iPEndpoint = this.dataChannelCallback.onPASVResponse((IPEndpoint)object);
            string3 = iPEndpoint.getIPAddress();
            n = iPEndpoint.getPort();
            log.info("Changed PASV endpoint from " + ((IPEndpoint)object).toString() + " => " + iPEndpoint.toString());
        }
        return this.newPassiveDataSocket(string3, n);
    }

    protected final boolean usingProxy() {
        return false;
    }

    private final int[] getPASVParts(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0) {
            for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
            }
            --n;
        }
        if (n2 < 0) {
            for (n2 = string.length() - 1; n2 > 0 && !Character.isDigit(string.charAt(n2)); --n2) {
            }
            if (++n2 >= string.length()) {
                string = string + ")";
            }
        }
        String string2 = string.substring(n + 1, n2).trim();
        int[] nArray = new int[6];
        int n3 = string2.length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n3 && n4 <= 6; ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 != ',' && c2 != ' ') {
                throw new FTPException("Malformed PASV reply: " + string);
            }
            if (c2 != ',' && i2 + 1 != n3) continue;
            try {
                nArray[n4++] = Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FTPException("Malformed PASV reply: " + string);
            }
        }
        return nArray;
    }

    protected final FTPDataSocket newPassiveDataSocket(String string, int n) {
        PlainSocket plainSocket = PlainSocket.createPlainSocket(string, n, this.controlSock.getSoTimeout());
        return new FTPPassiveDataSocket(plainSocket);
    }

    protected final FTPDataSocket newActiveDataSocket(int n) {
        ServerSocket serverSocket = this.listenOnAllInterfaces ? new ServerSocket(n) : new ServerSocket(n, 0, this.controlSock.getLocalAddress());
        log.debug("ListenOnAllInterfaces=" + this.listenOnAllInterfaces);
        serverSocket.setSoTimeout(this.controlSock.getSoTimeout());
        FTPActiveDataSocket fTPActiveDataSocket = new FTPActiveDataSocket(serverSocket);
        fTPActiveDataSocket.setLocalAddress(this.controlSock.getLocalAddress());
        return fTPActiveDataSocket;
    }

    public final FTPReply sendCommand(String string) {
        this.writeCommand(string);
        return this.readReply();
    }

    private final void writeCommand(String string) {
        this.log(DEBUG_ARROW + string, true);
        try {
            this.writer.write(string + EOL);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new ControlChannelIOException(iOException.getMessage());
        }
    }

    private String readLine() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            try {
                n = this.reader.read();
            }
            catch (IOException iOException) {
                log.error("Read failed ('" + stringBuffer2.toString() + "' read so far)");
                throw new ControlChannelIOException(iOException.getMessage());
            }
            if (n < 0) {
                String string = "Control channel unexpectedly closed ('" + stringBuffer2.toString() + "' read so far)";
                log.error(string);
                throw new ControlChannelIOException(string);
            }
            if (n == 10) break;
            if (n != 13) {
                stringBuffer.append((char)n);
                stringBuffer2.append((char)n);
                continue;
            }
            stringBuffer2.append("<cr>");
        }
        return stringBuffer.toString();
    }

    final FTPReply readReply() {
        String string = this.readLine();
        while (string != null && string.trim().length() == 0) {
            string = this.readLine();
        }
        string = string.trim();
        this.log(string, false);
        if (string.length() < 3) {
            String string2 = "Short reply received (" + string + ")";
            log.error(string2);
            throw new MalformedReplyException(string2);
        }
        String string3 = string.substring(0, 3);
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() > 3) {
            stringBuffer.append(string.substring(4));
        }
        Vector<String> vector = null;
        if (string.length() > 3 && string.charAt(3) == '-') {
            vector = new Vector<String>();
            if (string.length() > 4 && (string = string.substring(4).trim()).length() > 0) {
                vector.addElement(string);
            }
            boolean bl = false;
            while (!bl) {
                string = this.readLine();
                if (string == null) {
                    String string4 = "Control channel unexpectedly closed";
                    log.error(string4);
                    throw new ControlChannelIOException(string4);
                }
                if (string.length() == 0) continue;
                this.log(string, false);
                if (string.length() > 3 && string.substring(0, 3).equals(string3) && string.charAt(3) == ' ') {
                    if ((string = string.substring(3).trim()).length() > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(string);
                        vector.addElement(string);
                    }
                    bl = true;
                    continue;
                }
                stringBuffer.append(" ").append(string);
                vector.addElement(string);
            }
        }
        if (vector != null) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return new FTPReply(string3, stringBuffer.toString(), (String[])objectArray);
        }
        return new FTPReply(string3, stringBuffer.toString());
    }

    private final FTPReply validateReply(String string, String string2) {
        FTPReply fTPReply = new FTPReply(string);
        if (this.validateReplyCode(fTPReply, string2)) {
            return fTPReply;
        }
        throw new FTPException(fTPReply);
    }

    public final FTPReply validateReply(String string, String[] stringArray) {
        FTPReply fTPReply = new FTPReply(string);
        return this.validateReply(fTPReply, stringArray);
    }

    public final FTPReply validateReply(FTPReply fTPReply, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.validateReplyCode(fTPReply, stringArray[i2])) continue;
            return fTPReply;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            stringBuffer.append(stringArray[i3]);
            if (i3 + 1 >= stringArray.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        log.info("Expected reply codes = " + stringBuffer.toString());
        throw new FTPException(fTPReply);
    }

    public final FTPReply validateReply(FTPReply fTPReply, String string) {
        if (this.validateReplyCode(fTPReply, string)) {
            return fTPReply;
        }
        log.info("Expected reply code = [" + string + "]");
        throw new FTPException(fTPReply);
    }

    private boolean validateReplyCode(FTPReply fTPReply, String string) {
        String string2 = fTPReply.getReplyCode();
        if ("421".equals(string2)) {
            throw new FTPConnectionClosedException(fTPReply.getReplyText());
        }
        if (this.strictReturnCodes) {
            return string2.equals(string);
        }
        return string2.charAt(0) == string.charAt(0);
    }

    private final void log(String string, boolean bl) {
        if (string.startsWith(PASSWORD_MESSAGE)) {
            string = "---> PASS ********";
        } else if (string.startsWith(ACCT_MESSAGE)) {
            string = "---> ACCT ********";
        }
        log.debug(string);
        if (this.messageListener != null) {
            if (bl) {
                this.messageListener.logCommand(string);
            } else {
                this.messageListener.logReply(string);
            }
        }
    }
}

