/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.MVSFileParser;
import com.enterprisedt.net.ftp.NetwareFileParser;
import com.enterprisedt.net.ftp.OS400FileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FTPFileFactory {
    public static final String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.27 2012/08/17 04:15:28 bruceb Exp $";
    private static Logger log = Logger.getLogger("FTPFileFactory");
    static final String WINDOWS_STR = "WINDOWS";
    static final String NETWARE_STR = "NETWARE";
    static final String UNIX_STR = "UNIX";
    static final String VMS_STR = "VMS";
    static final String AIX_STR = "AIX";
    static final String MVS_STR = "MVS";
    static final String OS400_STR = "OS/400";
    private String system;
    private WindowsFileParser windows = new WindowsFileParser();
    private FTPFileParser unix = new UnixFileParser();
    private VMSFileParser vms = new VMSFileParser();
    private NetwareFileParser netware = new NetwareFileParser();
    private MVSFileParser mvs = new MVSFileParser();
    private OS400FileParser os400 = new OS400FileParser();
    private FTPFileParser parser = null;
    private boolean userSetParser = false;
    private boolean parserDetected = false;
    private Locale[] localesToTry;
    private int localeIndex = 0;
    private List parsers = new ArrayList();

    public FTPFileFactory(String string) {
        this.parsers.add(this.unix);
        this.parsers.add(this.windows);
        this.parsers.add(this.vms);
        this.parsers.add(this.netware);
        this.parsers.add(this.mvs);
        this.parsers.add(this.os400);
        this.setParser(string);
    }

    public FTPFileFactory(FTPFileParser fTPFileParser) {
        this.parsers.add(this.unix);
        this.parsers.add(this.windows);
        this.parsers.add(this.vms);
        this.parsers.add(this.netware);
        this.parsers.add(this.mvs);
        this.parsers.add(this.os400);
        this.parser = fTPFileParser;
        this.userSetParser = true;
    }

    public final String toString() {
        return this.parser.getClass().getName();
    }

    public final VMSFileParser getVMSParser() {
        return this.vms;
    }

    public final void addParser(FTPFileParser fTPFileParser) {
        this.parsers.add(fTPFileParser);
    }

    public final void setLocale(Locale locale) {
        this.parser.setLocale(locale);
        Iterator iterator = this.parsers.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            fTPFileParser.setLocale(locale);
        }
    }

    public final void setLocales(Locale[] localeArray) {
        this.localesToTry = localeArray;
        this.setLocale(localeArray[0]);
        this.localeIndex = 1;
    }

    private void setParser(String string) {
        this.parserDetected = false;
        String string2 = this.system = string != null ? string.trim() : null;
        if (string.toUpperCase().startsWith(WINDOWS_STR)) {
            log.debug("Selected Windows parser");
            this.parser = this.windows;
        } else if (string.toUpperCase().indexOf(UNIX_STR) >= 0 || string.toUpperCase().indexOf(AIX_STR) >= 0) {
            log.debug("Selected Unix parser");
            this.parser = this.unix;
        } else if (string.toUpperCase().indexOf(VMS_STR) >= 0) {
            log.debug("Selected VMS parser");
            this.parser = this.vms;
        } else if (string.toUpperCase().indexOf(NETWARE_STR) >= 0) {
            log.debug("Selected Netware parser");
            this.parser = this.netware;
        } else if (string.toUpperCase().indexOf(MVS_STR) >= 0) {
            log.debug("Selected MVS parser");
            this.parser = this.mvs;
        } else if (string.toUpperCase().indexOf(OS400_STR) >= 0) {
            log.debug("Selected OS/400 parser");
            this.parser = this.os400;
        } else {
            this.parser = this.unix;
            log.warn("Unknown SYST '" + string + "' - defaulting to Unix parsing");
        }
    }

    private void reinitializeParsers() {
        this.parser.setIgnoreDateParseErrors(false);
        Iterator iterator = this.parsers.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            fTPFileParser.setIgnoreDateParseErrors(false);
        }
    }

    private void detectParser(String[] stringArray) {
        if (this.parser.isValidFormat(stringArray)) {
            log.debug("Confirmed format " + this.parser.toString());
            this.parserDetected = true;
            return;
        }
        Iterator iterator = this.parsers.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            if (!fTPFileParser.isValidFormat(stringArray)) continue;
            this.parser = fTPFileParser;
            log.debug("Detected format " + this.parser.toString());
            this.parserDetected = true;
            return;
        }
        this.parser = this.unix;
        log.warn("Could not detect format. Using default " + this.parser.toString());
    }

    public final FTPFile parse(String string) {
        if (this.parser.isMultiLine()) {
            throw new ParseException("Cannot use this method with multi-line parsers", 0);
        }
        FTPFile fTPFile = null;
        try {
            fTPFile = this.parser.parse(string);
        }
        catch (DateParseException dateParseException) {
            this.parser.setIgnoreDateParseErrors(true);
            fTPFile = this.parser.parse(string);
        }
        return fTPFile;
    }

    public final FTPFile[] parse(String[] stringArray) {
        this.reinitializeParsers();
        FTPFile[] fTPFileArray = new FTPFile[stringArray.length];
        if (stringArray.length == 0) {
            return fTPFileArray;
        }
        if (!this.userSetParser && !this.parserDetected) {
            this.detectParser(stringArray);
        }
        int n = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].trim().length() == 0) continue;
            try {
                FTPFile fTPFile = null;
                if (this.parser.isMultiLine()) {
                    StringBuffer stringBuffer = new StringBuffer(stringArray[i2]);
                    while (i2 + 1 < stringArray.length && stringArray[i2 + 1].indexOf(59) < 0) {
                        stringBuffer.append(" ").append(stringArray[i2 + 1]);
                        ++i2;
                    }
                    fTPFile = this.parser.parse(stringBuffer.toString());
                } else {
                    fTPFile = this.parser.parse(stringArray[i2]);
                }
                if (fTPFile == null) continue;
                fTPFileArray[n++] = fTPFile;
                continue;
            }
            catch (DateParseException dateParseException) {
                if (this.localesToTry != null && this.localesToTry.length > this.localeIndex) {
                    log.info("Trying " + this.localesToTry[this.localeIndex].toString() + " locale");
                    this.setLocale(this.localesToTry[this.localeIndex]);
                    ++this.localeIndex;
                    n = 0;
                    i2 = -1;
                    continue;
                }
                n = 0;
                i2 = -1;
                this.parser.setIgnoreDateParseErrors(true);
                log.debug("Ignoring date parsing errors");
            }
        }
        FTPFile[] fTPFileArray2 = new FTPFile[n];
        System.arraycopy(fTPFileArray, 0, fTPFileArray2, 0, n);
        return fTPFileArray2;
    }

    public final String getSystem() {
        return this.system;
    }
}

