/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VMSFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: VMSFileParser.java,v 1.9 2011-05-03 01:49:00 bruceb Exp $";
    private static Logger log = Logger.getLogger("VMSFileParser");
    private static final String DIR = ".DIR";
    private static final String HDR = "Directory";
    private static final String TOTAL = "Total";
    private static final int DEFAULT_BLOCKSIZE = 524288;
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;
    private SimpleDateFormat formatter1;
    private SimpleDateFormat formatter2;
    private boolean versionInName = false;
    private int blocksize = 524288;

    public VMSFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public final boolean isMultiLine() {
        return true;
    }

    public final int getBlocksize() {
        return this.blocksize;
    }

    public final void setBlocksize(int n) {
        this.blocksize = n;
    }

    public final boolean isVersionInName() {
        return this.versionInName;
    }

    public final void setVersionInName(boolean bl) {
        this.versionInName = bl;
    }

    public final String toString() {
        return "VMS";
    }

    public final boolean isValidFormat(String[] stringArray) {
        int n = Math.min(stringArray.length, 10);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < n; ++i2) {
            if (stringArray[i2].trim().length() == 0) continue;
            int n2 = 0;
            n2 = stringArray[i2].indexOf(59);
            if (n2 > 0 && ++n2 < stringArray[i2].length() && Character.isDigit(stringArray[i2].charAt(n2))) {
                bl = true;
            }
            if (stringArray[i2].indexOf(91) > 0) {
                bl2 = true;
            }
            if (stringArray[i2].indexOf(93) <= 0) continue;
            bl3 = true;
        }
        if (bl && bl2 && bl3) {
            return true;
        }
        log.debug("Not in VMS format");
        return false;
    }

    public final FTPFile parse(String string) {
        Date date;
        long l2;
        boolean bl;
        String string2;
        String[] stringArray;
        block18: {
            stringArray = this.split(string);
            if (stringArray.length <= 0) {
                return null;
            }
            if (stringArray.length >= 2 && stringArray[0].compareTo(HDR) == 0) {
                return null;
            }
            if (stringArray.length > 0 && stringArray[0].compareTo(TOTAL) == 0) {
                return null;
            }
            if (stringArray.length < 4) {
                return null;
            }
            string2 = stringArray[0];
            int n = string2.lastIndexOf(59);
            if (n <= 0) {
                log.warn("File version number not found in name '" + string2 + "'");
                return null;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            bl = false;
            if (string3.endsWith(DIR)) {
                bl = true;
                string2 = string3.substring(0, string3.length() - DIR.length());
            }
            if (!this.versionInName && !bl) {
                string2 = string3;
            }
            int n2 = stringArray[1].indexOf(47);
            String string5 = stringArray[1];
            if (n2 > 0) {
                string5 = stringArray[1].substring(0, n2);
            }
            l2 = Long.parseLong(string5) * (long)this.blocksize;
            date = null;
            try {
                date = this.formatter1.parse(stringArray[2] + " " + stringArray[3]);
            }
            catch (ParseException parseException) {
                try {
                    date = this.formatter2.parse(stringArray[2] + " " + stringArray[3]);
                }
                catch (ParseException parseException2) {
                    if (this.ignoreDateParseErrors) break block18;
                    throw new DateParseException(parseException.getMessage());
                }
            }
        }
        String string6 = null;
        String string7 = null;
        if (stringArray.length >= 5 && stringArray[4].charAt(0) == '[' && stringArray[4].charAt(stringArray[4].length() - 1) == ']') {
            int n = stringArray[4].indexOf(44);
            if (n < 0) {
                string6 = string7 = stringArray[4];
            } else {
                string6 = stringArray[4].substring(1, n);
                string7 = stringArray[4].substring(n + 1, stringArray[4].length() - 1);
            }
        }
        String string8 = null;
        if (stringArray.length >= 6 && stringArray[5].charAt(0) == '(' && stringArray[5].charAt(stringArray[5].length() - 1) == ')') {
            string8 = stringArray[5].substring(1, stringArray[5].length() - 2);
        }
        FTPFile fTPFile = new FTPFile(string, string2, l2, bl, date);
        fTPFile.setGroup(string6);
        fTPFile.setOwner(string7);
        fTPFile.setPermissions(string8);
        return fTPFile;
    }

    public final void setLocale(Locale locale) {
        this.formatter1 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", locale);
        this.formatter2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm", locale);
    }
}

