/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.CellConstraints$Alignment;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class CellConstraints
implements Cloneable,
Serializable {
    public static final CellConstraints$Alignment DEFAULT = new CellConstraints$Alignment("default", 2, null);
    public static final CellConstraints$Alignment FILL = new CellConstraints$Alignment("fill", 2, null);
    public static final CellConstraints$Alignment LEFT = new CellConstraints$Alignment("left", 0, null);
    public static final CellConstraints$Alignment RIGHT = new CellConstraints$Alignment("right", 0, null);
    public static final CellConstraints$Alignment CENTER = new CellConstraints$Alignment("center", 2, null);
    public static final CellConstraints$Alignment TOP = new CellConstraints$Alignment("top", 1, null);
    public static final CellConstraints$Alignment BOTTOM = new CellConstraints$Alignment("bottom", 1, null);
    private static final CellConstraints$Alignment[] VALUES = new CellConstraints$Alignment[]{DEFAULT, FILL, LEFT, RIGHT, CENTER, TOP, BOTTOM};
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public int gridX;
    public int gridY;
    public int gridWidth;
    public int gridHeight;
    public CellConstraints$Alignment hAlign;
    public CellConstraints$Alignment vAlign;
    public Insets insets;

    public CellConstraints() {
        this(1, 1);
    }

    public CellConstraints(int n, int n2) {
        this(n, n2, 1, 1);
    }

    public CellConstraints(int n, int n2, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        this(n, n2, 1, 1, cellConstraints$Alignment, cellConstraints$Alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints(int n, int n2, int n3, int n4, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        this(n, n2, n3, n4, cellConstraints$Alignment, cellConstraints$Alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2, Insets insets) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = cellConstraints$Alignment;
        this.vAlign = cellConstraints$Alignment2;
        this.insets = insets;
        if (n <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        if (n2 <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (n3 <= 0) {
            throw new IndexOutOfBoundsException("The grid width must be a positive number.");
        }
        if (n4 <= 0) {
            throw new IndexOutOfBoundsException("The grid height must be a positive number.");
        }
        if (cellConstraints$Alignment == null) {
            throw new NullPointerException("The horizontal alignment must not be null.");
        }
        if (cellConstraints$Alignment2 == null) {
            throw new NullPointerException("The vertical alignment must not be null.");
        }
        this.ensureValidOrientations(cellConstraints$Alignment, cellConstraints$Alignment2);
    }

    public CellConstraints(String string) {
        this();
        this.initFromConstraints(string);
    }

    public CellConstraints xy(int n, int n2) {
        return this.xywh(n, n2, 1, 1);
    }

    public CellConstraints xy(int n, int n2, String string) {
        return this.xywh(n, n2, 1, 1, string);
    }

    public CellConstraints xy(int n, int n2, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        return this.xywh(n, n2, 1, 1, cellConstraints$Alignment, cellConstraints$Alignment2);
    }

    public CellConstraints xyw(int n, int n2, int n3) {
        return this.xywh(n, n2, n3, 1, DEFAULT, DEFAULT);
    }

    public CellConstraints xyw(int n, int n2, int n3, String string) {
        return this.xywh(n, n2, n3, 1, string);
    }

    public CellConstraints xyw(int n, int n2, int n3, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        return this.xywh(n, n2, n3, 1, cellConstraints$Alignment, cellConstraints$Alignment2);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4) {
        return this.xywh(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, String string) {
        CellConstraints cellConstraints = this.xywh(n, n2, n3, n4);
        cellConstraints.setAlignments(string);
        return cellConstraints;
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = cellConstraints$Alignment;
        this.vAlign = cellConstraints$Alignment2;
        this.ensureValidOrientations(this.hAlign, this.vAlign);
        return this;
    }

    private void initFromConstraints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n = stringTokenizer.countTokens();
        if (n != 2 && n != 4 && n != 6) {
            throw new IllegalArgumentException("You must provide 2, 4 or 6 arguments.");
        }
        Integer n2 = this.decodeInt(stringTokenizer.nextToken());
        if (n2 == null) {
            throw new IllegalArgumentException("First cell constraint element must be a number.");
        }
        this.gridX = n2;
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        n2 = this.decodeInt(stringTokenizer.nextToken());
        if (n2 == null) {
            throw new IllegalArgumentException("Second cell constraint element must be a number.");
        }
        this.gridY = n2;
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        n2 = this.decodeInt(string2);
        if (n2 != null) {
            this.gridWidth = n2;
            if (this.gridWidth <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            n2 = this.decodeInt(stringTokenizer.nextToken());
            if (n2 == null) {
                throw new IllegalArgumentException("Fourth cell constraint element must be like third.");
            }
            this.gridHeight = n2;
            if (this.gridHeight <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string2 = stringTokenizer.nextToken();
        }
        this.hAlign = this.decodeAlignment(string2);
        this.vAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private void setAlignments(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        this.hAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.vAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private Integer decodeInt(String string) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private CellConstraints$Alignment decodeAlignment(String string) {
        return CellConstraints$Alignment.valueOf(string);
    }

    void ensureValidGridBounds(int n, int n2) {
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be positive.");
        }
        if (this.gridX > n) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be less than or equal to " + n + ".");
        }
        if (this.gridX + this.gridWidth - 1 > n) {
            throw new IndexOutOfBoundsException("The grid width " + this.gridWidth + " must be less than or equal to " + (n - this.gridX + 1) + ".");
        }
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be positive.");
        }
        if (this.gridY > n2) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be less than or equal to " + n2 + ".");
        }
        if (this.gridY + this.gridHeight - 1 > n2) {
            throw new IndexOutOfBoundsException("The grid height " + this.gridHeight + " must be less than or equal to " + (n2 - this.gridY + 1) + ".");
        }
    }

    private void ensureValidOrientations(CellConstraints$Alignment cellConstraints$Alignment, CellConstraints$Alignment cellConstraints$Alignment2) {
        if (!CellConstraints$Alignment.access$100(cellConstraints$Alignment)) {
            throw new IllegalArgumentException("The horizontal alignment must be one of: left, center, right, fill, default.");
        }
        if (!CellConstraints$Alignment.access$200(cellConstraints$Alignment2)) {
            throw new IllegalArgumentException("The vertical alignment must be one of: top, center, botto, fill, default.");
        }
    }

    void setBounds(Component component, FormLayout formLayout, Rectangle rectangle, FormLayout$Measure measure, FormLayout$Measure measure2, FormLayout$Measure measure3, FormLayout$Measure measure4) {
        ColumnSpec columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
        RowSpec rowSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
        CellConstraints$Alignment cellConstraints$Alignment = this.concreteAlignment(this.hAlign, columnSpec);
        CellConstraints$Alignment cellConstraints$Alignment2 = this.concreteAlignment(this.vAlign, rowSpec);
        Insets insets = this.insets != null ? this.insets : EMPTY_INSETS;
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.width - insets.left - insets.right;
        int n4 = rectangle.height - insets.top - insets.bottom;
        int n5 = this.componentSize(component, columnSpec, n3, measure, measure3);
        int n6 = this.componentSize(component, rowSpec, n4, measure2, measure4);
        int n7 = this.origin(cellConstraints$Alignment, n, n3, n5);
        int n8 = this.origin(cellConstraints$Alignment2, n2, n4, n6);
        int n9 = this.extent(cellConstraints$Alignment, n3, n5);
        int n10 = this.extent(cellConstraints$Alignment2, n4, n6);
        component.setBounds(n7, n8, n9, n10);
    }

    private CellConstraints$Alignment concreteAlignment(CellConstraints$Alignment cellConstraints$Alignment, FormSpec formSpec) {
        return formSpec == null ? (cellConstraints$Alignment == DEFAULT ? FILL : cellConstraints$Alignment) : this.usedAlignment(cellConstraints$Alignment, formSpec);
    }

    private CellConstraints$Alignment usedAlignment(CellConstraints$Alignment cellConstraints$Alignment, FormSpec formSpec) {
        if (cellConstraints$Alignment != DEFAULT) {
            return cellConstraints$Alignment;
        }
        FormSpec.DefaultAlignment defaultAlignment = formSpec.getDefaultAlignment();
        if (defaultAlignment == FormSpec.FILL_ALIGN) {
            return FILL;
        }
        if (defaultAlignment == ColumnSpec.LEFT) {
            return LEFT;
        }
        if (defaultAlignment == FormSpec.CENTER_ALIGN) {
            return CENTER;
        }
        if (defaultAlignment == ColumnSpec.RIGHT) {
            return RIGHT;
        }
        if (defaultAlignment == RowSpec.TOP) {
            return TOP;
        }
        return BOTTOM;
    }

    private int componentSize(Component component, FormSpec formSpec, int n, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2) {
        if (formSpec == null) {
            return formLayout$Measure2.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.MINIMUM) {
            return formLayout$Measure.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.PREFERRED) {
            return formLayout$Measure2.sizeOf(component);
        }
        return Math.min(n, formLayout$Measure2.sizeOf(component));
    }

    private int origin(CellConstraints$Alignment cellConstraints$Alignment, int n, int n2, int n3) {
        if (cellConstraints$Alignment == RIGHT || cellConstraints$Alignment == BOTTOM) {
            return n + n2 - n3;
        }
        if (cellConstraints$Alignment == CENTER) {
            return n + (n2 - n3) / 2;
        }
        return n;
    }

    private int extent(CellConstraints$Alignment cellConstraints$Alignment, int n, int n2) {
        return cellConstraints$Alignment == FILL ? n : n2;
    }

    public Object clone() {
        try {
            CellConstraints cellConstraints = (CellConstraints)super.clone();
            cellConstraints.insets = (Insets)this.insets.clone();
            return cellConstraints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CellConstraints");
        stringBuffer.append("[x=");
        stringBuffer.append(this.gridX);
        stringBuffer.append("; y=");
        stringBuffer.append(this.gridY);
        stringBuffer.append("; w=");
        stringBuffer.append(this.gridWidth);
        stringBuffer.append("; h=");
        stringBuffer.append(this.gridHeight);
        stringBuffer.append("; hAlign=");
        stringBuffer.append(this.hAlign);
        stringBuffer.append("; vAlign=");
        stringBuffer.append(this.vAlign);
        if (!EMPTY_INSETS.equals(this.insets)) {
            stringBuffer.append("; insets=");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toShortString() {
        return this.toShortString(null);
    }

    public String toShortString(FormLayout formLayout) {
        ColumnSpec columnSpec;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.formatInt(this.gridX));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridY));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridWidth));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridHeight));
        stringBuffer.append(", \"");
        stringBuffer.append(this.hAlign.abbreviation());
        if (this.hAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
            stringBuffer.append(this.concreteAlignment(this.hAlign, columnSpec).abbreviation());
        }
        stringBuffer.append(", ");
        stringBuffer.append(this.vAlign.abbreviation());
        if (this.vAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            columnSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
            stringBuffer.append(this.concreteAlignment(this.vAlign, columnSpec).abbreviation());
        }
        stringBuffer.append("\"");
        if (!EMPTY_INSETS.equals(this.insets)) {
            stringBuffer.append(", ");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        String string = Integer.toString(n);
        return n < 10 ? " " + string : string;
    }

    static CellConstraints$Alignment[] access$300() {
        return VALUES;
    }
}

