/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout$ComponentSizeCache;
import com.jgoodies.forms.layout.FormLayout$LayoutInfo;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.FormLayout$MinimumHeightMeasure;
import com.jgoodies.forms.layout.FormLayout$MinimumWidthMeasure;
import com.jgoodies.forms.layout.FormLayout$PreferredHeightMeasure;
import com.jgoodies.forms.layout.FormLayout$PreferredWidthMeasure;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class FormLayout
implements LayoutManager2,
Serializable {
    private final List colSpecs;
    private final List rowSpecs;
    private int[][] colGroupIndices;
    private int[][] rowGroupIndices;
    private final Map constraintMap;
    private transient List[] colComponents;
    private transient List[] rowComponents;
    private final FormLayout$ComponentSizeCache componentSizeCache;
    private final FormLayout$Measure minimumWidthMeasure;
    private final FormLayout$Measure minimumHeightMeasure;
    private final FormLayout$Measure preferredWidthMeasure;
    private final FormLayout$Measure preferredHeightMeasure;

    public FormLayout() {
        this(new ColumnSpec[0], new RowSpec[0]);
    }

    public FormLayout(String string) {
        this(ColumnSpec.decodeSpecs(string), new RowSpec[0]);
    }

    public FormLayout(String string, String string2) {
        this(ColumnSpec.decodeSpecs(string), RowSpec.decodeSpecs(string2));
    }

    public FormLayout(ColumnSpec[] columnSpecArray, RowSpec[] rowSpecArray) {
        if (columnSpecArray == null) {
            throw new NullPointerException("The column specifications must not be null.");
        }
        if (rowSpecArray == null) {
            throw new NullPointerException("The row specifications must not be null.");
        }
        this.colSpecs = new ArrayList<ColumnSpec>(Arrays.asList(columnSpecArray));
        this.rowSpecs = new ArrayList<RowSpec>(Arrays.asList(rowSpecArray));
        this.colGroupIndices = new int[0][];
        this.rowGroupIndices = new int[0][];
        int n = columnSpecArray.length * rowSpecArray.length / 4;
        this.constraintMap = new HashMap(n);
        this.componentSizeCache = new FormLayout$ComponentSizeCache(n, null);
        this.minimumWidthMeasure = new FormLayout$MinimumWidthMeasure(this.componentSizeCache, null);
        this.minimumHeightMeasure = new FormLayout$MinimumHeightMeasure(this.componentSizeCache, null);
        this.preferredWidthMeasure = new FormLayout$PreferredWidthMeasure(this.componentSizeCache, null);
        this.preferredHeightMeasure = new FormLayout$PreferredHeightMeasure(this.componentSizeCache, null);
    }

    public int getColumnCount() {
        return this.colSpecs.size();
    }

    public int getRowCount() {
        return this.rowSpecs.size();
    }

    public ColumnSpec getColumnSpec(int n) {
        return (ColumnSpec)this.colSpecs.get(n - 1);
    }

    public void setColumnSpec(int n, ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.set(n - 1, columnSpec);
    }

    public RowSpec getRowSpec(int n) {
        return (RowSpec)this.rowSpecs.get(n - 1);
    }

    public void setRowSpec(int n, RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.set(n - 1, rowSpec);
    }

    public void appendColumn(ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.add(columnSpec);
    }

    public void insertColumn(int n, ColumnSpec columnSpec) {
        if (n < 1 || n > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + n + "must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.add(n - 1, columnSpec);
        this.shiftComponentsHorizontally(n, false);
        this.adjustGroupIndices(this.colGroupIndices, n, false);
    }

    public void removeColumn(int n) {
        if (n < 1 || n > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + n + " must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.remove(n - 1);
        this.shiftComponentsHorizontally(n, true);
        this.adjustGroupIndices(this.colGroupIndices, n, true);
    }

    public void appendRow(RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.add(rowSpec);
    }

    public void insertRow(int n, RowSpec rowSpec) {
        if (n < 1 || n > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + n + " must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.add(n - 1, rowSpec);
        this.shiftComponentsVertically(n, false);
        this.adjustGroupIndices(this.rowGroupIndices, n, false);
    }

    public void removeRow(int n) {
        if (n < 1 || n > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + n + "must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.remove(n - 1);
        this.shiftComponentsVertically(n, true);
        this.adjustGroupIndices(this.rowGroupIndices, n, true);
    }

    private void shiftComponentsHorizontally(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        Iterator iterator = this.constraintMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n3 = cellConstraints.gridX;
            int n4 = cellConstraints.gridWidth;
            int n5 = n3 + n4 - 1;
            if (n3 == n && bl) {
                throw new IllegalStateException("The removed column " + n + " must not contain component origins.\n" + "Illegal component=" + entry.getKey());
            }
            if (n3 >= n) {
                cellConstraints.gridX += n2;
                continue;
            }
            if (n5 < n) continue;
            cellConstraints.gridWidth += n2;
        }
    }

    private void shiftComponentsVertically(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        Iterator iterator = this.constraintMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n3 = cellConstraints.gridY;
            int n4 = cellConstraints.gridHeight;
            int n5 = n3 + n4 - 1;
            if (n3 == n && bl) {
                throw new IllegalStateException("The removed row " + n + " must not contain component origins.\n" + "Illegal component=" + entry.getKey());
            }
            if (n3 >= n) {
                cellConstraints.gridY += n2;
                continue;
            }
            if (n5 < n) continue;
            cellConstraints.gridHeight += n2;
        }
    }

    private void adjustGroupIndices(int[][] nArray, int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int[] nArray2 = nArray[i2];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                int n3 = nArray2[i3];
                if (n3 == n && bl) {
                    throw new IllegalStateException("The removed index " + n + " must not be grouped.");
                }
                if (n3 < n) continue;
                int n4 = i3;
                nArray2[n4] = nArray2[n4] + n2;
            }
        }
    }

    public CellConstraints getConstraints(Component component) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        CellConstraints cellConstraints = (CellConstraints)this.constraintMap.get(component);
        if (cellConstraints == null) {
            throw new NullPointerException("The component has not been added to the container.");
        }
        return (CellConstraints)cellConstraints.clone();
    }

    public void setConstraints(Component component, CellConstraints cellConstraints) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        if (cellConstraints == null) {
            throw new NullPointerException("The constraints must not be null.");
        }
        cellConstraints.ensureValidGridBounds(this.getColumnCount(), this.getRowCount());
        this.constraintMap.put(component, cellConstraints.clone());
    }

    private void removeConstraints(Component component) {
        this.constraintMap.remove(component);
        this.componentSizeCache.removeEntry(component);
    }

    public int[][] getColumnGroups() {
        return this.deepClone(this.colGroupIndices);
    }

    public void setColumnGroups(int[][] nArray) {
        int n = this.getColumnCount();
        boolean[] blArray = new boolean[n + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                int n2 = nArray[i2][i3];
                if (n2 < 1 || n2 > n) {
                    throw new IndexOutOfBoundsException("Invalid column group index " + n2 + " in group " + (i2 + 1));
                }
                if (blArray[n2]) {
                    throw new IllegalArgumentException("Column index " + n2 + " must not be used in multiple column groups.");
                }
                blArray[n2] = true;
            }
        }
        this.colGroupIndices = this.deepClone(nArray);
    }

    public void addGroupedColumn(int n) {
        Object object = this.getColumnGroups();
        if (((int[][])object).length == 0) {
            object = new int[][]{{n}};
        } else {
            int n2 = ((int[][])object).length - 1;
            int[] nArray = object[n2];
            int n3 = nArray.length;
            int[] nArray2 = new int[n3 + 1];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray2[n3] = n;
            object[n2] = nArray2;
        }
        this.setColumnGroups((int[][])object);
    }

    public int[][] getRowGroups() {
        return this.deepClone(this.rowGroupIndices);
    }

    public void setRowGroups(int[][] nArray) {
        int n = this.getRowCount();
        boolean[] blArray = new boolean[n + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                int n2 = nArray[i2][i3];
                if (n2 < 1 || n2 > n) {
                    throw new IndexOutOfBoundsException("Invalid row group index " + n2 + " in group " + (i2 + 1));
                }
                if (blArray[n2]) {
                    throw new IllegalArgumentException("Row index " + n2 + " must not be used in multiple row groups.");
                }
                blArray[n2] = true;
            }
        }
        this.rowGroupIndices = this.deepClone(nArray);
    }

    public void addGroupedRow(int n) {
        Object object = this.getRowGroups();
        if (((int[][])object).length == 0) {
            object = new int[][]{{n}};
        } else {
            int n2 = ((int[][])object).length - 1;
            int[] nArray = object[n2];
            int n3 = nArray.length;
            int[] nArray2 = new int[n3 + 1];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray2[n3] = n;
            object[n2] = nArray2;
        }
        this.setRowGroups((int[][])object);
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("Use #addLayoutComponent(Component, Object) instead.");
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.setConstraints(component, new CellConstraints((String)object));
        } else if (object instanceof CellConstraints) {
            this.setConstraints(component, (CellConstraints)object);
        } else {
            if (object == null) {
                throw new NullPointerException("The constraints must not be null.");
            }
            throw new IllegalArgumentException("Illegal constraint type " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.minimumWidthMeasure, this.minimumHeightMeasure);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.preferredWidthMeasure, this.preferredHeightMeasure);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.invalidateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            int[] nArray = this.computeGridOrigins(container, n, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
            int[] nArray2 = this.computeGridOrigins(container, n2, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
            this.layoutComponents(nArray, nArray2);
        }
    }

    private void initializeColAndRowComponentLists() {
        int n;
        this.colComponents = new LinkedList[this.getColumnCount()];
        for (n = 0; n < this.getColumnCount(); ++n) {
            this.colComponents[n] = new LinkedList();
        }
        this.rowComponents = new LinkedList[this.getRowCount()];
        for (n = 0; n < this.getRowCount(); ++n) {
            this.rowComponents[n] = new LinkedList();
        }
        Iterator iterator = this.constraintMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Component component = (Component)entry.getKey();
            if (!component.isVisible()) continue;
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            if (cellConstraints.gridWidth == 1) {
                this.colComponents[cellConstraints.gridX - 1].add(component);
            }
            if (cellConstraints.gridHeight != 1) continue;
            this.rowComponents[cellConstraints.gridY - 1].add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeLayoutSize(Container container, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            int[] nArray = this.maximumSizes(container, this.colSpecs, this.colComponents, this.minimumWidthMeasure, this.preferredWidthMeasure, formLayout$Measure);
            int[] nArray2 = this.maximumSizes(container, this.rowSpecs, this.rowComponents, this.minimumHeightMeasure, this.preferredHeightMeasure, formLayout$Measure2);
            int[] nArray3 = this.groupedSizes(this.colGroupIndices, nArray);
            int[] nArray4 = this.groupedSizes(this.rowGroupIndices, nArray2);
            int[] nArray5 = this.computeOrigins(nArray3, 0);
            int[] nArray6 = this.computeOrigins(nArray4, 0);
            int n = this.sum(nArray3);
            int n2 = this.sum(nArray4);
            int n3 = n;
            int n4 = n2;
            int[] nArray7 = this.computeMaximumFixedSpanTable(this.colSpecs);
            int[] nArray8 = this.computeMaximumFixedSpanTable(this.rowSpecs);
            Object object2 = this.constraintMap.entrySet().iterator();
            while (object2.hasNext()) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                Map.Entry entry = object2.next();
                Component component = (Component)entry.getKey();
                if (!component.isVisible()) continue;
                CellConstraints cellConstraints = (CellConstraints)entry.getValue();
                if (cellConstraints.gridWidth > 1 && cellConstraints.gridWidth > nArray7[cellConstraints.gridX - 1] && (n10 = (n9 = nArray5[n8 = cellConstraints.gridX - 1]) + (n7 = formLayout$Measure.sizeOf(component)) + (n6 = n - nArray5[n5 = n8 + cellConstraints.gridWidth])) > n3) {
                    n3 = n10;
                }
                if (cellConstraints.gridHeight <= 1 || cellConstraints.gridHeight <= nArray8[cellConstraints.gridY - 1] || (n10 = (n9 = nArray6[n8 = cellConstraints.gridY - 1]) + (n7 = formLayout$Measure2.sizeOf(component)) + (n6 = n2 - nArray6[n5 = n8 + cellConstraints.gridHeight])) <= n4) continue;
                n4 = n10;
            }
            object2 = container.getInsets();
            int n11 = n3 + ((Insets)object2).left + ((Insets)object2).right;
            int n12 = n4 + ((Insets)object2).top + ((Insets)object2).bottom;
            return new Dimension(n11, n12);
        }
    }

    private int[] computeGridOrigins(Container container, int n, int n2, List list, List[] listArray, int[][] nArray, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2) {
        int[] nArray2 = this.maximumSizes(container, list, listArray, formLayout$Measure, formLayout$Measure2, formLayout$Measure);
        int[] nArray3 = this.maximumSizes(container, list, listArray, formLayout$Measure, formLayout$Measure2, formLayout$Measure2);
        int[] nArray4 = this.groupedSizes(nArray, nArray2);
        int[] nArray5 = this.groupedSizes(nArray, nArray3);
        int n3 = this.sum(nArray4);
        int n4 = this.sum(nArray5);
        int[] nArray6 = this.compressedSizes(list, n, n3, n4, nArray4, nArray3);
        int[] nArray7 = this.groupedSizes(nArray, nArray6);
        int n5 = this.sum(nArray7);
        int[] nArray8 = this.distributedSizes(list, n, n5, nArray7);
        return this.computeOrigins(nArray8, n2);
    }

    private int[] computeOrigins(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        nArray2[0] = n;
        for (int i2 = 1; i2 <= n2; ++i2) {
            nArray2[i2] = nArray2[i2 - 1] + nArray[i2 - 1];
        }
        return nArray2;
    }

    private void layoutComponents(int[] nArray, int[] nArray2) {
        Rectangle rectangle = new Rectangle();
        Iterator iterator = this.constraintMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Component component = (Component)entry.getKey();
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n = cellConstraints.gridX - 1;
            int n2 = cellConstraints.gridY - 1;
            int n3 = cellConstraints.gridWidth;
            int n4 = cellConstraints.gridHeight;
            rectangle.x = nArray[n];
            rectangle.y = nArray2[n2];
            rectangle.width = nArray[n + n3] - rectangle.x;
            rectangle.height = nArray2[n2 + n4] - rectangle.y;
            cellConstraints.setBounds(component, this, rectangle, this.minimumWidthMeasure, this.minimumHeightMeasure, this.preferredWidthMeasure, this.preferredHeightMeasure);
        }
    }

    private void invalidateCaches() {
        this.componentSizeCache.invalidate();
    }

    private int[] maximumSizes(Container container, List list, List[] listArray, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            nArray[i2] = formSpec.maximumSize(container, listArray[i2], formLayout$Measure, formLayout$Measure2, formLayout$Measure3);
        }
        return nArray;
    }

    private int[] compressedSizes(List list, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        if (n < n2) {
            return nArray;
        }
        if (n >= n3) {
            return nArray2;
        }
        int n4 = list.size();
        int[] nArray3 = new int[n4];
        double d2 = n3 - n;
        double d3 = n3 - n2;
        double d4 = d2 / d3;
        for (int i2 = 0; i2 < n4; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            nArray3[i2] = nArray2[i2];
            if (formSpec.getSize() != Sizes.DEFAULT) continue;
            int n5 = i2;
            nArray3[n5] = nArray3[n5] - (int)Math.round((double)(nArray2[i2] - nArray[i2]) * d4);
        }
        return nArray3;
    }

    private int[] groupedSizes(int[][] nArray, int[] nArray2) {
        int n;
        if (nArray == null || nArray.length == 0) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray2.length];
        for (n = 0; n < nArray3.length; ++n) {
            nArray3[n] = nArray2[n];
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            int n3;
            int[] nArray4 = nArray[n];
            int n4 = 0;
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                n2 = nArray4[n3] - 1;
                n4 = Math.max(n4, nArray3[n2]);
            }
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                n2 = nArray4[n3] - 1;
                nArray3[n2] = n4;
            }
        }
        return nArray3;
    }

    private int[] distributedSizes(List list, int n, int n2, int[] nArray) {
        double d2 = n - n2;
        if (d2 < 0.0) {
            return nArray;
        }
        int n3 = list.size();
        double d3 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            d3 += formSpec.getResizeWeight();
        }
        if (d3 == 0.0) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        double d4 = d2;
        int n4 = (int)d2;
        for (int i3 = 0; i3 < n3; ++i3) {
            FormSpec formSpec = (FormSpec)list.get(i3);
            double d5 = formSpec.getResizeWeight();
            if (d5 == 0.0) {
                nArray2[i3] = nArray[i3];
                continue;
            }
            double d6 = d4 - (double)n4;
            double d7 = d2 * d5 / d3;
            double d8 = d7 - d6;
            int n5 = (int)Math.round(d8);
            nArray2[i3] = nArray[i3] + n5;
            d4 -= d7;
            n4 -= n5;
        }
        return nArray2;
    }

    private int sum(int[] nArray) {
        int n = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n += nArray[i2];
        }
        return n;
    }

    private int[] computeMaximumFixedSpanTable(List list) {
        int n = list.size();
        int[] nArray = new int[n];
        int n2 = Integer.MAX_VALUE;
        for (int i2 = n - 1; i2 >= 0; --i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            if (formSpec.canGrow()) {
                n2 = 0;
            }
            nArray[i2] = n2;
            if (n2 >= Integer.MAX_VALUE) continue;
            ++n2;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormLayout$LayoutInfo getLayoutInfo(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            int[] nArray = this.computeGridOrigins(container, n, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
            int[] nArray2 = this.computeGridOrigins(container, n2, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
            return new FormLayout$LayoutInfo(nArray, nArray2, null);
        }
    }

    private int[][] deepClone(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i2 = 0; i2 < nArrayArray.length; ++i2) {
            nArrayArray[i2] = (int[])nArray[i2].clone();
        }
        return nArrayArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        this.invalidateCaches();
        objectOutputStream.defaultWriteObject();
    }
}

