/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.AbstractUnitConverter;
import com.jgoodies.forms.util.DefaultUnitConverter$DialogBaseUnits;
import com.jgoodies.forms.util.DefaultUnitConverter$LookAndFeelChangeHandler;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    private static final Logger LOGGER = Logger.getLogger((class$com$jgoodies$forms$util$DefaultUnitConverter == null ? (class$com$jgoodies$forms$util$DefaultUnitConverter = DefaultUnitConverter.class$("com.jgoodies.forms.util.DefaultUnitConverter")) : class$com$jgoodies$forms$util$DefaultUnitConverter).getName());
    private static DefaultUnitConverter instance;
    private String averageCharWidthTestString = "X";
    private Font defaultDialogFont;
    private PropertyChangeSupport changeSupport;
    private DefaultUnitConverter$DialogBaseUnits cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
    private Map cachedDialogBaseUnits = new HashMap();
    static Class class$com$jgoodies$forms$util$DefaultUnitConverter;

    private DefaultUnitConverter() {
        UIManager.addPropertyChangeListener(new DefaultUnitConverter$LookAndFeelChangeHandler(this, null));
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public static final DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public final String getAverageCharacterWidthTestString() {
        return this.averageCharWidthTestString;
    }

    public final void setAverageCharacterWidthTestString(String string) {
        if (string == null) {
            throw new NullPointerException("The test string must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The test string must not be empty.");
        }
        String string2 = this.averageCharWidthTestString;
        this.averageCharWidthTestString = string;
        this.changeSupport.firePropertyChange("averageCharacterWidthTestString", string2, string);
    }

    public final Font getDefaultDialogFont() {
        if (this.defaultDialogFont == null) {
            this.defaultDialogFont = this.lookupDefaultDialogFont();
        }
        return this.defaultDialogFont;
    }

    public final void setDefaultDialogFont(Font font) {
        Font font2 = this.defaultDialogFont;
        this.defaultDialogFont = font;
        this.changeSupport.firePropertyChange("defaultDialogFont", font2, font);
    }

    protected final double getDialogBaseUnitsX(Component component) {
        return this.getDialogBaseUnits((Component)component).x;
    }

    protected final double getDialogBaseUnitsY(Component component) {
        return this.getDialogBaseUnits((Component)component).y;
    }

    private DefaultUnitConverter$DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits getDialogBaseUnits(Component component) {
        if (component == null) {
            return this.getGlobalDialogBaseUnits();
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.getDefaultDialogFont());
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = (DefaultUnitConverter$DialogBaseUnits)this.cachedDialogBaseUnits.get(fontMetrics);
        if (defaultUnitConverter$DialogBaseUnits == null) {
            defaultUnitConverter$DialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
            this.cachedDialogBaseUnits.put(fontMetrics, defaultUnitConverter$DialogBaseUnits);
        }
        return defaultUnitConverter$DialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits computeDialogBaseUnits(FontMetrics fontMetrics) {
        double d2 = this.computeAverageCharWidth(fontMetrics, this.averageCharWidthTestString);
        int n = fontMetrics.getAscent();
        double d3 = n > 14 ? (double)n : (double)(n + (15 - n) / 3);
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = new DefaultUnitConverter$DialogBaseUnits(d2, d3);
        LOGGER.config("Computed dialog base units " + defaultUnitConverter$DialogBaseUnits + " for: " + fontMetrics.getFont());
        return defaultUnitConverter$DialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits computeGlobalDialogBaseUnits() {
        LOGGER.config("Computing global dialog base units...");
        Font font = this.getDefaultDialogFont();
        FontMetrics fontMetrics = this.createDefaultGlobalComponent().getFontMetrics(font);
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        return defaultUnitConverter$DialogBaseUnits;
    }

    private Font lookupDefaultDialogFont() {
        Font font = UIManager.getFont("Button.font");
        return font != null ? font : new JButton().getFont();
    }

    private Component createDefaultGlobalComponent() {
        return new JPanel(null);
    }

    private void invalidateCaches() {
        this.cachedGlobalDialogBaseUnits = null;
        this.cachedDialogBaseUnits.clear();
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static final void access$100(DefaultUnitConverter defaultUnitConverter) {
        defaultUnitConverter.invalidateCaches();
    }
}

