/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;

    public static final ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    public final void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("Button.borderPaintsFocus"));
    }

    public final void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (this.isToolBarButton(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.is3D(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    PlasticUtils.add3DEffekt(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    protected final void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.borderPaintsFocus) {
            return;
        }
        boolean bl = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
        int n = bl ? 3 : 2;
        int n2 = abstractButton.getWidth() - 1 - n * 2;
        int n3 = abstractButton.getHeight() - 1 - n * 2;
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(n, n, n2 - 1, n3 - 1);
    }

    protected final boolean isToolBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    protected final boolean is3D(AbstractButton abstractButton) {
        if (PlasticUtils.force3D(abstractButton)) {
            return true;
        }
        if (PlasticUtils.forceFlat(abstractButton)) {
            return false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        return PlasticUtils.is3D("Button.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && (!buttonModel.isPressed() || !buttonModel.isArmed());
    }
}

