/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ArrayConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.awt.Color;
import java.lang.reflect.Array;

public class DefaultArrayConverter
extends ArrayConverter {
    public DefaultArrayConverter(String string, Class clazz) {
        super(string, -1, clazz);
    }

    public final String toString(Object object, ConverterContext converterContext) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = this.getElementClass() == Object.class ? (Object[])object : new Object[Array.getLength(object)];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = Array.get(object, i2);
            }
            return this.arrayToString(objectArray, converterContext);
        }
        return ObjectConverterManager.toString(object, this.getElementClass(), converterContext);
    }

    public final boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public final Object fromString(String string, ConverterContext converterContext) {
        if (string == null || "".equals(string)) {
            return new Object[0];
        }
        Object[] objectArray = this.arrayFromString(string, converterContext);
        if (objectArray == null) {
            return new Object[0];
        }
        Class clazz = this.getElementClass();
        if (clazz == Object.class) {
            return objectArray;
        }
        Object[] object = objectArray;
        int n = object.length;
        for (int object2 = 0; object2 < n; ++object2) {
            Object object3 = object[object2];
            if (object3 == null || clazz.isAssignableFrom(object3.getClass())) continue;
            return new Object[0];
        }
        Object object4 = Array.newInstance(clazz, objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            Object object5 = objectArray[n];
            Array.set(object4, n, object5);
        }
        return object4;
    }

    public final boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public static final void main(String[] stringArray) {
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).toString(new int[]{2, 3, 2, 4}, null));
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).fromString("2;3;2;4", null));
        System.out.println(new DefaultArrayConverter(";", Color.class).toString(new Color[]{Color.RED, Color.YELLOW, Color.GREEN}, HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Color.class).fromString("#FF0000;#FFFF00;#00FF00", HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Object.class).fromString("#FF0000;#FFFF00;#00FF00", null));
    }
}

