/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractIntelliHints$1;
import com.jidesoft.hints.AbstractIntelliHints$2;
import com.jidesoft.hints.AbstractIntelliHints$3;
import com.jidesoft.hints.AbstractIntelliHints$4;
import com.jidesoft.hints.AbstractIntelliHints$5;
import com.jidesoft.hints.AbstractIntelliHints$6;
import com.jidesoft.hints.AbstractIntelliHints$7;
import com.jidesoft.hints.AbstractIntelliHints$8;
import com.jidesoft.hints.AbstractIntelliHints$LazyDelegateAction;
import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class AbstractIntelliHints
implements IntelliHints {
    private JidePopup _popup;
    private JTextComponent _textComponent;
    private JComponent _hintsComponent;
    private boolean _followCaret = false;
    private boolean _keyTyped = false;
    private boolean _autoPopup = true;
    private int _showHintsDelay = 200;
    private List _showHintsKeyStrokes;
    private DelegateAction _showAction;
    private DelegateAction acceptAction = new AbstractIntelliHints$6(this);
    private DelegateAction hideAction = new AbstractIntelliHints$7(this);
    private DocumentListener documentListener = new AbstractIntelliHints$8(this);

    public AbstractIntelliHints(JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray;
        this._textComponent = jTextComponent;
        this.getTextComponent().putClientProperty("INTELLI_HINTS", this);
        this._popup = this.createPopup();
        this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        this.getTextComponent().addKeyListener(new AbstractIntelliHints$1(this));
        this.getTextComponent().addFocusListener(new AbstractIntelliHints$2(this));
        this._showAction = new AbstractIntelliHints$3(this);
        this.addShowHintsKeyStroke(this.getShowHintsKeyStroke());
        for (KeyStroke keyStroke : keyStrokeArray = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, new AbstractIntelliHints$LazyDelegateAction(this, keyStroke));
        }
    }

    protected final JidePopup createPopup() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setLayout(new BorderLayout());
        jidePopup.setResizable(true);
        jidePopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        jidePopup.setMovable(false);
        jidePopup.addPopupMenuListener(new AbstractIntelliHints$4(this));
        jidePopup.setTransient(true);
        jidePopup.setKeepPreviousSize(false);
        jidePopup.setReturnFocusToOwner(false);
        return jidePopup;
    }

    public final JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public void acceptHint(Object object) {
        String string;
        int n;
        String string2;
        if (object == null) {
            return;
        }
        int n2 = this.getTextComponent().getCaretPosition();
        if (this.isMultilineTextComponent()) {
            string2 = this.getTextComponent().getText();
            n = string2.lastIndexOf(10, n2 - 1);
            String string3 = n2 == -1 ? "" : string2.substring(n2);
            string2 = string2.substring(0, n + 1);
            string2 = string2 + object;
            string = string2 = string2 + string3;
        } else {
            string = object.toString();
        }
        this.getTextComponent().setText(string);
        string2 = this.getTextComponent().getText();
        n = string2.indexOf(10, n2);
        this.getTextComponent().setCaretPosition(n == -1 ? string2.length() : n);
    }

    protected final boolean isMultilineTextComponent() {
        return this.getTextComponent() instanceof JTextArea || this.getTextComponent() instanceof JEditorPane;
    }

    protected final void showHintsPopup() {
        if (!this.getTextComponent().isEnabled() || !this.getTextComponent().hasFocus()) {
            return;
        }
        this.showHints();
    }

    public final void showHints() {
        if (this._popup == null) {
            return;
        }
        if (this._hintsComponent == null) {
            this._hintsComponent = this.createHintsComponent();
            this._popup.add(this._hintsComponent);
            this.getDelegateComponent().setRequestFocusEnabled(false);
            this.getDelegateComponent().addMouseListener(new AbstractIntelliHints$5(this));
        }
        if (this.updateHints(this.getContext())) {
            if (!this.isHintsPopupVisible()) {
                DelegateAction.replaceAction(this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), this.hideAction);
                DelegateAction.replaceAction((JComponent)this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), this.acceptAction, true);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                int n4 = this.getCaretPositionForPopup();
                Rectangle rectangle = this.getCaretRectangleForPopup(n4);
                n2 = rectangle.y;
                n = rectangle.x;
                n3 = rectangle.height;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this._popup.setOwner(this.getTextComponent());
            this._popup.showPopup(new Insets(n2, n, this.getTextComponent().getHeight() - n3 - n2, 0));
        } else {
            this._popup.hidePopup();
        }
    }

    protected final Rectangle getCaretRectangleForPopup(int n) {
        return this.getTextComponent().getUI().modelToView(this.getTextComponent(), n);
    }

    protected final int getCaretPositionForPopup() {
        int n = Math.min(this.getTextComponent().getCaret().getDot(), this.getTextComponent().getCaret().getMark());
        if (this.isFollowCaret()) {
            return n;
        }
        try {
            Rectangle rectangle = this.getTextComponent().getUI().modelToView(this.getTextComponent(), n);
            rectangle.x = 0;
            return this.getTextComponent().getUI().viewToModel(this.getTextComponent(), rectangle.getLocation());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    protected final Object getContext() {
        if (this.isMultilineTextComponent()) {
            int n = this.getTextComponent().getCaretPosition();
            if (n == 0) {
                return "";
            }
            String string = this.getTextComponent().getText();
            int n2 = string.lastIndexOf(10, n - 1);
            return string.substring(n2 + 1, n);
        }
        return this.getTextComponent().getText();
    }

    protected final void hideHintsPopup() {
        if (this._popup != null) {
            this._popup.hidePopup();
        }
        this.setKeyTyped(false);
    }

    public final void setHintsEnabled(boolean bl) {
        if (!bl) {
            this.getTextComponent().getDocument().removeDocumentListener(this.documentListener);
        } else {
            this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        }
    }

    public final boolean isHintsPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public final boolean isFollowCaret() {
        return this._followCaret;
    }

    public final void setFollowCaret(boolean bl) {
        this._followCaret = bl;
    }

    public final boolean isAutoPopup() {
        return this._autoPopup;
    }

    public final void setAutoPopup(boolean bl) {
        this._autoPopup = bl;
    }

    protected abstract KeyStroke[] getDelegateKeyStrokes();

    protected abstract JComponent getDelegateComponent();

    protected final KeyStroke getShowHintsKeyStroke() {
        if (this.isMultilineTextComponent()) {
            return KeyStroke.getKeyStroke(32, 2);
        }
        return KeyStroke.getKeyStroke(40, 0);
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean bl) {
        this._keyTyped = bl;
    }

    public final int getShowHintsDelay() {
        return this._showHintsDelay;
    }

    public final void setShowHintsDelay(int n) {
        this._showHintsDelay = n;
    }

    public final void addShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this._showHintsKeyStrokes == null) {
            this._showHintsKeyStrokes = new ArrayList();
        }
        this._showHintsKeyStrokes.add(keyStroke);
        DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, this._showAction);
    }

    public final void removeShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this._showHintsKeyStrokes != null) {
            this._showHintsKeyStrokes.remove(keyStroke);
            DelegateAction.restoreAction((JComponent)this.getTextComponent(), 0, keyStroke, this._showAction);
        }
    }

    public final KeyStroke[] getAllShowHintsKeyStrokes() {
        if (this._showHintsKeyStrokes == null) {
            return new KeyStroke[0];
        }
        return this._showHintsKeyStrokes.toArray(new KeyStroke[this._showHintsKeyStrokes.size()]);
    }

    public static final IntelliHints getIntelliHints(JComponent jComponent) {
        return (IntelliHints)jComponent.getClientProperty("INTELLI_HINTS");
    }

    static final /* synthetic */ void access$000(AbstractIntelliHints abstractIntelliHints, boolean bl) {
        abstractIntelliHints.setKeyTyped(bl);
    }

    static final /* synthetic */ JidePopup access$100(AbstractIntelliHints abstractIntelliHints) {
        return abstractIntelliHints._popup;
    }

    static final /* synthetic */ DelegateAction access$200(AbstractIntelliHints abstractIntelliHints) {
        return abstractIntelliHints.hideAction;
    }

    static final /* synthetic */ DelegateAction access$300(AbstractIntelliHints abstractIntelliHints) {
        return abstractIntelliHints.acceptAction;
    }

    static final /* synthetic */ JTextComponent access$400(AbstractIntelliHints abstractIntelliHints) {
        return abstractIntelliHints._textComponent;
    }

    static final /* synthetic */ boolean access$500(AbstractIntelliHints abstractIntelliHints) {
        return abstractIntelliHints.isKeyTyped();
    }
}

