/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private boolean _brighter;
    private static int _percent = 30;
    private static ColorFilter _colorFilter;

    public static final ColorFilter getInstance(boolean bl, int n) {
        if (_colorFilter == null) {
            _colorFilter = new ColorFilter(bl, n);
        } else {
            _colorFilter.setBrighter(bl);
            ColorFilter.setPercent(n);
        }
        return _colorFilter;
    }

    public final void setBrighter(boolean bl) {
        this._brighter = bl;
    }

    public static final void setPercent(int n) {
        _percent = n;
    }

    public static final int getPercent() {
        return _percent;
    }

    public static final Image createBrighterImage(Image image) {
        ColorFilter colorFilter = ColorFilter.getInstance(true, _percent);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), colorFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static final Image createBrighterImage(Image image, int n) {
        ColorFilter.setPercent(n);
        return ColorFilter.createBrighterImage(image);
    }

    public static final Image createDarkerImage(Image image) {
        ColorFilter colorFilter = ColorFilter.getInstance(false, _percent);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), colorFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static final Image createDarkerImage(Image image, int n) {
        ColorFilter.setPercent(n);
        return ColorFilter.createDarkerImage(image);
    }

    public ColorFilter(boolean bl, int n) {
        this._brighter = bl;
        _percent = n;
        this.canFilterIndexColorModel = true;
    }

    public final int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        return n3 & 0xFF000000 | this.convert(n4) << 16 | this.convert(n5) << 8 | this.convert(n6);
    }

    private int convert(int n) {
        n = this._brighter ? (n += (255 - n) * _percent / 100) : (n -= (255 - n) * _percent / 100);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }
}

