/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.BinaryPListParser$BPLArray;
import com.jidesoft.plaf.aqua.BinaryPListParser$BPLDict;
import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.utils.Base64;
import com.jidesoft.utils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class BinaryPListParser {
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList objectTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XMLElement parse(File file) {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            int n = randomAccessFile.readInt();
            int n2 = randomAccessFile.readInt();
            if (n != 1651534953 || n2 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            randomAccessFile.seek(randomAccessFile.length() - 32L);
            this.offsetCount = (int)randomAccessFile.readLong();
            this.refCount = (int)randomAccessFile.readLong();
            this.objectCount = (int)randomAccessFile.readLong();
            this.topLevelOffset = (int)randomAccessFile.readLong();
            byArray = new byte[this.topLevelOffset - 8];
            randomAccessFile.seek(8L);
            randomAccessFile.readFully(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        this.objectTable = new ArrayList();
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parseObjectTable((DataInputStream)filterInputStream);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        XMLElement xMLElement = new XMLElement(new HashMap(), false, false);
        xMLElement.setName("plist");
        xMLElement.setAttribute("version", "1.0");
        this.convertObjectTableToXML(xMLElement, this.objectTable.get(0));
        return xMLElement;
    }

    private void convertObjectTableToXML(XMLElement xMLElement, Object object) {
        XMLElement xMLElement2 = xMLElement.createAnotherElement();
        if (object instanceof BinaryPListParser$BPLDict) {
            BinaryPListParser$BPLDict binaryPListParser$BPLDict = (BinaryPListParser$BPLDict)object;
            xMLElement2.setName("dict");
            for (int i2 = 0; i2 < binaryPListParser$BPLDict.keyref.length; ++i2) {
                XMLElement xMLElement3 = xMLElement.createAnotherElement();
                xMLElement3.setName("key");
                xMLElement3.setContent(binaryPListParser$BPLDict.getKey(i2));
                xMLElement2.addChild(xMLElement3);
                this.convertObjectTableToXML(xMLElement2, binaryPListParser$BPLDict.getValue(i2));
            }
        } else if (object instanceof BinaryPListParser$BPLArray) {
            BinaryPListParser$BPLArray binaryPListParser$BPLArray = (BinaryPListParser$BPLArray)object;
            xMLElement2.setName("array");
            for (int i3 = 0; i3 < binaryPListParser$BPLArray.objref.length; ++i3) {
                this.convertObjectTableToXML(xMLElement2, binaryPListParser$BPLArray.getValue(i3));
            }
        } else if (object instanceof String) {
            xMLElement2.setName("string");
            xMLElement2.setContent((String)object);
        } else if (object instanceof Integer) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Long) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Float) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Double) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Boolean) {
            xMLElement2.setName("boolean");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof byte[]) {
            xMLElement2.setName("data");
            xMLElement2.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof Date) {
            xMLElement2.setName("date");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            xMLElement2.setContent(simpleDateFormat.format((Date)object));
        } else {
            xMLElement2.setName("unsupported");
            xMLElement2.setContent(object.toString());
        }
        xMLElement.addChild(xMLElement2);
    }

    private void parseObjectTable(DataInputStream dataInputStream) {
        int n;
        while ((n = dataInputStream.read()) != -1) {
            switch ((n & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(dataInputStream, n & 0xF);
                    break;
                }
                case 1: {
                    int n2 = 1 << (n & 0xF);
                    this.parseInt(dataInputStream, n2);
                    break;
                }
                case 2: {
                    int n2 = 1 << (n & 0xF);
                    this.parseReal(dataInputStream, n2);
                    break;
                }
                case 3: {
                    if ((n & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    }
                    this.parseDate(dataInputStream);
                    break;
                }
                case 4: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseData(dataInputStream, n2);
                    break;
                }
                case 5: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseAsciiString(dataInputStream, n2);
                    break;
                }
                case 6: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseUnicodeString(dataInputStream, n2);
                    break;
                }
                case 7: {
                    System.out.println("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    return;
                }
                case 8: {
                    int n2 = (n & 0xF) + 1;
                    System.out.println("uid " + n2);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 10: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(dataInputStream, n2);
                        break;
                    }
                    this.parseByteArray(dataInputStream, n2);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 13: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(dataInputStream, n2);
                        break;
                    }
                    this.parseByteDict(dataInputStream, n2);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
            }
        }
    }

    private int readCount(DataInputStream dataInputStream) {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((n & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(n));
        }
        int n2 = 1 << (n & 0xF);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = dataInputStream.read();
            if (n4 == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            n3 = n3 << 8 | n4;
        }
        return n3;
    }

    private void parsePrimitive(DataInputStream dataInputStream, int n) {
        switch (n) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(n));
            }
        }
    }

    private void parseByteArray(DataInputStream dataInputStream, int n) {
        BinaryPListParser$BPLArray binaryPListParser$BPLArray = new BinaryPListParser$BPLArray(null);
        binaryPListParser$BPLArray.objectTable = this.objectTable;
        binaryPListParser$BPLArray.objref = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            binaryPListParser$BPLArray.objref[i2] = dataInputStream.readByte() & 0xFF;
            if (binaryPListParser$BPLArray.objref[i2] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(binaryPListParser$BPLArray);
    }

    private void parseShortArray(DataInputStream dataInputStream, int n) {
        BinaryPListParser$BPLArray binaryPListParser$BPLArray = new BinaryPListParser$BPLArray(null);
        binaryPListParser$BPLArray.objectTable = this.objectTable;
        binaryPListParser$BPLArray.objref = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            binaryPListParser$BPLArray.objref[i2] = dataInputStream.readShort() & 0xFFFF;
            if (binaryPListParser$BPLArray.objref[i2] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(binaryPListParser$BPLArray);
    }

    private void parseData(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this.objectTable.add(byArray);
    }

    private void parseByteDict(DataInputStream dataInputStream, int n) {
        int n2;
        BinaryPListParser$BPLDict binaryPListParser$BPLDict = new BinaryPListParser$BPLDict(null);
        binaryPListParser$BPLDict.objectTable = this.objectTable;
        binaryPListParser$BPLDict.keyref = new int[n];
        binaryPListParser$BPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            binaryPListParser$BPLDict.keyref[n2] = dataInputStream.readByte() & 0xFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            binaryPListParser$BPLDict.objref[n2] = dataInputStream.readByte() & 0xFF;
        }
        this.objectTable.add(binaryPListParser$BPLDict);
    }

    private void parseShortDict(DataInputStream dataInputStream, int n) {
        int n2;
        BinaryPListParser$BPLDict binaryPListParser$BPLDict = new BinaryPListParser$BPLDict(null);
        binaryPListParser$BPLDict.objectTable = this.objectTable;
        binaryPListParser$BPLDict.keyref = new int[n];
        binaryPListParser$BPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            binaryPListParser$BPLDict.keyref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            binaryPListParser$BPLDict.objref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        this.objectTable.add(binaryPListParser$BPLDict);
    }

    private void parseAsciiString(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "ASCII");
        this.objectTable.add(string);
    }

    private void parseInt(DataInputStream dataInputStream, int n) {
        if (n > 8) {
            throw new IOException("parseInt: unsupported byte count:" + n);
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = dataInputStream.read();
            if (n2 == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            l2 = l2 << 8 | (long)n2;
        }
        this.objectTable.add(l2);
    }

    private void parseReal(DataInputStream dataInputStream, int n) {
        switch (n) {
            case 4: {
                this.objectTable.add(Float.valueOf(dataInputStream.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(dataInputStream.readDouble());
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + n);
            }
        }
    }

    private void parseDate(DataInputStream dataInputStream) {
        double d2 = dataInputStream.readDouble();
        this.objectTable.add(new Date());
    }

    private void parseUnicodeString(DataInputStream dataInputStream, int n) {
        char[] cArray = new char[n];
        for (int i2 = 0; i2 < n; ++i2) {
            cArray[i2] = dataInputStream.readChar();
        }
        String string = new String(cArray);
        this.objectTable.add(string);
    }

    public static final void main(String[] stringArray) {
        try {
            File[] fileArray = new File(SecurityUtils.getProperty("user.home", ""), "Library/Preferences").listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string = fileArray[i2].getName();
                if (fileArray[i2].isDirectory() || !string.endsWith(".plist") || string.endsWith("internetconfig.plist")) continue;
                try {
                    System.out.println(fileArray[i2]);
                    BinaryPListParser binaryPListParser = new BinaryPListParser();
                    XMLElement xMLElement = binaryPListParser.parse(fileArray[i2]);
                    System.out.println(xMLElement);
                    continue;
                }
                catch (IOException iOException) {
                    if (iOException.getMessage() != null && (iOException.getMessage().startsWith("parseHeader") || iOException.getMessage().startsWith("parseTrailer"))) {
                        System.out.println(iOException);
                        continue;
                    }
                    throw iOException;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

