/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.AnimationController$AnimationState;
import com.jidesoft.plaf.windows.AnimationController$PartUIClientPropertyKey;
import com.jidesoft.plaf.windows.TMSchema$Part;
import com.jidesoft.plaf.windows.TMSchema$Prop;
import com.jidesoft.plaf.windows.TMSchema$State;
import com.jidesoft.plaf.windows.XPStyle;
import com.jidesoft.plaf.windows.XPStyle$Skin;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import sun.awt.AppContext;
import sun.security.action.GetBooleanAction;

class AnimationController
implements ActionListener,
PropertyChangeListener {
    private static final boolean VISTA_ANIMATION_DISABLED = AccessController.doPrivileged(new GetBooleanAction("swing.disablevistaanimation"));
    private static final Object ANIMATION_CONTROLLER_KEY = new StringBuilder("ANIMATION_CONTROLLER_KEY");
    private final Map animationStateMap = new WeakHashMap();
    private final Timer timer = new Timer(33, this);

    private static synchronized AnimationController getAnimationController() {
        AppContext appContext = AppContext.getAppContext();
        Object object = appContext.get(ANIMATION_CONTROLLER_KEY);
        if (object == null) {
            object = new AnimationController();
            appContext.put(ANIMATION_CONTROLLER_KEY, object);
        }
        return (AnimationController)object;
    }

    private AnimationController() {
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        UIManager.addPropertyChangeListener(this);
    }

    private static void triggerAnimation(JComponent jComponent, TMSchema$Part tMSchema$Part, TMSchema$State tMSchema$State) {
        if (jComponent instanceof JTabbedPane || tMSchema$Part == TMSchema$Part.TP_BUTTON) {
            return;
        }
        AnimationController animationController = AnimationController.getAnimationController();
        TMSchema$State tMSchema$State2 = animationController.getState(jComponent, tMSchema$Part);
        if (tMSchema$State2 != tMSchema$State) {
            animationController.putState(jComponent, tMSchema$Part, tMSchema$State);
            if (tMSchema$State == TMSchema$State.DEFAULTED) {
                tMSchema$State2 = TMSchema$State.HOT;
            }
            if (tMSchema$State2 != null) {
                long l2 = tMSchema$State == TMSchema$State.DEFAULTED ? 1000L : XPStyle.getXP().getThemeTransitionDuration(jComponent, tMSchema$Part, AnimationController.normalizeState(tMSchema$State2), AnimationController.normalizeState(tMSchema$State), TMSchema$Prop.TRANSITIONDURATIONS);
                animationController.startAnimation(jComponent, tMSchema$Part, tMSchema$State2, tMSchema$State, l2);
            }
        }
    }

    private static TMSchema$State normalizeState(TMSchema$State tMSchema$State) {
        TMSchema$State tMSchema$State2;
        switch (tMSchema$State) {
            case DOWNPRESSED: 
            case LEFTPRESSED: 
            case RIGHTPRESSED: {
                tMSchema$State2 = TMSchema$State.UPPRESSED;
                break;
            }
            case DOWNDISABLED: 
            case LEFTDISABLED: 
            case RIGHTDISABLED: {
                tMSchema$State2 = TMSchema$State.UPDISABLED;
                break;
            }
            case DOWNHOT: 
            case LEFTHOT: 
            case RIGHTHOT: {
                tMSchema$State2 = TMSchema$State.UPHOT;
                break;
            }
            case DOWNNORMAL: 
            case LEFTNORMAL: 
            case RIGHTNORMAL: {
                tMSchema$State2 = TMSchema$State.UPNORMAL;
                break;
            }
            default: {
                tMSchema$State2 = tMSchema$State;
            }
        }
        return tMSchema$State2;
    }

    private synchronized TMSchema$State getState(JComponent jComponent, TMSchema$Part tMSchema$Part) {
        TMSchema$State tMSchema$State = null;
        Object object = jComponent.getClientProperty(AnimationController$PartUIClientPropertyKey.getKey(tMSchema$Part));
        if (object instanceof TMSchema$State) {
            tMSchema$State = (TMSchema$State)((Object)object);
        }
        return tMSchema$State;
    }

    private synchronized void putState(JComponent jComponent, TMSchema$Part tMSchema$Part, TMSchema$State tMSchema$State) {
        jComponent.putClientProperty(AnimationController$PartUIClientPropertyKey.getKey(tMSchema$Part), (Object)tMSchema$State);
    }

    private synchronized void startAnimation(JComponent jComponent, TMSchema$Part tMSchema$Part, TMSchema$State tMSchema$State, TMSchema$State tMSchema$State2, long l2) {
        boolean bl = false;
        if (tMSchema$State2 == TMSchema$State.DEFAULTED) {
            bl = true;
        }
        EnumMap<TMSchema$Part, AnimationController$AnimationState> enumMap = (EnumMap<TMSchema$Part, AnimationController$AnimationState>)this.animationStateMap.get(jComponent);
        if (l2 <= 0L) {
            if (enumMap != null) {
                enumMap.remove((Object)tMSchema$Part);
                if (enumMap.size() == 0) {
                    this.animationStateMap.remove(jComponent);
                }
            }
            return;
        }
        if (enumMap == null) {
            enumMap = new EnumMap<TMSchema$Part, AnimationController$AnimationState>(TMSchema$Part.class);
            this.animationStateMap.put(jComponent, enumMap);
        }
        enumMap.put(tMSchema$Part, new AnimationController$AnimationState(tMSchema$State, l2, bl));
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void paintSkin(JComponent jComponent, XPStyle$Skin xPStyle$Skin, Graphics graphics, int n, int n2, int n3, int n4, TMSchema$State tMSchema$State) {
        AnimationController animationController;
        if (VISTA_ANIMATION_DISABLED) {
            xPStyle$Skin.paintSkinRaw(graphics, n, n2, n3, n4, tMSchema$State);
            return;
        }
        AnimationController.triggerAnimation(jComponent, xPStyle$Skin.part, tMSchema$State);
        AnimationController animationController2 = animationController = AnimationController.getAnimationController();
        synchronized (animationController2) {
            AnimationController$AnimationState animationController$AnimationState = null;
            Map map = (Map)animationController.animationStateMap.get(jComponent);
            if (map != null) {
                animationController$AnimationState = (AnimationController$AnimationState)map.get((Object)xPStyle$Skin.part);
            }
            if (animationController$AnimationState != null) {
                animationController$AnimationState.paintSkin(xPStyle$Skin, graphics, n, n2, n3, n4, tMSchema$State);
            } else {
                xPStyle$Skin.paintSkinRaw(graphics, n, n2, n3, n4, tMSchema$State);
            }
        }
    }

    public final synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lookAndFeel" == propertyChangeEvent.getPropertyName() && !(propertyChangeEvent.getNewValue() instanceof WindowsLookAndFeel)) {
            this.dispose();
        }
    }

    public final synchronized void actionPerformed(ActionEvent actionEvent) {
        ArrayList<JComponent> arrayList = null;
        ArrayList<TMSchema$Part> arrayList2 = null;
        for (JComponent jComponent : this.animationStateMap.keySet()) {
            jComponent.repaint();
            if (arrayList2 != null) {
                arrayList2.clear();
            }
            Map map = (Map)this.animationStateMap.get(jComponent);
            if (!jComponent.isShowing() || map == null || map.size() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<JComponent>();
                }
                arrayList.add(jComponent);
                continue;
            }
            for (TMSchema$Part tMSchema$Part : map.keySet()) {
                if (!((AnimationController$AnimationState)map.get((Object)tMSchema$Part)).isDone()) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<TMSchema$Part>();
                }
                arrayList2.add(tMSchema$Part);
            }
            if (arrayList2 == null) continue;
            if (arrayList2.size() == map.size()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(jComponent);
                continue;
            }
            for (TMSchema$Part tMSchema$Part : arrayList2) {
                map.remove((Object)tMSchema$Part);
            }
        }
        if (arrayList != null) {
            for (JComponent jComponent : arrayList) {
                this.animationStateMap.remove(jComponent);
            }
        }
        if (this.animationStateMap.size() == 0) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispose() {
        this.timer.stop();
        UIManager.removePropertyChangeListener(this);
        Class<AnimationController> clazz = AnimationController.class;
        synchronized (AnimationController.class) {
            AppContext.getAppContext().put(ANIMATION_CONTROLLER_KEY, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

