/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.JideSwingUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel
implements TreeModelListener {
    private TreeModel _model;
    private boolean _digIn = true;
    private CheckBoxTree _tree;
    protected Set _pathHasAdded;
    private boolean _singleEventMode = false;
    private static final long serialVersionUID = 1368502059666946634L;
    private boolean _fireEvent = true;
    private boolean _batchMode = false;
    private Set _toBeAdded = new HashSet();
    private Set _toBeRemoved = new HashSet();

    public CheckBoxTreeSelectionModel(TreeModel treeModel) {
        this.setModel(treeModel);
        this.setSelectionMode(4);
    }

    final void setTree(CheckBoxTree checkBoxTree) {
        this._tree = checkBoxTree;
    }

    public CheckBoxTreeSelectionModel(TreeModel treeModel, boolean bl) {
        this.setModel(treeModel);
        this._digIn = bl;
    }

    public final TreeModel getModel() {
        return this._model;
    }

    public final void setModel(TreeModel treeModel) {
        if (this._model != treeModel) {
            this.clearSelection();
            if (this._model != null) {
                this._model.removeTreeModelListener(this);
            }
            this._model = treeModel;
            if (this._model != null) {
                this._model.addTreeModelListener(this);
            }
        }
    }

    public final boolean isDigIn() {
        return this._digIn;
    }

    public final void setDigIn(boolean bl) {
        this._digIn = bl;
    }

    public final boolean isPartiallySelected(TreePath treePath) {
        if (!this.isDigIn()) {
            return this.isPathSelected(treePath, false);
        }
        if (this.isPathSelected(treePath, true)) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath2 : treePathArray) {
            if (!this.isDescendant(treePath2, treePath)) continue;
            return true;
        }
        return false;
    }

    public final boolean isRowSelected(int n) {
        return this.isPathSelected(this._tree.getPathForRow(n), this._tree.isDigIn());
    }

    protected final boolean isParentActuallySelected(TreePath treePath, TreePath treePath2) {
        return true;
    }

    public final boolean isPathSelected(TreePath treePath) {
        return super.isPathSelected(treePath);
    }

    public final boolean isPathSelected(TreePath treePath, boolean bl) {
        TreePath treePath2;
        if (treePath == null) {
            return false;
        }
        if (!bl) {
            return super.isPathSelected(treePath);
        }
        for (treePath2 = treePath; treePath2 != null && !super.isPathSelected(treePath2); treePath2 = treePath2.getParentPath()) {
        }
        if (treePath2 != null) {
            return this.isParentActuallySelected(treePath, treePath2);
        }
        if (this._model == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        if (this.getChildrenCount(object) == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.getChildrenCount(object); ++i2) {
            Object object2 = this.getChild(object, i2);
            if (this.isPathSelected(treePath.pathByAddingChild(object2), true)) continue;
            bl2 = false;
            break;
        }
        if (this._tree.isCheckBoxVisible(treePath) && bl2) {
            this.addSelectionPaths(new TreePath[]{treePath}, false);
        }
        return bl2;
    }

    final boolean isDescendant(TreePath treePath, TreePath treePath2) {
        Object[] objectArray;
        Object[] objectArray2 = treePath.getPath();
        if (objectArray2.length < (objectArray = treePath2.getPath()).length) {
            return false;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray2[i2] == objectArray[i2]) continue;
            return false;
        }
        return true;
    }

    protected final void notifyPathChange(Vector vector, TreePath treePath) {
        if (this._fireEvent) {
            super.notifyPathChange(vector, treePath);
        }
    }

    public final void setSelectionPaths(TreePath[] treePathArray) {
        if (!this.isDigIn() || this.selectionMode == 1) {
            super.setSelectionPaths(treePathArray);
        } else {
            this.clearSelection();
            this.addSelectionPaths(treePathArray);
        }
    }

    public final void addSelectionPaths(TreePath[] treePathArray) {
        this.addSelectionPaths(treePathArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void addSelectionPaths(TreePath[] treePathArray, boolean bl) {
        if (!this.isDigIn()) {
            super.addSelectionPaths(treePathArray);
            return;
        }
        this.setBatchMode(true);
        boolean bl2 = false;
        if (this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            bl2 = true;
        }
        try {
            if (bl) {
                this._pathHasAdded = new HashSet();
                for (TreePath treePath : treePathArray) {
                    void object;
                    if (this.isPathSelected(treePath, this.isDigIn())) continue;
                    if (this._toBeAdded.contains(treePath)) {
                        this.addToExistingSet(this._pathHasAdded, treePath);
                        continue;
                    }
                    boolean bl3 = false;
                    for (TreePath treePath2 : this._pathHasAdded) {
                        if (!treePath2.isDescendant(treePath)) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    Iterator iterator = null;
                    while (this.areSiblingsSelected((TreePath)object)) {
                        iterator = object;
                        if (object.getParentPath() == null) break;
                        TreePath treePath3 = object.getParentPath();
                    }
                    if (iterator != null) {
                        if (((TreePath)((Object)iterator)).getParentPath() != null) {
                            this.delegateAddSelectionPaths(new TreePath[]{((TreePath)((Object)iterator)).getParentPath()});
                        } else {
                            this.delegateAddSelectionPaths(new TreePath[]{iterator});
                        }
                    } else {
                        this.delegateAddSelectionPaths(new TreePath[]{object});
                    }
                    this.addToExistingSet(this._pathHasAdded, (TreePath)object);
                }
                ArrayList arrayList = new ArrayList();
                for (TreePath treePath : this._toBeAdded) {
                    TreePath[] treePathArray2 = this.getSelectionPaths();
                    if (treePathArray2 == null) break;
                    for (TreePath treePath4 : treePathArray2) {
                        if (!this.isDescendant(treePath4, treePath)) continue;
                        arrayList.add(treePath4);
                    }
                }
                if (arrayList.size() > 0) {
                    this.delegateRemoveSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
            } else {
                void var7_20;
                Object object;
                TreePath treePath;
                void var7_18;
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                TreePath[] treePathArray3 = treePathArray;
                int n = treePathArray3.length;
                boolean bl4 = false;
                while (var7_18 < n) {
                    treePath = treePathArray3[var7_18];
                    object = this.getSelectionPaths();
                    if (object == null) break;
                    for (TreePath treePath5 : object) {
                        if (!this.isDescendant(treePath5, treePath)) continue;
                        arrayList.add(treePath5);
                    }
                    ++var7_18;
                }
                if (arrayList.size() > 0) {
                    this.delegateRemoveSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
                treePathArray3 = treePathArray;
                n = treePathArray3.length;
                boolean bl5 = false;
                while (var7_20 < n) {
                    treePath = treePathArray3[var7_20];
                    object = null;
                    while (this.areSiblingsSelected(treePath)) {
                        object = treePath;
                        if (treePath.getParentPath() == null) break;
                        treePath = treePath.getParentPath();
                    }
                    if (object != null) {
                        if (((TreePath)object).getParentPath() != null) {
                            this.addSelectionPath(((TreePath)object).getParentPath());
                        } else {
                            if (!this.isSelectionEmpty()) {
                                this.removeSelectionPaths(this.getSelectionPaths(), !bl2);
                            }
                            this.delegateAddSelectionPaths(new TreePath[]{object});
                        }
                    } else {
                        this.delegateAddSelectionPaths(new TreePath[]{treePath});
                    }
                    ++var7_20;
                }
            }
        }
        finally {
            if (this.isSingleEventMode() && bl2) {
                this.setBatchMode(false);
            }
            this._fireEvent = true;
            if (this.isSingleEventMode() && bl2) {
                this.notifyPathChange(treePathArray, true, treePathArray[0]);
            } else {
                this.setBatchMode(false);
            }
        }
    }

    protected final boolean areSiblingsSelected(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        int n = this.getChildrenCount(object2);
        for (int i2 = 0; i2 < n; ++i2) {
            Object object3 = this.getChild(object2, i2);
            if (object3 == object) continue;
            TreePath treePath3 = treePath2.pathByAddingChild(object3);
            if (!(this._tree == null || this._tree.isCheckBoxVisible(treePath3) || this.isPathSelected(treePath3, true) || this._pathHasAdded != null && this._pathHasAdded.contains(treePath3))) {
                return false;
            }
            if (this.isPathSelected(treePath3) || this._pathHasAdded != null && this._pathHasAdded.contains(treePath3)) continue;
            return false;
        }
        return true;
    }

    public final void removeSelectionPaths(TreePath[] treePathArray) {
        this.removeSelectionPaths(treePathArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSelectionPaths(TreePath[] treePathArray, boolean bl) {
        if (!this.isDigIn()) {
            super.removeSelectionPaths(treePathArray);
            return;
        }
        boolean bl2 = false;
        if (bl && this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            bl2 = true;
        }
        this.setBatchMode(true);
        try {
            HashSet hashSet = new HashSet();
            for (TreePath treePath : treePathArray) {
                Serializable serializable3;
                Object object2;
                if (!this.isPathSelected(treePath, this.isDigIn())) continue;
                Serializable serializable2 = null;
                if (this._toBeAdded.contains(treePath)) {
                    this._toBeAdded.remove(treePath);
                    this.addToExistingSet(hashSet, treePath);
                    continue;
                }
                boolean bl3 = false;
                for (Object object2 : hashSet) {
                    if (!((TreePath)object2).isDescendant(treePath)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                HashSet hashSet2 = new HashSet();
                for (Serializable serializable3 : this._toBeAdded) {
                    if (!treePath.isDescendant((TreePath)serializable3)) continue;
                    hashSet2.add(serializable3);
                }
                this._toBeAdded.removeAll(hashSet2);
                object2 = this._toBeAdded.iterator();
                while (object2.hasNext()) {
                    serializable3 = (TreePath)object2.next();
                    if (!((TreePath)serializable3).isDescendant(treePath)) continue;
                    serializable2 = serializable3;
                    break;
                }
                serializable3 = new Stack();
                for (object2 = treePath.getParentPath(); object2 != null && (serializable2 == null ? !this.isPathSelected((TreePath)object2) : object2 != serializable2); object2 = ((TreePath)object2).getParentPath()) {
                    ((Stack)serializable3).push(object2);
                }
                if (object2 == null) {
                    this.delegateRemoveSelectionPaths(new TreePath[]{treePath});
                    this.addToExistingSet(hashSet, treePath);
                    continue;
                }
                ((Stack)serializable3).push(object2);
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                while (!((Vector)serializable3).isEmpty()) {
                    TreePath treePath2 = (TreePath)((Stack)serializable3).pop();
                    TreePath treePath3 = ((Vector)serializable3).isEmpty() ? treePath : (TreePath)((Stack)serializable3).peek();
                    Object object3 = treePath2.getLastPathComponent();
                    Object object4 = treePath3.getLastPathComponent();
                    int n = this.getChildrenCount(object3);
                    for (int i2 = 0; i2 < n; ++i2) {
                        Object object5 = this.getChild(object3, i2);
                        if (JideSwingUtilities.equals(object5, object4)) continue;
                        TreePath treePath4 = treePath2.pathByAddingChild(object5);
                        arrayList.add(treePath4);
                    }
                }
                if (arrayList.size() > 0) {
                    this.delegateAddSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
                this.delegateRemoveSelectionPaths(new TreePath[]{object2});
                this.addToExistingSet(hashSet, treePath);
            }
        }
        finally {
            if (this.isSingleEventMode() && bl2) {
                this.setBatchMode(false);
            }
            this._fireEvent = true;
            if (this.isSingleEventMode() && bl2) {
                this.notifyPathChange(treePathArray, false, treePathArray[0]);
            } else {
                this.setBatchMode(false);
            }
        }
    }

    protected final Object getChild(Object object, int n) {
        return this._model.getChild(object, n);
    }

    protected final int getChildrenCount(Object object) {
        return this._model.getChildCount(object);
    }

    private void addToExistingSet(Set set, TreePath treePath) {
        if (set.contains(treePath)) {
            return;
        }
        for (Object object : set) {
            if (!((TreePath)object).isDescendant(treePath)) continue;
            return;
        }
        HashSet hashSet = new HashSet();
        for (TreePath treePath2 : set) {
            if (!treePath.isDescendant(treePath2)) continue;
            hashSet.add(treePath2);
        }
        set.removeAll(hashSet);
        set.add(treePath);
    }

    public final boolean isSingleEventMode() {
        return this._singleEventMode;
    }

    public final void setSingleEventMode(boolean bl) {
        this._singleEventMode = bl;
    }

    protected final void notifyPathChange(TreePath[] treePathArray, boolean bl, TreePath treePath) {
        if (this._fireEvent) {
            int n = treePathArray.length;
            boolean[] blArray = new boolean[n];
            for (int i2 = 0; i2 < n; ++i2) {
                blArray[i2] = bl;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    private final boolean isBatchMode() {
        return this._batchMode;
    }

    public final void setBatchMode(boolean bl) {
        this._batchMode = bl;
        if (!this._batchMode) {
            TreePath[] treePathArray = this._toBeRemoved.toArray(new TreePath[this._toBeRemoved.size()]);
            this._toBeRemoved.clear();
            super.removeSelectionPaths(treePathArray);
            treePathArray = this._toBeAdded.toArray(new TreePath[this._toBeAdded.size()]);
            this._toBeAdded.clear();
            super.addSelectionPaths(treePathArray);
        }
    }

    private void delegateRemoveSelectionPaths(TreePath[] treePathArray) {
        if (!this.isBatchMode()) {
            super.removeSelectionPaths(treePathArray);
        } else {
            for (TreePath treePath : treePathArray) {
                this._toBeRemoved.add(treePath);
                this._toBeAdded.remove(treePath);
            }
        }
    }

    private void delegateAddSelectionPaths(TreePath[] treePathArray) {
        if (!this.isBatchMode()) {
            super.addSelectionPaths(treePathArray);
        } else {
            for (TreePath treePath : treePathArray) {
                this.addToExistingSet(this._toBeAdded, treePath);
                this._toBeRemoved.remove(treePath);
            }
        }
    }

    public final void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    public final void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public final void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    private boolean isTreePathValid(TreePath treePath) {
        Object object = this._model.getRoot();
        for (int i2 = 0; i2 < treePath.getPathCount(); ++i2) {
            Object object2 = treePath.getPathComponent(i2);
            if (i2 == 0) {
                if (object2 == object) continue;
                return false;
            }
            boolean bl = false;
            for (int i3 = 0; i3 < this.getChildrenCount(object); ++i3) {
                Object object3 = this.getChild(object, i3);
                if (object3 != object2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            object = object2;
        }
        return true;
    }

    public final void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    private void revalidateSelectedTreePaths() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (treePath == null || this.isTreePathValid(treePath)) continue;
                super.removeSelectionPath(treePath);
            }
        }
    }
}

