/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPane$1;
import com.jidesoft.swing.JideSplitPane$AccessibleJideSplitPane;
import com.jidesoft.swing.JideSplitPane$JideSplitPaneContour;
import com.jidesoft.swing.JideSplitPane$JideSplitPaneHeavyweightWrapper;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    private int _dividerStepSize = 0;
    private boolean _dragResizable = true;
    private boolean _hiddenByMyself = false;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int n) {
        this._orientation = n;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.setOpaque(false);
        this.installListeners();
    }

    public final int getDividerStepSize() {
        return this._dividerStepSize;
    }

    public final void setDividerStepSize(int n) {
        if (n < 0) {
            return;
        }
        this._dividerStepSize = n;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public final void setDividerSize(int n) {
        int n2 = this._dividerSize;
        if (n2 != n) {
            this._dividerSize = n;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n2, n);
            this.invalidate();
        }
    }

    public final int getDividerSize() {
        return this._dividerSize;
    }

    public final Component insertPane(Component component, int n) {
        return this.insertPane(component, null, n);
    }

    public final Component insertPane(Component component, Object object, int n) {
        if (n <= 0) {
            this.addImpl(component, object, 0);
        } else if (n >= this.getPaneCount()) {
            this.addImpl(component, object, -1);
        } else {
            this.addImpl(component, object, (n << 1) - 1);
        }
        return component;
    }

    public final Component addPane(Component component) {
        if (component == null) {
            return null;
        }
        return super.add(component);
    }

    public final void removePane(Component component) {
        this.removePane(this.indexOfPane(component));
    }

    public final void setPaneAt(Component component, int n) {
        this.setPaneAt(component, null, n);
    }

    public final void setPaneAt(Component component, Object object, int n) {
        double[] dArray = this._proportions;
        this._proportions = null;
        this.removePane(n);
        this.insertPane(component, object, n);
        this._proportions = dArray;
        this.validate();
    }

    public final void removePane(int n) {
        if (n == 0) {
            super.remove(0);
        } else {
            super.remove(n << 1);
        }
    }

    public final void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == n) {
            return;
        }
        int n2 = this._orientation;
        this._orientation = n;
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        Component[] componentArray = this.getComponents();
        LayoutManager layoutManager = this.getLayout();
        Map map = null;
        if (layoutManager instanceof JideSplitPaneLayout) {
            map = ((JideSplitPaneLayout)layoutManager).getConstraintMap();
        }
        if (componentArray != null && map != null) {
            for (Component component : componentArray) {
                jideSplitPaneLayout.addLayoutComponent(component, map.get(component));
            }
        }
        super.setLayout(jideSplitPaneLayout);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, n2, n);
    }

    public final int getOrientation() {
        return this._orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetToPreferredSizes() {
        if (this.getLayout() instanceof JideBoxLayout) {
            boolean bl = ((JideBoxLayout)this.getLayout()).isResetWhenInvalidate();
            try {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(true);
                ((JideBoxLayout)this.getLayout()).invalidateLayout(this);
            }
            finally {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(bl);
            }
        }
        this.doLayout();
    }

    public final void setProportionalLayout(boolean bl) {
        if (bl == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = bl;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !bl, bl);
        if (!bl) {
            this.setProportions(null);
        }
    }

    public final boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    final void internalSetProportions(double[] dArray) {
        this._proportions = dArray;
    }

    public final void setProportions(double[] dArray) {
        int n;
        if (!this._proportionalLayout && dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this._proportions)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d2 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] < 0.0) {
                    dArray[n] = 0.0;
                }
                if (dArray[n] > 1.0) {
                    dArray[n] = 1.0;
                }
                d2 += dArray[n];
            }
            if (d2 > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d2);
            }
        }
        double[] dArray2 = this._proportions;
        this._proportions = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n != 0);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, dArray2, dArray);
    }

    public final double[] getProportions() {
        double[] dArray = this._proportions;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public final void setInitiallyEven(boolean bl) {
        this._initiallyEven = bl;
    }

    public final boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    public final boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        if (!this.isContinuousLayout()) {
            Container container = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new JideSplitPane$1(this);
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this._windowDeactivatedListener);
            }
            if (container instanceof RootPaneContainer) {
                Serializable serializable;
                this._layeredPane = ((RootPaneContainer)((Object)container)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    serializable = new JideSplitPane$JideSplitPaneContour(this);
                    this._nonContinuousLayoutDividerWrapper = new JideSplitPane$JideSplitPaneHeavyweightWrapper(this, (Component)serializable);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                serializable = this.getVisibleRect();
                Rectangle rectangle = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this._layeredPane);
                int n = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, n, rectangle.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, rectangle.width, n);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            Component[] componentArray;
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
            for (Component component : componentArray = this._layeredPane.getComponents()) {
                if (!(component instanceof JideSplitPane$JideSplitPaneContour) && !(component instanceof JideSplitPane$JideSplitPaneHeavyweightWrapper)) continue;
                this._layeredPane.remove(component);
            }
        }
    }

    protected final void dragDividerTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(jideSplitPaneDivider, n);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point point;
            Dimension dimension = new Dimension();
            Rectangle rectangle = this.getVisibleRect();
            int n2 = Math.min(4, this.getDividerSize());
            Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, this._layeredPane);
            if (this.getOrientation() == 1) {
                point = SwingUtilities.convertPoint(this, n, rectangle.y, this._layeredPane);
                point.x += this.getDividerSize() - n2 >> 1;
                dimension.width = n2;
                dimension.height = rectangle2.height;
            } else {
                point = SwingUtilities.convertPoint(this, rectangle.x, n, this._layeredPane);
                point.y += this.getDividerSize() - n2 >> 1;
                dimension.width = rectangle2.width;
                dimension.height = n2;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetBounds(new Rectangle(point, dimension));
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(jideSplitPaneDivider, n);
        }
    }

    public final int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n = this.indexOf(jideSplitPaneDivider);
        if (n == -1) {
            return n;
        }
        if (n % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n + ")");
        }
        return (n - 1) / 2;
    }

    public final int indexOfPane(Component component) {
        int n = this.indexOf(component);
        if (n == -1) {
            return -1;
        }
        if (n % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + n + ")");
        }
        return n >> 1;
    }

    public final int indexOf(Component component) {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            if (!this.getComponent(i2).equals(component)) continue;
            return i2;
        }
        return -1;
    }

    public final JideSplitPaneDivider getDividerAt(int n) {
        if (n < 0 || n * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(n * 2 + 1);
    }

    public final Component getPaneAt(int n) {
        if (n < 0 || n << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n << 1);
    }

    public final int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public final void setDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        this.setDividerLocation(this.indexOfDivider(jideSplitPaneDivider), n);
    }

    public final void setDividerLocation(int n, int n2) {
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(n, n2, true);
        this.validate();
    }

    public final int getDividerLocation(int n) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
            if (this.isOneTouchExpandable()) {
                containerEvent.getChild().setMinimumSize(new Dimension(0, 0));
            }
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public final void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public final void componentResized(ComponentEvent componentEvent) {
    }

    public final void componentMoved(ComponentEvent componentEvent) {
    }

    public final void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public final void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected final boolean removeExtraDividers() {
        int n = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(0)).setJideSplitPane(null);
            this.remove(0);
            this.removeProportion(0);
            bl = true;
        }
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (component instanceof JideSplitPaneDivider) {
                if (++n != 2) continue;
                ((JideSplitPaneDivider)component).setJideSplitPane(null);
                this.remove(component);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i2 / 2);
                }
                bl = true;
                --n;
                --i2;
                continue;
            }
            n = 0;
        }
        if (n == 1 && this.getComponent(this.getComponentCount() - 1) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(this.getComponentCount() - 1)).setJideSplitPane(null);
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl = true;
        }
        return bl;
    }

    protected final void removeProportion(int n) {
        int n2;
        double d2;
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n < dArray.length) {
            d2 = dArray[n];
        } else {
            d2 = 1.0;
            double[] dArray3 = dArray;
            int n3 = dArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                double d3 = dArray3[n2];
                d2 -= d3;
            }
        }
        double d4 = 1.0 - d2;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n4 = n2 < n ? n2 : n2 + 1;
            dArray2[n2] = dArray[n4] / d4;
        }
        if (dArray2.length == 1) {
            // empty if block
        }
        this.setProportions(dArray2);
    }

    protected final void addExtraDividers() {
        int n = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JideSplitPaneDivider)) {
                if (++n != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i2);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i2 + 1) / 2);
                }
                n = 0;
                continue;
            }
            n = 0;
        }
    }

    protected final void addProportion(int n) {
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length + 1];
        double d2 = 1.0 / (double)(dArray2.length + 1);
        double d3 = 1.0 - d2;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            if (i2 == n) {
                dArray2[i2] = d2;
                continue;
            }
            int n2 = i2 < n ? i2 : i2 - 1;
            dArray2[i2] = n2 < dArray.length ? dArray[n2] * d3 : d2;
        }
        this.setProportions(dArray2);
    }

    public final void setVisible(boolean bl) {
        this._hiddenByMyself = false;
        super.setVisible(bl);
    }

    protected final void setDividersVisible() {
        boolean bl = false;
        if (this.getComponentCount() == 1) {
            bl = this.getComponent(0).isVisible();
        } else if (this.getComponentCount() > 1) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                boolean bl3;
                Component component = this.getComponent(i2);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl) continue;
                    bl = true;
                    continue;
                }
                boolean bl4 = i2 - 1 >= 0 && this.getComponent(i2 - 1).isVisible();
                boolean bl5 = bl3 = i2 + 1 < this.getComponentCount() && this.getComponent(i2 + 1).isVisible();
                if (bl4 && bl3) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl4 && !bl3) {
                    component.setVisible(false);
                    continue;
                }
                if (bl4 && !bl3) {
                    component.setVisible(false);
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    component.setVisible(true);
                    bl2 = false;
                    continue;
                }
                component.setVisible(false);
            }
        }
        if (!bl) {
            super.setVisible(false);
            this._hiddenByMyself = true;
        } else if (this._hiddenByMyself) {
            super.setVisible(true);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected final int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (bl2) {
            if ((n + 1) * 2 + 1 <= this.getComponentCount()) {
                int n3 = n + 1;
                while (n3 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n3).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n3).getBounds().x : this.getDividerAt((int)n3).getBounds().y;
                        break;
                    }
                    ++n3;
                }
            }
        } else if (n > 0) {
            for (int i2 = n - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n2 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n2 != -1) {
            return n2 + this.getDividerSize();
        }
        return 0;
    }

    public final int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (!bl2) {
            if ((n + 1) * 2 + 1 <= this.getComponentCount()) {
                int n3 = n + 1;
                while (n3 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n3).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n3).getBounds().x : this.getDividerAt((int)n3).getBounds().y;
                        break;
                    }
                    ++n3;
                }
            }
        } else if (n > 0) {
            for (int i2 = n - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n2 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n2 != -1) {
            return n2 - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public final boolean isShowGripper() {
        return this._showGripper;
    }

    public final void setShowGripper(boolean bl) {
        boolean bl2 = this._showGripper;
        if (bl2 != bl) {
            this._showGripper = bl;
            this.firePropertyChange(GRIPPER_PROPERTY, bl2, this._showGripper);
        }
    }

    public final void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public final boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public final void setContinuousLayout(boolean bl) {
        boolean bl2 = this._continuousLayout;
        this._continuousLayout = bl;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, bl);
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JideSplitPane$AccessibleJideSplitPane(this);
        }
        return this.accessibleContext;
    }

    public final boolean isDragResizable() {
        return this._dragResizable;
    }

    public final void setDragResizable(boolean bl) {
        this._dragResizable = bl;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != bl) {
            this._heavyweightComponentEnabled = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this._heavyweightComponentEnabled);
        }
    }

    public final void setOneTouchExpandable(boolean bl) {
        boolean bl2 = this._oneTouchExpandable;
        if (bl2 != bl) {
            this._oneTouchExpandable = bl;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (bl) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public final boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public final void setLeftOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._leftOneTouchButtonImageIcon = imageIcon;
    }

    public final ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public final void setRightOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._rightOneTouchButtonImageIcon = imageIcon;
    }

    public final ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public final void setDividerLocations(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n = nArray[i2];
            this.setDividerLocation(i2, n);
        }
    }

    public final int[] getDividerLocations() {
        int n = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] nArray = new int[n - 1];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            nArray[i2] = this.getDividerLocation(i2);
        }
        return nArray;
    }

    static final /* synthetic */ void access$000(JideSplitPane jideSplitPane) {
        jideSplitPane.stopDragging();
    }
}

