/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.FastGradientPainter;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities$1;
import com.jidesoft.swing.JideSwingUtilities$10;
import com.jidesoft.swing.JideSwingUtilities$11;
import com.jidesoft.swing.JideSwingUtilities$12;
import com.jidesoft.swing.JideSwingUtilities$13;
import com.jidesoft.swing.JideSwingUtilities$14;
import com.jidesoft.swing.JideSwingUtilities$15;
import com.jidesoft.swing.JideSwingUtilities$16;
import com.jidesoft.swing.JideSwingUtilities$17;
import com.jidesoft.swing.JideSwingUtilities$18;
import com.jidesoft.swing.JideSwingUtilities$19;
import com.jidesoft.swing.JideSwingUtilities$2;
import com.jidesoft.swing.JideSwingUtilities$20;
import com.jidesoft.swing.JideSwingUtilities$3;
import com.jidesoft.swing.JideSwingUtilities$4;
import com.jidesoft.swing.JideSwingUtilities$5;
import com.jidesoft.swing.JideSwingUtilities$6;
import com.jidesoft.swing.JideSwingUtilities$7;
import com.jidesoft.swing.JideSwingUtilities$8;
import com.jidesoft.swing.JideSwingUtilities$9;
import com.jidesoft.swing.JideSwingUtilities$ConditionHandler;
import com.jidesoft.swing.JideSwingUtilities$GetHandler;
import com.jidesoft.swing.JideSwingUtilities$GetPropertyAction;
import com.jidesoft.swing.JideSwingUtilities$Handler;
import com.jidesoft.swing.JideSwingUtilities$viewportSynchronizationChangeListener;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.View;

public class JideSwingUtilities
implements SwingConstants {
    private static final Logger LOGGER_FOCUS = Logger.getLogger(JideSwingUtilities.class.getName() + ".focus");
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static PropertyChangeListener _setOpaqueTrueListener;
    private static PropertyChangeListener _setOpaqueFalseListener;
    private static final String OPAQUE_LISTENER = "setOpaqueRecursively.opaqueListener";
    public static final String SET_OPAQUE_RECURSIVELY_EXCLUDED = "setOpaqueRecursively.excluded";
    static Map renderingHints;
    private static Class _radialGradientPaintClass;
    private static Constructor _radialGradientPaintConstructor1;
    private static Constructor _radialGradientPaintConstructor2;
    private static Class _linearGradientPaintClass;
    private static Constructor _linearGradientPaintConstructor1;
    private static Constructor _linearGradientPaintConstructor2;
    protected static boolean tracingFocus;
    private static ChangeListener _viewportSyncListener;

    public static final JPanel createLeftPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "Before");
        return nullPanel;
    }

    public static final JPanel createRightPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "After");
        return nullPanel;
    }

    public static final JPanel createTopPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "First");
        return nullPanel;
    }

    public static final JPanel createBottomPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "Last");
        return nullPanel;
    }

    public static final JPanel createCenterPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new GridBagLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, new GridBagConstraints());
        return nullPanel;
    }

    public static final JPanel createLabeledComponent(JLabel jLabel, Component component, Object object) {
        NullPanel nullPanel = new NullPanel(new JideBorderLayout(3, 3));
        nullPanel.setOpaque(false);
        nullPanel.add((Component)jLabel, object);
        jLabel.setLabelFor(component);
        nullPanel.add(component);
        return nullPanel;
    }

    public static final void centerWindow(Window window) {
        window.setLocationRelativeTo(window.getParent());
    }

    public static final void globalCenterWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static final void paintArrow(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        n3 = n3 / 2 * 2 + 1;
        if (n4 == 0) {
            for (int i2 = 0; i2 < (n3 + 1) / 2; ++i2) {
                graphics.drawLine(n + i2, n2 + i2, n + n3 - i2 - 1, n2 + i2);
            }
        } else if (n4 == 1) {
            for (int i3 = 0; i3 < (n3 + 1) / 2; ++i3) {
                graphics.drawLine(n + i3, n2 + i3, n + i3, n2 + n3 - i3 - 1);
            }
        }
        graphics.setColor(color2);
    }

    public static final void paintArrow(JComponent jComponent, Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        if (!jComponent.getComponentOrientation().isLeftToRight()) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            n3 = n3 / 2 * 2 + 1;
            for (int i2 = 0; i2 < (n3 + 1) / 2; ++i2) {
                graphics.drawLine(n + n3 - i2, n2 + i2, n + n3 - i2, n2 + n3 - i2 - 1);
            }
            graphics.setColor(color2);
            return;
        }
        JideSwingUtilities.paintArrow(graphics, color, n, n2, n3, n4);
    }

    public static final void paintCross(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        n3 /= 2;
        for (int i2 = 0; i2 < n4; ++i2) {
            graphics.drawLine(n - n3, n2 - n3, n + n3, n2 + n3);
            graphics.drawLine(n + n3, n2 - n3, n - n3, n2 + n3);
            ++n;
        }
    }

    public static final Frame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    public static final void toggleRTLnLTR(Component component) {
        ComponentOrientation componentOrientation = component.getComponentOrientation();
        componentOrientation = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        component.applyComponentOrientation(componentOrientation);
    }

    public static final void synchronizeView(JViewport jViewport, JViewport jViewport2, int n) {
        HashMap hashMap;
        int n2;
        if (jViewport == null || jViewport2 == null) {
            return;
        }
        ChangeListener[] changeListenerArray = jViewport.getChangeListeners();
        for (n2 = 0; n2 < changeListenerArray.length && changeListenerArray[n2] != JideSwingUtilities.getViewportSynchronizationChangeListener(); ++n2) {
        }
        if (n2 >= changeListenerArray.length) {
            jViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
        }
        if (!((hashMap = jViewport.getClientProperty("synchronizeViewSlaveViewport")) instanceof Map)) {
            hashMap = new HashMap();
        }
        Map map = hashMap;
        map.put(jViewport2, n);
        jViewport.putClientProperty("synchronizeViewSlaveViewport", map);
        hashMap = jViewport2.getClientProperty("synchronizeViewMasterViewport");
        if (!(hashMap instanceof Map)) {
            hashMap = new HashMap();
        }
        Map map2 = hashMap;
        map2.put(jViewport, n);
        jViewport2.putClientProperty("synchronizeViewMasterViewport", map2);
    }

    public static final void unsynchronizeView(JViewport jViewport, JViewport jViewport2) {
        Map map;
        if (jViewport == null || jViewport2 == null) {
            return;
        }
        Object object = jViewport.getClientProperty("synchronizeViewSlaveViewport");
        if (object instanceof Map) {
            map = (Map)object;
            map.remove(jViewport2);
            if (map.isEmpty()) {
                map = null;
                jViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
            jViewport.putClientProperty("synchronizeViewSlaveViewport", map);
        }
        if ((object = jViewport2.getClientProperty("synchronizeViewMasterViewport")) instanceof Map) {
            map = (Map)object;
            map.remove(jViewport);
            if (map.isEmpty()) {
                map = null;
            }
            jViewport2.putClientProperty("synchronizeViewMasterViewport", map);
        }
    }

    public static final int getButtonState(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            if (buttonModel.isRollover()) {
                return 1;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
        } else {
            if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    public static final int[] getButtonState(JideSplitButton jideSplitButton) {
        int[] nArray = new int[2];
        SplitButtonModel splitButtonModel = (SplitButtonModel)jideSplitButton.getModel();
        if (!splitButtonModel.isEnabled()) {
            nArray[0] = splitButtonModel.isButtonSelected() ? 5 : 4;
        } else if (jideSplitButton.hasFocus() && jideSplitButton.isFocusPainted()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 3;
                nArray[1] = 7;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 7;
                nArray[1] = 3;
            } else {
                nArray[0] = 2;
                nArray[1] = 7;
            }
        } else if (splitButtonModel.isPressed() && splitButtonModel.isArmed()) {
            if (splitButtonModel.isButtonRollover()) {
                nArray[0] = 1;
                nArray[1] = 7;
            } else if (splitButtonModel.isRollover()) {
                nArray[0] = 7;
                nArray[1] = 2;
            }
        } else if (jideSplitButton.isRolloverEnabled() && splitButtonModel.isButtonRollover()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 1;
                nArray[1] = 7;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 2;
                nArray[1] = 1;
            } else {
                nArray[0] = 2;
                nArray[1] = 7;
            }
        } else if (jideSplitButton.isRolloverEnabled() && splitButtonModel.isRollover()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 1;
                nArray[1] = 2;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 7;
                nArray[1] = 1;
            } else {
                nArray[0] = 7;
                nArray[1] = 2;
            }
        } else if (splitButtonModel.isButtonSelected()) {
            nArray[0] = 3;
            nArray[1] = 7;
        } else if (splitButtonModel.isSelected()) {
            nArray[0] = 7;
            nArray[1] = 3;
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
        return nArray;
    }

    public static final boolean equals(Object object, Object object2) {
        return JideSwingUtilities.equals(object, object2, false);
    }

    public static final boolean equals(Object object, Object object2, boolean bl) {
        if (object == object2) {
            return true;
        }
        if (object != null && object2 == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return JideSwingUtilities.equals((CharSequence)object, (CharSequence)object2, true);
        }
        if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
            return ((Comparable)object).compareTo(object2) == 0;
        }
        if (object instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
            return ((Comparable)object2).compareTo(object) == 0;
        }
        if (bl && object instanceof List && object2 instanceof List) {
            int n;
            int n2 = ((List)object).size();
            if (n2 != (n = ((List)object2).size())) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (JideSwingUtilities.equals(((List)object).get(i2), ((List)object2).get(i2), true)) continue;
                return false;
            }
            return true;
        }
        if (bl && object.getClass().isArray() && object2.getClass().isArray()) {
            int n;
            int n3 = Array.getLength(object);
            if (n3 != (n = Array.getLength(object2))) {
                return false;
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                if (JideSwingUtilities.equals(Array.get(object, i3), Array.get(object2, i3), true)) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static final boolean equals(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = charSequence.length();
        while (n3-- > 0) {
            char c2;
            char c3;
            if ((c3 = charSequence.charAt(n++)) == (c2 = charSequence2.charAt(n2++)) || !bl && JideSwingUtilities.charsEqualIgnoreCase(c3, c2)) continue;
            return false;
        }
        return true;
    }

    public static final boolean charsEqualIgnoreCase(char c2, char c3) {
        return c2 == c3 || JideSwingUtilities.toUpperCase(c2) == JideSwingUtilities.toUpperCase(c3) || JideSwingUtilities.toLowerCase(c2) == JideSwingUtilities.toLowerCase(c3);
    }

    public static final char toUpperCase(char c2) {
        if (c2 < 'a') {
            return c2;
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return (char)(c2 + -32);
        }
        return Character.toUpperCase(c2);
    }

    public static final char toLowerCase(char c2) {
        if (c2 < 'A' || c2 >= 'a' && c2 <= 'z') {
            return c2;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        return Character.toLowerCase(c2);
    }

    public static final BufferedImage getFasterScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        boolean bl2;
        int n5 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics2D graphics2D = null;
        int n6 = bufferedImage2.getWidth();
        int n7 = bufferedImage2.getHeight();
        boolean bl3 = bl2 = bufferedImage.getTransparency() != 1;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            if (bufferedImage3 == null || bl2) {
                bufferedImage3 = new BufferedImage(n4, n3, n5);
                graphics2D = bufferedImage3.createGraphics();
            }
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, 0, 0, n6, n7, null);
            }
            n6 = n4;
            n7 = n3;
            bufferedImage2 = bufferedImage3;
        } while (n4 != n || n3 != n2);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
        if (n != bufferedImage2.getWidth() || n2 != bufferedImage2.getHeight()) {
            bufferedImage3 = new BufferedImage(n, n2, n5);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static final boolean shouldUseSystemFont() {
        boolean bl;
        String string = SecurityUtils.getProperty("jide.useSystemfont", "");
        if ("false".equals(string)) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        String string2 = null;
        try {
            string2 = (String)AccessController.doPrivileged(new JideSwingUtilities$GetPropertyAction("swing.useSystemFontSettings"));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        boolean bl2 = bl = string2 != null && Boolean.valueOf(string2) != false;
        if (bl) {
            Object object = UIDefaultsLookup.get("Application.useSystemFontSettings");
            bl = object != null || Boolean.TRUE.equals(object);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || bl;
    }

    public static final void printUIDefaults() {
        Enumeration enumeration = UIManager.getDefaults().keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("Non-string keys ---");
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof String) {
                arrayList.add((String)object);
                continue;
            }
            System.out.println(object + " => " + UIDefaultsLookup.get(object));
        }
        System.out.println();
        Collections.sort(arrayList);
        System.out.println("String keys ---");
        for (String string : arrayList) {
            System.out.println(string + " => " + UIDefaultsLookup.get(string));
        }
    }

    public static final void setRecursively(Component component, JideSwingUtilities$Handler jideSwingUtilities$Handler) {
        JideSwingUtilities.setRecursively0(component, jideSwingUtilities$Handler);
        jideSwingUtilities$Handler.postAction(component);
    }

    private static void setRecursively0(Component component, JideSwingUtilities$Handler jideSwingUtilities$Handler) {
        if (jideSwingUtilities$Handler.condition(component)) {
            jideSwingUtilities$Handler.action(component);
        }
        if (jideSwingUtilities$Handler instanceof JideSwingUtilities$ConditionHandler && ((JideSwingUtilities$ConditionHandler)jideSwingUtilities$Handler).stopCondition(component)) {
            return;
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof JTabbedPane) {
            Component[] componentArray2 = (Component[])component;
            componentArray = new Component[componentArray2.getTabCount()];
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2] = componentArray2.getComponentAt(i2);
            }
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                JideSwingUtilities.setRecursively0(component2, jideSwingUtilities$Handler);
            }
        }
    }

    public static final Component findFirstComponentByName(Container container, String string) {
        if (string != null && string.trim().length() != 0) {
            return JideSwingUtilities.getRecursively(container, new JideSwingUtilities$1(string));
        }
        return null;
    }

    public static final Component findFirstComponentByClass(Container container, Class clazz) {
        if (clazz != null) {
            return JideSwingUtilities.getRecursively(container, new JideSwingUtilities$2(clazz));
        }
        return null;
    }

    public static final Component getRecursively(Component component, JideSwingUtilities$GetHandler jideSwingUtilities$GetHandler) {
        return JideSwingUtilities.getRecursively0(component, jideSwingUtilities$GetHandler);
    }

    private static Component getRecursively0(Component component, JideSwingUtilities$GetHandler jideSwingUtilities$GetHandler) {
        if (jideSwingUtilities$GetHandler.condition(component)) {
            return jideSwingUtilities$GetHandler.action(component);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                Component component3 = JideSwingUtilities.getRecursively0(component2, jideSwingUtilities$GetHandler);
                if (component3 == null) continue;
                return component3;
            }
        }
        return null;
    }

    public static final void setEnabledRecursively(Component component, boolean bl) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$3(bl));
    }

    public static final void putClientPropertyRecursively(Component component, String string, Object object) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$4(string, object));
    }

    public static final void setRequestFocusEnabledRecursively(Component component, boolean bl) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$5(bl));
    }

    public static final void setOpaqueRecursively(Component component, boolean bl) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$6(bl));
    }

    public static final Dimension getPreferredButtonSize(AbstractButton abstractButton, int n, boolean bl) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, bl, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public static final String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl2 = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl2 = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl2 ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl2 ? 4 : 2;
            }
        }
        return JideSwingUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, bl, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    public static final String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return JideSwingUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, bl, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (bl) {
            return JideSwingUtilities.layoutCompoundLabelImplHorizontal(jComponent, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        }
        return JideSwingUtilities.layoutCompoundLabelImplVertical(jComponent, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String getMaxLengthWord(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        int n = string.length();
        int n2 = -1;
        int n3 = string.length() / 2;
        int n4 = -1;
        while ((n4 = string.indexOf(32, n4 + 1)) != -1) {
            int n5 = Math.abs(n4 - n3);
            if (n5 >= n) continue;
            n = n5;
            n2 = n4;
        }
        return n2 >= n3 ? string.substring(0, n2) : string.substring(n2 + 1);
    }

    private static String layoutCompoundLabelImplHorizontal(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n10 = n9 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.width > (n8 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n9))) {
            if (view != null) {
                rectangle3.width = n8;
            } else {
                String string2 = "...";
                n7 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n6 = 0; n6 < string.length() && (n7 += fontMetrics.charWidth(string.charAt(n6))) <= n8; ++n6) {
                }
                string = string.substring(0, n6) + string2;
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n9)) : (n3 == 0 ? (rectangle2.height >> 1) - (rectangle3.height >> 1) : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n9));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n9) : (n4 == 0 ? (rectangle2.width >> 1) - (rectangle3.width >> 1) : rectangle2.width + n9);
        n8 = Math.min(rectangle2.x, rectangle3.x);
        int n11 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n8;
        n7 = Math.min(rectangle2.y, rectangle3.y);
        n6 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n7;
        int n12 = n == 1 ? rectangle.y - n7 : (n == 0 ? rectangle.y + (rectangle.height >> 1) - (n7 + (n6 >> 1)) : rectangle.y + rectangle.height - (n7 + n6));
        int n13 = n2 == 2 ? rectangle.x - n8 : (n2 == 4 ? rectangle.x + rectangle.width - (n8 + n11) : rectangle.x + (rectangle.width >> 1) - (n8 + (n11 >> 1)));
        rectangle3.x += n13;
        rectangle3.y += n12;
        rectangle2.x += n13;
        rectangle2.y += n12;
        return string;
    }

    private static String layoutCompoundLabelImplVertical(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.height = (int)view.getPreferredSpan(0);
                rectangle3.width = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.width = fontMetrics.getHeight();
            }
        }
        int n12 = n11 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.height > (n10 = n4 == 0 ? rectangle.height : rectangle.height - (rectangle2.height + n11))) {
            if (view != null) {
                rectangle3.height = n10;
            } else {
                String string2 = "...";
                n9 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n8 = 0; n8 < string.length() && (n9 += fontMetrics.charWidth(string.charAt(n8))) <= n10; ++n8) {
                }
                string = string.substring(0, n8) + string2;
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        if (n3 == 1) {
            rectangle3.x = n4 != 0 ? 0 : -(rectangle3.width + n11);
        } else if (n3 == 0) {
            rectangle3.y = (rectangle2.width >> 1) - (rectangle3.width >> 1);
        } else {
            rectangle3.x = n4 != 0 ? rectangle2.width - rectangle3.width : rectangle2.width + n11;
        }
        rectangle3.y = n4 == 2 ? -(rectangle3.height + n11) : (n4 == 0 ? (rectangle2.height >> 1) - (rectangle3.height >> 1) : rectangle2.height + n11);
        n10 = Math.min(rectangle2.y, rectangle3.y);
        int n13 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n10;
        n9 = Math.min(rectangle2.x, rectangle3.x);
        n8 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n9;
        if (n == 1) {
            n7 = rectangle.x - n9;
            n6 = rectangle.x + rectangle.width - (n9 + n8);
        } else if (n == 0) {
            n6 = n7 = rectangle.x + (rectangle.width >> 1) - (n9 + (n8 >> 1));
        } else {
            n7 = rectangle.x + rectangle.width - (n9 + n8);
            n6 = rectangle.x - n9;
        }
        int n14 = n2 == 2 ? rectangle.y - n10 : (n2 == 4 ? rectangle.y + rectangle.height - (n10 + n13) : rectangle.y + (rectangle.height >> 1) - (n10 + (n13 >> 1)));
        rectangle3.y += n14;
        rectangle3.x += n7;
        rectangle2.y += n14;
        rectangle2.x += n6;
        return string;
    }

    public static final int getOrientationOf(Component component) {
        Integer n;
        if (component instanceof Alignable) {
            return ((Alignable)((Object)component)).getOrientation();
        }
        if (component instanceof JComponent && (n = (Integer)((JComponent)component).getClientProperty("orientation")) != null) {
            return n;
        }
        return 0;
    }

    public static final void setOrientationOf(Component component, int n) {
        int n2 = JideSwingUtilities.getOrientationOf(component);
        if (n != n2) {
            if (component instanceof Alignable) {
                ((Alignable)((Object)component)).setOrientation(n);
            } else if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("orientation", n);
            }
        }
    }

    public static final void setChildrenOrientationOf(Container container, int n) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            JideSwingUtilities.setOrientationOf(component, n);
        }
    }

    public static final Map disableDoubleBuffered(Component component) {
        HashMap hashMap = new HashMap();
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities$7(hashMap));
        }
        return hashMap;
    }

    public static final Map enableDoubleBuffered(Component component) {
        HashMap hashMap = new HashMap();
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities$8(hashMap));
        }
        return hashMap;
    }

    public static final void restoreDoubleBuffered(Component component, Map map) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$9(map));
    }

    public static final void paintBackground(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color3);
    }

    public static final void paintBackground(Graphics2D graphics2D, Rectangle rectangle, Color color, Paint paint) {
        Color color2 = graphics2D.getColor();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics2D.setColor(color);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2D.setColor(color2);
    }

    private static boolean drawTextAntialiased(Component component) {
        if (!AA_TEXT_DEFINED) {
            if (component != null) {
                if (component instanceof JComponent) {
                    Boolean bl = (Boolean)((JComponent)component).getClientProperty(AA_TEXT_PROPERTY_KEY);
                    return bl != null ? bl : false;
                }
                return false;
            }
            return false;
        }
        return AA_TEXT;
    }

    public static final boolean drawTextAntialiased(boolean bl) {
        if (!AA_TEXT_DEFINED) {
            return bl;
        }
        return AA_TEXT;
    }

    public static final void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        JideSwingUtilities.drawString(jComponent, graphics, string, n2, n3);
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = n3;
            int n6 = fontMetrics.charWidth(string.charAt(n));
            int n7 = 1;
            graphics.fillRect(n4, n5 + fontMetrics.getDescent() - 1, n6, n7);
        }
    }

    private static Map getRenderingHints(Graphics2D graphics2D, Map map, Map map2) {
        if (map2 == null) {
            map2 = new RenderingHints(null);
        } else {
            map2.clear();
        }
        if (map == null || map.size() == 0) {
            return map2;
        }
        Set set = map.keySet();
        for (Object k2 : set) {
            RenderingHints.Key key = (RenderingHints.Key)k2;
            Object object = graphics2D.getRenderingHint(key);
            map2.put(key, object);
        }
        return map2;
    }

    public static final void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        if (SystemInfo.isJdk6Above()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Map map = null;
            if (renderingHints != null) {
                map = JideSwingUtilities.getRenderingHints(graphics2D, renderingHints, null);
                graphics2D.addRenderingHints(renderingHints);
            }
            graphics2D.drawString(string, n, n2);
            if (map != null) {
                graphics2D.addRenderingHints(map);
            }
        } else if (JideSwingUtilities.drawTextAntialiased(jComponent) && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public static final Object setupAntialiasing(Component component, Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemInfo.isJdk6Above()) {
            object = JideSwingUtilities.getRenderingHints(graphics2D, renderingHints, null);
            if (renderingHints != null) {
                graphics2D.addRenderingHints(renderingHints);
            }
        } else {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JideSwingUtilities.drawTextAntialiased(component)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return object;
    }

    public static final void restoreAntialiasing(Component component, Graphics graphics, Object object) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemInfo.isJdk6Above()) {
            if (object != null) {
                graphics2D.addRenderingHints((RenderingHints)object);
            }
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static final Object setupShapeAntialiasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static final void restoreShapeAntialiasing(Graphics graphics, Object object) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static final void drawGrip(Graphics graphics, Rectangle rectangle, int n, int n2) {
        JideSwingUtilities.drawGrip(graphics, rectangle, n, n2, true);
    }

    public static final void drawGrip(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        if (rectangle.width > rectangle.height) {
            int n3 = n;
            if (n * 3 > rectangle.width) {
                n3 = rectangle.width / 3;
            }
            int n4 = rectangle.x + (rectangle.width - n3 * 3 >> 1);
            int n5 = rectangle.y + (rectangle.height - n2 * 3 >> 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (bl) {
                        graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        graphics.drawLine(n4 + i3 * 3, n5 + i2 * 3, n4 + i3 * 3, n5 + i2 * 3);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    graphics.drawLine(n4 + i3 * 3 + 1, n5 + i2 * 3 + 1, n4 + i3 * 3 + 1, n5 + i2 * 3 + 1);
                }
            }
        } else {
            int n6 = n;
            if (n * 3 > rectangle.height) {
                n6 = rectangle.height / 3;
            }
            int n7 = rectangle.x + (rectangle.width - n2 * 3 >> 1);
            int n8 = rectangle.y + (rectangle.height - n6 * 3 >> 1);
            for (int i4 = 0; i4 < n2; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    if (bl) {
                        graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        graphics.drawLine(n7 + i4 * 3, n8 + i5 * 3, n7 + i4 * 3, n8 + i5 * 3);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    graphics.drawLine(n7 + i4 * 3 + 1, n8 + i5 * 3 + 1, n7 + i4 * 3 + 1, n8 + i5 * 3 + 1);
                }
            }
        }
    }

    public static final void registerTabKey(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).registerKeyboardAction(new JideSwingUtilities$11(), KeyStroke.getKeyStroke(9, 0), 0);
        } else {
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                Component component = container.getComponent(i2);
                if (!(component instanceof JComponent) || !component.isFocusable()) continue;
                ((JComponent)container).registerKeyboardAction(new JideSwingUtilities$12(), KeyStroke.getKeyStroke(9, 0), 0);
            }
        }
    }

    public static final void fillGradient(Graphics graphics, Rectangle rectangle, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, 48);
        Color color3 = new Color(0, 0, 0, 0);
        Color color4 = new Color(0, 0, 0, 32);
        if (n == 0) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height >> 1), color2, color, true);
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y + (rectangle.height >> 1), rectangle.width, rectangle.height >> 1), color3, color4, true);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width >> 1, rectangle.height), color2, color, false);
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + (rectangle.width >> 1), rectangle.y, rectangle.width >> 1, rectangle.height), color3, color4, false);
        }
    }

    public static final void fillSingleGradient(Graphics graphics, Rectangle rectangle, int n) {
        JideSwingUtilities.fillSingleGradient(graphics, rectangle, n, 127);
    }

    public static final void fillSingleGradient(Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, n2);
        if (n == 5) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, true);
        } else if (n == 1) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, true);
        } else if (n == 3) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, false);
        } else if (n == 7) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, false);
        }
    }

    public static final Paint getRadialGradientPaint(Point2D point2D, float f2, float[] fArray, Color[] colorArray) {
        Class<?> clazz = null;
        try {
            clazz = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                if (_radialGradientPaintConstructor2 == null) {
                    _radialGradientPaintConstructor2 = clazz.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
                }
                Object t = _radialGradientPaintConstructor2.newInstance(point2D, Float.valueOf(f2), fArray, colorArray);
                return (Paint)t;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static final Paint getRadialGradientPaint(float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        if (_radialGradientPaintClass == null) {
            try {
                _radialGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (_radialGradientPaintClass != null) {
            try {
                if (_radialGradientPaintConstructor1 == null) {
                    _radialGradientPaintConstructor1 = _radialGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object t = _radialGradientPaintConstructor1.newInstance(Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), fArray, colorArray);
                return (Paint)t;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static final Paint getLinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray) {
        if (_linearGradientPaintClass == null) {
            try {
                _linearGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.LinearGradientPaint") : Class.forName("org.apache.batik.ext.awt.LinearGradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (_linearGradientPaintClass != null) {
            try {
                if (_linearGradientPaintConstructor1 == null) {
                    _linearGradientPaintConstructor1 = _linearGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object t = _linearGradientPaintConstructor1.newInstance(Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), fArray, colorArray);
                return (Paint)t;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - linear gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static final boolean containerContainsFocus(Container container) {
        boolean bl;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = bl = component != null && SwingUtilities.isDescendingFrom(component, container);
        if (!bl) {
            bl = component2 != null && SwingUtilities.isDescendingFrom(component2, container);
        }
        return bl;
    }

    public static final boolean componentIsPermanentFocusOwner(Component component) {
        return component != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == component;
    }

    public static final void installColorsAndFont(Component component, Color color, Color color2, Font font) {
        JideSwingUtilities.installFont(component, font);
        JideSwingUtilities.installColors(component, color, color2);
    }

    public static final void installFont(Component component, Font font) {
        Font font2 = component.getFont();
        if (font2 == null || font2 instanceof UIResource) {
            component.setFont(font);
        }
    }

    public static final void installColors(Component component, Color color, Color color2) {
        Color color3 = component.getBackground();
        if (color != null && (color3 == null || color3 instanceof UIResource)) {
            component.setBackground(color);
        }
        Color color4 = component.getForeground();
        if (color2 != null && (color4 == null || color4 instanceof UIResource)) {
            component.setForeground(color2);
        }
    }

    public static final void installBorder(JComponent jComponent, Border border) {
        Border border2 = jComponent.getBorder();
        if (border2 == null || border2 instanceof UIResource) {
            jComponent.setBorder(border);
        }
    }

    public static final void fillNormalGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        Rectangle rectangle = shape.getBounds();
        GradientPaint gradientPaint = bl ? new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.height + rectangle.y, color2, true) : new GradientPaint(rectangle.x, rectangle.y, color, rectangle.width + rectangle.x, rectangle.y, color2, true);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public static final void fillGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(graphics2D, shape, color, color2, bl);
        } else {
            FastGradientPainter.drawGradient(graphics2D, shape, color, color2, bl);
        }
    }

    public static final void clearGradientCache() {
        FastGradientPainter.clearGradientCache();
    }

    public static final Window getTopModalDialog(Window window) {
        Window[] windowArray;
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            if (!window2.isVisible() || !(window2 instanceof Dialog) || !((Dialog)window2).isModal()) continue;
            return JideSwingUtilities.getTopModalDialog(window2);
        }
        return window;
    }

    public static final void traceFocus() {
        JideSwingUtilities.traceFocus(false);
    }

    public static final void traceFocus(boolean bl) {
        if (tracingFocus) {
            return;
        }
        JideSwingUtilities$13 jideSwingUtilities$13 = new JideSwingUtilities$13(bl);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", jideSwingUtilities$13);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", jideSwingUtilities$13);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", jideSwingUtilities$13);
        tracingFocus = true;
    }

    public static final void runGCAndPrintFreeMemory() {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,##0.####");
        String string = decimalFormat.format(Runtime.getRuntime().freeMemory() / 1024L);
        String string2 = decimalFormat.format(Runtime.getRuntime().totalMemory() / 1024L);
        String string3 = decimalFormat.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("before gc: (Total [" + string2 + "k] - Free [" + string + "k]) = Used [" + string3 + "k]");
        System.runFinalization();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        string = decimalFormat.format(Runtime.getRuntime().freeMemory() / 1024L);
        string2 = decimalFormat.format(Runtime.getRuntime().totalMemory() / 1024L);
        string3 = decimalFormat.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("after gc: (Total [" + string2 + "k] - Free [" + string + "k]) = Used [" + string3 + "k]");
    }

    public static final JPanel createTableModelModifier(DefaultTableModel defaultTableModel) {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        JTable jTable = new JTable(defaultTableModel);
        jPanel.add(new JScrollPane(jTable));
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton("Insert");
        jButton.addActionListener(new JideSwingUtilities$14(defaultTableModel, jTable));
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(new JideSwingUtilities$15(jTable, defaultTableModel));
        JButton jButton3 = new JButton("Clear");
        jButton3.addActionListener(new JideSwingUtilities$16(defaultTableModel));
        buttonPanel.add(jButton);
        buttonPanel.add(jButton2);
        buttonPanel.add(jButton3);
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    public static final Component findSomethingFocusable(Container container) {
        Component[] componentArray;
        if (JideSwingUtilities.passesFocusabilityTest(container)) {
            container.requestFocusInWindow();
            return container;
        }
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (JideSwingUtilities.passesFocusabilityTest(component)) {
                container.requestFocusInWindow();
                return container;
            }
            if (!(component instanceof Container) || (component2 = JideSwingUtilities.findSomethingFocusable((Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public static final boolean passesFocusabilityTest(Component component) {
        return component != null && component.isEnabled() && component.isDisplayable() && component.isVisible() && component.isFocusable() && component.isShowing();
    }

    public static final void ignoreException(Exception exception) {
    }

    public static final void printException(Exception exception) {
        System.err.println(exception.getLocalizedMessage());
    }

    public static final void throwException(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static final void throwInvocationTargetException(InvocationTargetException invocationTargetException) {
        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        if (invocationTargetException.getTargetException() instanceof Error) {
            throw (Error)invocationTargetException.getTargetException();
        }
        throw new RuntimeException(invocationTargetException.getTargetException());
    }

    public static final int findDisplayedMnemonicIndex(String string, int n) {
        if (string == null || n == 0) {
            return -1;
        }
        char c2 = Character.toUpperCase((char)n);
        char c3 = Character.toLowerCase((char)n);
        int n2 = string.indexOf(c2);
        int n3 = string.indexOf(c3);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return n3 < n2 ? n3 : n2;
    }

    public static final Component getDescendantOfClass(Class clazz, Container container) {
        Component[] componentArray;
        if (container == null || clazz == null) {
            return null;
        }
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (clazz.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (component2 = JideSwingUtilities.getDescendantOfClass(clazz, (Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public static final float getDefaultFontSize() {
        String string = SecurityUtils.getProperty("jide.fontSize", null);
        float f2 = -1.0f;
        try {
            if (string != null) {
                f2 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f2;
    }

    public static final Object getMenuFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Font font;
        Object object = null;
        float f2 = JideSwingUtilities.getDefaultFontSize();
        object = JideSwingUtilities.shouldUseSystemFont() ? (f2 == -1.0f ? uIDefaults.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", uIDefaults.getFont("ToolBar.font"), toolkit, f2)) : ((font = uIDefaults.getFont("ToolBar.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f2 != -1.0f ? (int)f2 : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 0, f2 != -1.0f ? (int)f2 : font.getSize()));
        if (object == null) {
            return JideSwingUtilities.getControlFont(toolkit, uIDefaults);
        }
        return object;
    }

    public static final Object getControlFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Object object;
        float f2 = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = uIDefaults.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            object = f2 == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2);
        } else {
            Font font = uIDefaults.getFont("Label.font");
            object = font == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f2 != -1.0f ? (int)f2 : 11) : (f2 == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2));
        }
        return object;
    }

    public static final Object getBoldFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Object object;
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont(toolkit, uIDefaults);
        }
        float f2 = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = uIDefaults.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            object = f2 == -1.0f ? new FontUIResource(font.deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2, 1);
        } else {
            Font font = uIDefaults.getFont("Label.font");
            object = font == null ? SecurityUtils.createFontUIResource("Tahoma", 1, f2 != -1.0f ? (int)f2 : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 1, f2 != -1.0f ? (int)f2 : font.getSize());
        }
        return object;
    }

    public static final void drawShadow(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        ShadowFactory shadowFactory = new ShadowFactory(6, 0.7f, Color.GRAY);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        BufferedImage bufferedImage2 = shadowFactory.createShadow(bufferedImage);
        graphics.drawImage(bufferedImage2, n, n2, component);
    }

    public static final void drawImageBorder(Graphics graphics, ImageIcon imageIcon, Rectangle rectangle, Insets insets, boolean bl) {
        int n = insets.left;
        int n2 = insets.right;
        int n3 = insets.top;
        int n4 = insets.bottom;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        graphics.drawImage(imageIcon.getImage(), n5, n6, n5 + n, n6 + n3, 0, 0, n, n3, null);
        graphics.drawImage(imageIcon.getImage(), n5 + n, n6, n5 + n7 - n2, n6 + n3, n, 0, imageIcon.getIconWidth() - n2, n3, null);
        graphics.drawImage(imageIcon.getImage(), n5 + n7 - n2, n6, n5 + n7, n6 + n3, imageIcon.getIconWidth() - n2, 0, imageIcon.getIconWidth(), n3, null);
        graphics.drawImage(imageIcon.getImage(), n5, n6 + n3, n5 + n, n6 + n8 - n4, 0, n3, n, imageIcon.getIconHeight() - n4, null);
        graphics.drawImage(imageIcon.getImage(), n5 + n, n6 + n3, n5 + n7 - n2, n6 + n8 - n4, n, n3, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight() - n4, null);
        graphics.drawImage(imageIcon.getImage(), n5 + n7 - n2, n6 + n3, n5 + n7, n6 + n8 - n4, imageIcon.getIconWidth() - n2, n3, imageIcon.getIconWidth(), imageIcon.getIconHeight() - n4, null);
        graphics.drawImage(imageIcon.getImage(), n5, n6 + n8 - n4, n5 + n, n6 + n8, 0, imageIcon.getIconHeight() - n4, n, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n5 + n, n6 + n8 - n4, n5 + n7 - n2, n6 + n8, n, imageIcon.getIconHeight() - n4, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n5 + n7 - n2, n6 + n8 - n4, n5 + n7, n6 + n8, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight() - n4, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        if (bl) {
            graphics.drawImage(imageIcon.getImage(), n5 + n, n6 + n3, n5 + n7 - n2, n6 + n8 - n4, n, n3, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight() - n4, null);
        }
    }

    public static final boolean compositeRequestFocus(Component component) {
        LOGGER_FOCUS.fine("compositeRequestFocus " + component);
        if (component instanceof Container) {
            Object object;
            Object object2;
            LOGGER_FOCUS.fine("compositeRequestFocus is container.");
            Container container = (Container)component;
            if (container.isFocusCycleRoot()) {
                LOGGER_FOCUS.fine("compositeRequestFocus is focuscycleroot.");
                object2 = container.getFocusTraversalPolicy();
                object = ((FocusTraversalPolicy)object2).getDefaultComponent(container);
                LOGGER_FOCUS.fine("compositeRequestFocus default component = " + object);
                if (object != null && ((Component)object).isShowing() && container.getComponentCount() > 0) {
                    LOGGER_FOCUS.fine("compositeRequestFocus default component passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest((Component)object));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + object);
                    return ((Component)object).requestFocusInWindow();
                }
            }
            if ((object2 = container.getFocusCycleRootAncestor()) != null) {
                LOGGER_FOCUS.fine("compositeRequestFocus using rootAncestor =" + object2);
                object = ((Container)object2).getFocusTraversalPolicy();
                Component component2 = null;
                try {
                    component2 = ((FocusTraversalPolicy)object).getComponentAfter((Container)object2, container);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter =" + component2);
                if (component2 != null && SwingUtilities.isDescendingFrom(component2, container)) {
                    LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(component2));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + component2);
                    return component2.requestFocusInWindow();
                }
            }
        }
        if (!JideSwingUtilities.passesFocusabilityTest(component)) {
            LOGGER_FOCUS.fine("compositeRequestFocus returingfalse because !passesFocusabilityTest" + component);
            return false;
        }
        LOGGER_FOCUS.fine("compositeRequestFocus component=" + component);
        return component.requestFocusInWindow();
    }

    public static final boolean isAncestorOfFocusOwner(Component component) {
        boolean bl = false;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == component2 || component instanceof Container && ((Container)component).isAncestorOf(component2)) {
            bl = true;
        }
        return bl;
    }

    public static final Window getWindowForComponent(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return JideSwingUtilities.getWindowForComponent(component.getParent());
    }

    public static final boolean isKeyListenerRegistered(Component component, KeyListener keyListener) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener2 : keyListenerArray = component.getKeyListeners()) {
            if (keyListener2 != keyListener) continue;
            return true;
        }
        return false;
    }

    public static final void insertKeyListener(Component component, KeyListener keyListener, int n) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener2 : keyListenerArray = component.getKeyListeners()) {
            component.removeKeyListener(keyListener2);
        }
        for (int i2 = 0; i2 < keyListenerArray.length; ++i2) {
            KeyListener keyListener3 = keyListenerArray[i2];
            if (n == i2) {
                component.addKeyListener(keyListener);
            }
            component.addKeyListener(keyListener3);
        }
        if (n > keyListenerArray.length - 1) {
            component.addKeyListener(keyListener);
        }
    }

    public static final void insertTableModelListener(TableModel tableModel, TableModelListener tableModelListener, int n) {
        TableModelListener[] tableModelListenerArray;
        if (!(tableModel instanceof AbstractTableModel)) {
            tableModel.addTableModelListener(tableModelListener);
            return;
        }
        for (TableModelListener tableModelListener2 : tableModelListenerArray = ((AbstractTableModel)tableModel).getTableModelListeners()) {
            tableModel.removeTableModelListener(tableModelListener2);
        }
        for (int i2 = 0; i2 < tableModelListenerArray.length; ++i2) {
            TableModelListener tableModelListener3 = tableModelListenerArray[i2];
            if (n == i2) {
                tableModel.addTableModelListener(tableModelListener);
            }
            tableModel.addTableModelListener(tableModelListener3);
        }
        if (n < 0 || n > tableModelListenerArray.length - 1) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    public static final boolean isPropertyChangeListenerRegistered(Component component, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray = component.getPropertyChangeListeners()) {
            if (propertyChangeListener2 != propertyChangeListener) continue;
            return true;
        }
        return false;
    }

    public static final boolean isPropertyChangeListenerRegistered(Component component, String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (string == null) {
            return JideSwingUtilities.isPropertyChangeListenerRegistered(component, propertyChangeListener);
        }
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray = component.getPropertyChangeListeners(string)) {
            if (propertyChangeListener2 != propertyChangeListener) continue;
            return true;
        }
        return false;
    }

    public static final boolean isMouseListenerRegistered(Component component, MouseListener mouseListener) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener2 : mouseListenerArray = component.getMouseListeners()) {
            if (mouseListener2 != mouseListener) continue;
            return true;
        }
        return false;
    }

    public static final void insertMouseListener(Component component, MouseListener mouseListener, int n) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener2 : mouseListenerArray = component.getMouseListeners()) {
            component.removeMouseListener(mouseListener2);
        }
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            MouseListener mouseListener3 = mouseListenerArray[i2];
            if (n == i2) {
                component.addMouseListener(mouseListener);
            }
            component.addMouseListener(mouseListener3);
        }
        if (n < 0 || n > mouseListenerArray.length - 1) {
            component.addMouseListener(mouseListener);
        }
    }

    public static final boolean isMouseMotionListenerRegistered(Component component, MouseMotionListener mouseMotionListener) {
        MouseMotionListener[] mouseMotionListenerArray;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = component.getMouseMotionListeners()) {
            if (mouseMotionListener2 != mouseMotionListener) continue;
            return true;
        }
        return false;
    }

    public static final void insertMouseMotionListener(Component component, MouseMotionListener mouseMotionListener, int n) {
        MouseMotionListener[] mouseMotionListenerArray;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(mouseMotionListener2);
        }
        for (int i2 = 0; i2 < mouseMotionListenerArray.length; ++i2) {
            MouseMotionListener mouseMotionListener3 = mouseMotionListenerArray[i2];
            if (n == i2) {
                component.addMouseMotionListener(mouseMotionListener);
            }
            component.addMouseMotionListener(mouseMotionListener3);
        }
        if (n < 0 || n > mouseMotionListenerArray.length - 1) {
            component.addMouseMotionListener(mouseMotionListener);
        }
    }

    public static final Component getScrollPane(Component component) {
        Component component2 = component;
        if (component instanceof JScrollPane) {
            return component;
        }
        if (component2.getParent() != null && component2.getParent().getParent() != null && component2.getParent().getParent() instanceof JScrollPane) {
            component2 = component2.getParent().getParent();
            return component2;
        }
        return null;
    }

    public static final boolean isListenerRegistered(EventListenerList eventListenerList, Class clazz, EventListener eventListener) {
        Object[] objectArray = eventListenerList.getListenerList();
        return JideSwingUtilities.isListenerRegistered(objectArray, clazz, eventListener);
    }

    public static final boolean isListenerRegistered(Component component, Class clazz, EventListener eventListener) {
        Object[] objectArray = component.getListeners(clazz);
        return JideSwingUtilities.isListenerRegistered(objectArray, clazz, eventListener);
    }

    private static boolean isListenerRegistered(Object[] objectArray, Class clazz, EventListener eventListener) {
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != clazz || !objectArray[i2 + 1].equals(eventListener)) continue;
            return true;
        }
        return false;
    }

    public static final Component getFirstChildOf(Class clazz, Component component) {
        return JideSwingUtilities.getRecursively(component, new JideSwingUtilities$17(clazz));
    }

    public static final int getComponentIndex(Container container, Component component) {
        if (component.getParent() != container) {
            return -1;
        }
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] != component) continue;
            return i2;
        }
        return -1;
    }

    public static final Vector convertDefaultComboBoxModelToVector(DefaultComboBoxModel defaultComboBoxModel) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < defaultComboBoxModel.getSize(); ++i2) {
            vector.add(defaultComboBoxModel.getElementAt(i2));
        }
        return vector;
    }

    public static final void ensureRowVisible(JTable jTable, int n) {
        Rectangle rectangle;
        Rectangle rectangle2 = jTable.getVisibleRect();
        Rectangle rectangle3 = jTable.getCellRect(n, 0, true);
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        if (n < jTable.getModel().getRowCount() - 1) {
            rectangle5 = jTable.getCellRect(n + 1, 0, true);
        }
        if (n > 0) {
            rectangle4 = jTable.getCellRect(n - 1, 0, true);
        }
        int n2 = (int)rectangle3.getMinY();
        int n3 = (int)rectangle3.getMaxY();
        int n4 = rectangle2.x;
        int n5 = rectangle2.x + rectangle2.width;
        if (rectangle4 != null) {
            n2 = (int)rectangle4.getMinY();
        }
        if (rectangle5 != null) {
            n3 = (int)rectangle5.getMaxY();
        }
        if (!rectangle2.contains(rectangle = new Rectangle(n4, n2, n5 - n4, n3 - n2)) && rectangle.height != 0) {
            jTable.scrollRectToVisible(rectangle);
        }
    }

    public static final void retargetMouseEvent(int n, MouseEvent mouseEvent, Component component) {
        if (component == null || component == mouseEvent.getSource() && n == mouseEvent.getID()) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), component);
        MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        component.dispatchEvent(mouseEvent2);
    }

    public static final JRootPane getOutermostRootPane(Component component) {
        if (component instanceof RootPaneContainer && component.getParent() == null) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)component;
                if (component.getParent().getParent() == null) {
                    return jRootPane;
                }
                if (component.getParent() instanceof JDialog || component.getParent() instanceof JWindow || component.getParent() instanceof JFrame || component.getParent() instanceof JApplet) {
                    return jRootPane;
                }
                component = component.getParent().getParent();
            }
            component = SwingUtilities.getRootPane(component);
        }
        return null;
    }

    public static final boolean isFixedWidthFont(String string, Component component) {
        if (string.endsWith(" Bold") || string.endsWith(" ITC") || string.endsWith(" MT") || string.endsWith(" LET") || string.endsWith(".bold") || string.endsWith(".italic")) {
            return false;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Font font = new Font(string, 0, 12);
            if (!font.canDisplay('W')) {
                return false;
            }
            Font font2 = font.deriveFont(1);
            FontMetrics fontMetrics = component.getFontMetrics(font);
            FontMetrics fontMetrics2 = component.getFontMetrics(font2);
            int n6 = fontMetrics.charWidth('l');
            if (n6 == (n5 = fontMetrics2.charWidth('l')) && (n4 = fontMetrics.charWidth('W')) == (n3 = fontMetrics2.charWidth('W')) && n6 == n4 && (n2 = fontMetrics.charWidth(' ')) == (n = fontMetrics2.charWidth(' '))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static final void setLocaleRecursively(Component component, Locale locale) {
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities$18(locale));
    }

    public static final void setBounds(Container container, Component component, Rectangle rectangle) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(rectangle);
        } else {
            Rectangle rectangle2 = new Rectangle(rectangle);
            int n = container.getWidth();
            rectangle2.x = n - (rectangle.x + rectangle.width);
            component.setBounds(rectangle2);
        }
    }

    public static final void setBounds(Container container, Component component, int n, int n2, int n3, int n4) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(n, n2, n3, n4);
        } else {
            int n5 = container.getWidth();
            component.setBounds(n5 - n - n3, n2, n3, n4);
        }
    }

    public static final void invalidateRecursively(Component component) {
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities$19());
        }
        component.doLayout();
        component.repaint();
    }

    public static final void synchronizeKeyboardActions(JComponent jComponent, JComponent jComponent2, KeyStroke[] keyStrokeArray, int n) {
        for (KeyStroke keyStroke : keyStrokeArray) {
            ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
            if (actionListener == null) continue;
            jComponent2.registerKeyboardAction(actionListener, keyStroke, n);
        }
    }

    public static final JComponent getFirstJComponent(RootPaneContainer rootPaneContainer) {
        return (JComponent)JideSwingUtilities.getRecursively(rootPaneContainer.getContentPane(), new JideSwingUtilities$20());
    }

    public static final Dimension adjustPreferredScrollableViewportSize(JList jList, Dimension dimension) {
        Dimension dimension2;
        Component component;
        ListCellRenderer<String> listCellRenderer;
        Rectangle rectangle = jList.getCellBounds(0, 0);
        if (rectangle != null && rectangle.height < 3 && (listCellRenderer = jList.getCellRenderer()) != null && (component = listCellRenderer.getListCellRendererComponent(jList, "DUMMY STRING", 0, false, false)) != null && (dimension2 = component.getPreferredSize()) != null) {
            int n = dimension2.height;
            if (n < 3) {
                try {
                    n = jList.getCellBounds((int)1, (int)1).height;
                }
                catch (Exception exception) {
                    n = 16;
                }
            }
            jList.setFixedCellHeight(n);
        }
        if (SystemInfo.isJdk15Above()) {
            return dimension;
        }
        ++dimension.height;
        return dimension;
    }

    public static final void removeFromParentWithFocusTransfer(Component component) {
        boolean bl = component.isVisible();
        component.setVisible(false);
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        component.setVisible(bl);
    }

    public static final int getLineHeight(Component component, int n) {
        Font font;
        Font font2 = font = component == null ? null : component.getFont();
        if (font == null) {
            return n;
        }
        FontMetrics fontMetrics = component.getFontMetrics(font);
        float f2 = fontMetrics.getHeight();
        return (int)(f2 += (float)fontMetrics.getDescent());
    }

    public static final void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public static final void removeExtraSeparators(JPopupMenu jPopupMenu) {
        Component[] componentArray = jPopupMenu.getComponents();
        if (componentArray.length <= 1) {
            return;
        }
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (!(component instanceof JSeparator)) continue;
            if (i2 == 0 || i2 == componentArray.length - 1) {
                jPopupMenu.remove(component);
                continue;
            }
            if (!(componentArray[i2 - 1] instanceof JSeparator)) continue;
            jPopupMenu.remove(component);
        }
    }

    public static final void setTextComponentTransparent(JComponent jComponent) {
        JideSwingUtilities.setComponentTransparent(jComponent);
    }

    public static final void setComponentTransparent(JComponent jComponent) {
        jComponent.setOpaque(false);
        jComponent.putClientProperty("Synthetica.opaque", false);
        jComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        jComponent.putClientProperty("Nimbus.Overrides", new UIDefaults());
    }

    public static final int binarySearch(List list, Object object) {
        int n = 0;
        int n2 = list.size();
        int n3 = n2 / 2;
        while (n < n2) {
            if (!(list.get(n3) instanceof Comparable)) {
                return n3;
            }
            int n4 = ((Comparable)list.get(n3)).compareTo(object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * n3;
    }

    public static final int binarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = n2 / 2;
        while (n < n2) {
            if (!(objectArray[n3] instanceof Comparable)) {
                return n3;
            }
            int n4 = ((Comparable)objectArray[n3]).compareTo(object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * n3;
    }

    public static final int binarySearch(int[] nArray, int n) {
        return JideSwingUtilities.binarySearch(nArray, n, 0, nArray.length);
    }

    public static final int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n5 / 2;
        while (n4 < n5) {
            if (nArray[n6] == n) {
                return n6;
            }
            if (nArray[n6] < n) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * n6;
    }

    public static final boolean isMenuShortcutKeyDown(InputEvent inputEvent) {
        return (inputEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static final boolean isMenuShortcutKeyDown(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static final ChangeListener getViewportSynchronizationChangeListener() {
        if (_viewportSyncListener == null) {
            _viewportSyncListener = new JideSwingUtilities$viewportSynchronizationChangeListener(null);
        }
        return _viewportSyncListener;
    }

    public static final void setWindowOpaque(Window window, boolean bl) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(null, window, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void setWindowOpacity(Window window, float f2) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            method.invoke(null, window, Float.valueOf(f2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void setWindowShape(Window window, Shape shape) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowShape", Window.class, Shape.class);
            method.invoke(null, window, shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String getOKString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.okButtonText", locale);
        if (!(string != null && string.length() > 0 || (string = UIDefaultsLookup.getString("ColorChooser.okText")) != null && string.length() > 0)) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.ok");
        }
        return string;
    }

    public static final String getCancelString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale);
        if (!(string != null && string.length() > 0 || (string = UIDefaultsLookup.getString("ColorChooser.cancelText")) != null && string.length() > 0)) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.cancel");
        }
        return string;
    }

    public static final String getYesString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.yesButtonText", locale);
        if (string == null || string.length() <= 0) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.yes");
        }
        return string;
    }

    public static final String getNoString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.noButtonText", locale);
        if (string == null || string.length() <= 0) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.no");
        }
        return string;
    }

    static final /* synthetic */ PropertyChangeListener access$000() {
        return _setOpaqueTrueListener;
    }

    static final /* synthetic */ PropertyChangeListener access$002(PropertyChangeListener propertyChangeListener) {
        _setOpaqueTrueListener = propertyChangeListener;
        return _setOpaqueTrueListener;
    }

    static final /* synthetic */ PropertyChangeListener access$100() {
        return _setOpaqueFalseListener;
    }

    static final /* synthetic */ PropertyChangeListener access$102(PropertyChangeListener propertyChangeListener) {
        _setOpaqueFalseListener = propertyChangeListener;
        return _setOpaqueFalseListener;
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        Object object = SecurityUtils.getProperty("swing.aatext", "false");
        AA_TEXT_DEFINED = object != null;
        AA_TEXT = "true".equals(object);
        renderingHints = null;
        if (SystemInfo.isJdk6Above()) {
            object = Toolkit.getDefaultToolkit();
            renderingHints = (Map)((Toolkit)object).getDesktopProperty("awt.font.desktophints");
            ((Toolkit)object).addPropertyChangeListener("awt.font.desktophints", new JideSwingUtilities$10());
        }
        tracingFocus = false;
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }
}

