/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SidePane$AccessibleSidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class SidePane
extends JPanel
implements SwingConstants,
Accessible {
    private final List _groups = new ArrayList();
    private int _attachedSide;
    private boolean _rollover = true;
    private static final String uiClassID = "SidePaneUI";

    public SidePane(int n) {
        this.setAttachedSide(n);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public final SidePaneUI getUI() {
        return (SidePaneUI)this.ui;
    }

    public final void setUI(SidePaneUI sidePaneUI) {
        super.setUI(sidePaneUI);
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((SidePaneUI)UIManager.getUI(this));
    }

    public final String getUIClassID() {
        return uiClassID;
    }

    public void addGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().add(sidePaneGroup);
    }

    public void removeGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().remove(sidePaneGroup);
    }

    public final void removeGroup(int n) {
        this.removeGroup((SidePaneGroup)this.getGroups().get(n));
    }

    public final List getGroups() {
        return this._groups;
    }

    public final int getAttachedSide() {
        return this._attachedSide;
    }

    public final void setAttachedSide(int n) {
        if (n != 1 && n != 5 && n != 7 && n != 3) {
            throw new IllegalArgumentException("illegal attached side: must be NORTH, SOUTH, WEST, or EAST");
        }
        this._attachedSide = n;
        this.updateUI();
    }

    public final boolean isRollover() {
        return this._rollover;
    }

    public final void setRollover(boolean bl) {
        this._rollover = bl;
        this.updateUI();
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        if (this.getUI() != null && !this.isRollover()) {
            int n = this.getUI().getSelectedItemIndex(mouseEvent.getPoint());
            SidePaneItem sidePaneItem = this.getUI().getItemForIndex(n);
            if (sidePaneItem != null && sidePaneItem.getComponent() instanceof JComponent) {
                return ((JComponent)sidePaneItem.getComponent()).getToolTipText();
            }
        }
        return null;
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new SidePane$AccessibleSidePane(this);
        }
        return this.accessibleContext;
    }
}

