/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils {
    private static final long DAY_IN_MS = 86400000L;

    public static final boolean isToday(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static final boolean isThisWeek(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static final boolean isThisMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2);
    }

    public static final boolean isThisQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(2) / 3 == calendar.get(2) / 3;
    }

    public static final boolean isThisYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1);
    }

    public static final boolean isYesterday(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), -1);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static final boolean isLastWeek(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), -7);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static final boolean isLastMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2);
        if (n > 1) {
            return calendar2.get(1) == calendar.get(1) && n - 1 == calendar.get(2);
        }
        return calendar2.get(1) - 1 == calendar.get(1) && calendar2.getActualMaximum(2) == calendar.get(2);
    }

    public static final boolean isLastQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2) / 3;
        if (n > 1) {
            return calendar2.get(1) == calendar.get(1) && n - 1 == calendar.get(2) / 3;
        }
        return calendar2.get(1) - 1 == calendar.get(1) && calendar2.getActualMaximum(2) / 3 == calendar.get(2) / 3;
    }

    public static final boolean isLastYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) - 1 == calendar.get(1);
    }

    public static final boolean isTomorrow(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), 1);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static final boolean isNextWeek(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), 7);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static final boolean isNextMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2);
        if (n < calendar2.getActualMaximum(2)) {
            return calendar2.get(1) == calendar.get(1) && n + 1 == calendar.get(2);
        }
        return calendar2.get(1) + 1 == calendar.get(1) && calendar2.getMinimum(2) == calendar.get(2);
    }

    public static final boolean isNextQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2) / 3;
        if (n < calendar2.getActualMaximum(2) / 3) {
            return calendar2.get(1) == calendar.get(1) && n + 1 == calendar.get(2) / 3;
        }
        return calendar2.get(1) + 1 == calendar.get(1) && calendar2.getActualMinimum(2) / 3 == calendar.get(2) / 3;
    }

    public static final boolean isNextYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) + 1 == calendar.get(1);
    }

    public static final boolean isAtMonth(Calendar calendar, int n) {
        return calendar.get(2) == n;
    }

    public static final boolean isAtQuarter(Calendar calendar, int n) {
        return calendar.get(2) / 3 + 1 == n;
    }

    public static final Calendar adjustDate(Calendar calendar, int n) {
        calendar.setTimeInMillis(calendar.getTimeInMillis() + 86400000L * (long)n);
        return calendar;
    }

    public static final Date min(List list) {
        return DateUtils.minDates(list);
    }

    public static final Date max(List list) {
        return DateUtils.maxDates(list);
    }

    public static final Date minDates(List list) {
        long l2 = Long.MAX_VALUE;
        Date date = null;
        for (Date date2 : list) {
            long l3 = date2.getTime();
            if (l3 >= l2) continue;
            l2 = l3;
            date = date2;
        }
        return date;
    }

    public static final Date maxDates(List list) {
        long l2 = Long.MIN_VALUE;
        Date date = null;
        for (Date date2 : list) {
            long l3 = date2.getTime();
            if (l3 <= l2) continue;
            l2 = l3;
            date = date2;
        }
        return date;
    }

    public static final Calendar minCalendars(List list) {
        long l2 = Long.MAX_VALUE;
        Calendar calendar = null;
        for (Calendar calendar2 : list) {
            long l3 = calendar2.getTimeInMillis();
            if (l3 >= l2) continue;
            l2 = l3;
            calendar = calendar2;
        }
        return calendar;
    }

    public static final Calendar maxCalendars(List list) {
        long l2 = Long.MIN_VALUE;
        Calendar calendar = null;
        for (Calendar calendar2 : list) {
            long l3 = calendar2.getTimeInMillis();
            if (l3 <= l2) continue;
            l2 = l3;
            calendar = calendar2;
        }
        return calendar;
    }
}

