/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.SourcelessOpImage;
import javax.media.jai.TileCache;

final class AWTImageOpImage
extends SourcelessOpImage {
    private int[] pixels;
    private RasterFormatTag rasterFormatTag = null;

    public AWTImageOpImage(TileCache tileCache, ImageLayout imageLayout, Image image) {
        super(0, 0, 0, 0, null, tileCache, imageLayout);
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage0"));
        }
        if (mediaTracker.isErrorID(0)) {
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage1"));
        }
        mediaTracker.removeImage(image);
        this.minX = 0;
        this.minY = 0;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        if (imageLayout == null || !imageLayout.isValid(64)) {
            this.tileWidth = this.width;
        }
        if (imageLayout == null || !imageLayout.isValid(128)) {
            this.tileHeight = this.height;
        }
        this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, 3);
        this.rasterFormatTag = new RasterFormatTag(this.sampleModel, 0);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            if (!pixelGrabber.grabPixels()) {
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    throw new RuntimeException(JaiI18N.getString("AWTImageOpImage2"));
                }
                throw new RuntimeException(String.valueOf(pixelGrabber.getStatus()) + JaiI18N.getString("AWTImageOpImage3"));
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage4"));
        }
        this.colorModel = PlanarImage.createColorModel(this.sampleModel);
    }

    protected final void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.rasterFormatTag, null);
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getBandOffset(0);
        int n6 = rasterAccessor.getBandOffset(1);
        int n7 = rasterAccessor.getBandOffset(2);
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        int n8 = (rectangle.y - this.minY) * this.width + (rectangle.x - this.minX);
        int n9 = 0;
        while (n9 < n2) {
            int n10 = n5;
            int n11 = n6;
            int n12 = n7;
            n5 += n3;
            n6 += n3;
            n7 += n3;
            int n13 = n8;
            n8 += this.width;
            int n14 = 0;
            while (n14 < n) {
                byArray[n10] = (byte)(this.pixels[n13] >> 16 & 0xFF);
                byArray[n11] = (byte)(this.pixels[n13] >> 8 & 0xFF);
                byArray[n12] = (byte)(this.pixels[n13] & 0xFF);
                n10 += n4;
                n11 += n4;
                n12 += n4;
                ++n13;
                ++n14;
            }
            ++n9;
        }
    }
}

