/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.MathJAI;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.media.jai.operator.DFTDescriptor;

public class FFT {
    public static final int SCALING_NONE = DFTDescriptor.SCALING_NONE;
    public static final int SCALING_UNITARY = DFTDescriptor.SCALING_UNITARY;
    public static final int SCALING_DIMENSIONS = DFTDescriptor.SCALING_DIMENSIONS;
    protected boolean lengthIsSet = false;
    protected int exponentSign;
    protected int scaleType;
    protected int length;
    private int nbits;
    private int[] index;
    private double scaleFactor;
    private double[] wr;
    private double[] wi;
    private double[] wrFCT;
    private double[] wiFCT;
    protected double[] real;
    protected double[] imag;

    public FFT(boolean bl, Integer n, int n2) {
        this.exponentSign = bl ? -1 : 1;
        this.scaleType = n;
        this.setLength(n2);
    }

    private void calculateCoefficientLUTs() {
        this.wr = new double[this.nbits];
        this.wi = new double[this.nbits];
        int n = 1;
        double d2 = (double)this.exponentSign * Math.PI;
        int n2 = 0;
        while (n2 < this.nbits) {
            this.wr[n2] = Math.cos(d2 / (double)n);
            this.wi[n2] = Math.sin(d2 / (double)n);
            n *= 2;
            ++n2;
        }
    }

    private void calculateFCTLUTs() {
        this.wrFCT = new double[this.length];
        this.wiFCT = new double[this.length];
        int n = 0;
        while (n < this.length) {
            double d2 = n == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d3 = Math.PI * (double)n / (2.0 * (double)this.length);
            this.wrFCT[n] = d2 * Math.cos(d3);
            this.wiFCT[n] = d2 * Math.sin(d3);
            ++n;
        }
    }

    public void getData(int n, Object object, int n2, int n3, Object object2, int n4, int n5) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n6 = 0;
                        while (n6 < this.length) {
                            int n7 = this.index[n6];
                            fArray[n2] = (float)this.real[n7];
                            fArray2[n2] = (float)this.imag[n7];
                            n2 += n3;
                            ++n6;
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < this.length) {
                            int n9 = this.index[n8];
                            fArray[n2] = (float)this.real[n9];
                            fArray2[n4] = (float)this.imag[n9];
                            n2 += n3;
                            n4 += n5;
                            ++n8;
                        }
                    }
                } else {
                    int n10 = 0;
                    while (n10 < this.length) {
                        fArray[n2] = (float)this.real[this.index[n10]];
                        n2 += n3;
                        ++n10;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n11 = 0;
                        while (n11 < this.length) {
                            int n12 = this.index[n11];
                            dArray[n2] = this.real[n12];
                            dArray2[n2] = this.imag[n12];
                            n2 += n3;
                            ++n11;
                        }
                    } else {
                        int n13 = 0;
                        while (n13 < this.length) {
                            int n14 = this.index[n13];
                            dArray[n2] = this.real[n14];
                            dArray2[n4] = this.imag[n14];
                            n2 += n3;
                            n4 += n5;
                            ++n13;
                        }
                    }
                } else {
                    int n15 = 0;
                    while (n15 < this.length) {
                        dArray[n2] = this.real[this.index[n15]];
                        n2 += n3;
                        ++n15;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
    }

    public final void getFCTData(int n, Object object, int n2, int n3) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = 0;
                while (n4 < this.length) {
                    int n5 = this.index[n4];
                    fArray[n2] = (float)(this.wrFCT[n4] * this.real[n5] + this.wiFCT[n4] * this.imag[n5]);
                    n2 += n3;
                    ++n4;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = 0;
                while (n6 < this.length) {
                    int n7 = this.index[n6];
                    dArray[n2] = this.wrFCT[n6] * this.real[n7] + this.wiFCT[n6] * this.imag[n7];
                    n2 += n3;
                    ++n6;
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
    }

    public final void getIFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = this.length - 1;
                int n5 = 0;
                while (n5 < n4) {
                    fArray[n2] = (float)this.real[this.index[n5]];
                    fArray[n2 += n3] = (float)this.real[this.index[n4--]];
                    n2 += n3;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = this.length - 1;
                int n7 = 0;
                while (n7 < n6) {
                    dArray[n2] = (float)this.real[this.index[n7]];
                    dArray[n2 += n3] = (float)this.real[this.index[n6--]];
                    n2 += n3;
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
    }

    private void initBitReversalLUT() {
        this.index = new int[this.length];
        int n = 0;
        while (n < this.length) {
            int n2 = n;
            int n3 = this.length >> 1;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.nbits) {
                int n6 = n2 & 1;
                if (n6 != 0) {
                    n4 += n3;
                }
                n2 >>= 1;
                n3 >>= 1;
                this.index[n] = n4;
                ++n5;
            }
            ++n;
        }
    }

    public final void setData(int n, Object object, int n2, int n3, Object object2, int n4, int n5, int n6) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n7 = 0;
                        while (n7 < n6) {
                            this.real[n7] = fArray[n2];
                            this.imag[n7] = fArray2[n2];
                            n2 += n3;
                            ++n7;
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < n6) {
                            this.real[n8] = fArray[n2];
                            this.imag[n8] = fArray2[n4];
                            n2 += n3;
                            n4 += n5;
                            ++n8;
                        }
                    }
                } else {
                    int n9 = 0;
                    while (n9 < n6) {
                        this.real[n9] = fArray[n2];
                        n2 += n3;
                        ++n9;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (n3 == 1 && n5 == 1) {
                    System.arraycopy(dArray, n2, this.real, 0, n6);
                    if (object2 == null) break;
                    System.arraycopy((double[])object2, n4, this.imag, 0, n6);
                    break;
                }
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n10 = 0;
                        while (n10 < n6) {
                            this.real[n10] = dArray[n2];
                            this.imag[n10] = dArray2[n2];
                            n2 += n3;
                            ++n10;
                        }
                    } else {
                        int n11 = 0;
                        while (n11 < n6) {
                            this.real[n11] = dArray[n2];
                            this.imag[n11] = dArray2[n4];
                            n2 += n3;
                            n4 += n5;
                            ++n11;
                        }
                    }
                } else {
                    int n12 = 0;
                    while (n12 < n6) {
                        this.real[n12] = dArray[n2];
                        n2 += n3;
                        ++n12;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
        if (n6 < this.length) {
            Arrays.fill(this.real, n6, this.length, 0.0);
            if (object2 != null) {
                Arrays.fill(this.imag, n6, this.length, 0.0);
            }
        }
        if (object2 == null) {
            Arrays.fill(this.imag, 0, this.length, 0.0);
        }
    }

    public final void setFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < n4) {
                    this.imag[n5] = fArray[n2];
                    n2 += n3;
                    ++n5;
                }
                int n6 = n4;
                while (n6 < this.length) {
                    this.imag[n6] = 0.0;
                    ++n6;
                }
                int n7 = this.length - 1;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n7) {
                    this.real[n9] = this.imag[n8++];
                    this.real[n7--] = this.imag[n8++];
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n10 = 0;
                while (n10 < n4) {
                    this.imag[n10] = dArray[n2];
                    n2 += n3;
                    ++n10;
                }
                int n11 = n4;
                while (n11 < this.length) {
                    this.imag[n11] = 0.0;
                    ++n11;
                }
                int n12 = this.length - 1;
                int n13 = 0;
                int n14 = 0;
                while (n14 < n12) {
                    this.real[n14] = this.imag[n13++];
                    this.real[n12--] = this.imag[n13++];
                    ++n14;
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    public final void setIFCTData(int n, Object object, int n2, int n3, int n4) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < n4) {
                    float f2 = fArray[n2];
                    this.real[n5] = (double)f2 * this.wrFCT[n5];
                    this.imag[n5] = (double)f2 * this.wiFCT[n5];
                    n2 += n3;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = 0;
                while (n6 < n4) {
                    double d2 = dArray[n2];
                    this.real[n6] = d2 * this.wrFCT[n6];
                    this.imag[n6] = d2 * this.wiFCT[n6];
                    n2 += n3;
                    ++n6;
                }
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(n) + JaiI18N.getString("FFT2"));
            }
        }
        if (n4 < this.length) {
            Arrays.fill(this.real, n4, this.length, 0.0);
            Arrays.fill(this.imag, n4, this.length, 0.0);
        }
    }

    public void setLength(int n) {
        if (this.lengthIsSet && n == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n)) {
            throw new RuntimeException(JaiI18N.getString("FFT0"));
        }
        this.length = n;
        if (this.scaleType == SCALING_NONE) {
            this.scaleFactor = 1.0;
        } else if (this.scaleType == SCALING_UNITARY) {
            this.scaleFactor = 1.0 / Math.sqrt(n);
        } else if (this.scaleType == SCALING_DIMENSIONS) {
            this.scaleFactor = 1.0 / (double)n;
        } else {
            throw new RuntimeException(JaiI18N.getString("FFT1"));
        }
        int n2 = 1;
        this.nbits = 0;
        while (n2 < n) {
            ++this.nbits;
            n2 <<= 1;
        }
        this.initBitReversalLUT();
        this.calculateCoefficientLUTs();
        if (!this.lengthIsSet || n > this.real.length) {
            this.real = new double[n];
            this.imag = new double[n];
        }
        this.lengthIsSet = true;
    }

    public void transform() {
        int n;
        Integer n2 = new Integer(this.length);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        if (this.real.length < this.length || this.imag.length < this.length) {
            throw new RuntimeException(String.valueOf(numberFormat.format(n2)) + JaiI18N.getString("FFT3"));
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.nbits) {
            double d2 = 1.0;
            double d3 = 0.0;
            int n5 = 2 * n3;
            int n6 = 0;
            while (n6 < n3) {
                n = n6;
                while (n < this.length) {
                    int n7 = n + n3;
                    int n8 = this.index[n];
                    int n9 = this.index[n7];
                    double d4 = this.real[n9] * d2 - this.imag[n9] * d3;
                    double d5 = this.imag[n9] * d2 + this.real[n9] * d3;
                    this.real[n9] = this.real[n8] - d4;
                    this.imag[n9] = this.imag[n8] - d5;
                    this.real[n8] = this.real[n8] + d4;
                    this.imag[n8] = this.imag[n8] + d5;
                    n += n5;
                }
                double d6 = d2;
                d2 = d2 * this.wr[n4] - d3 * this.wi[n4];
                d3 = d6 * this.wi[n4] + d3 * this.wr[n4];
                ++n6;
            }
            n3 *= 2;
            ++n4;
        }
        if (this.scaleFactor != 1.0) {
            n = 0;
            while (n < this.length) {
                this.real[n] = this.real[n] * this.scaleFactor;
                this.imag[n] = this.imag[n] * this.scaleFactor;
                ++n;
            }
        }
    }
}

