/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CRIFImpl;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;

final class FilterCRIF
extends CRIFImpl {
    private static final int STEPSIZE = 5;

    public final RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        KernelJAI kernelJAI = FilterCRIF.createKernel(parameterBlock.getFloatParameter(0));
        return kernelJAI == null ? parameterBlock.getRenderedSource(0) : JAI.create("convolve", parameterBlock.getRenderedSource(0), (Object)kernelJAI);
    }

    private static final KernelJAI createKernel(double d2) {
        float[] fArray;
        int n;
        int n2 = 5;
        if (d2 == 0.0) {
            return null;
        }
        double d3 = Math.abs(d2);
        int n3 = (int)d3 / n2;
        double d4 = (double)(10.0f / (float)n2) * (d3 - (double)(n3 * n2));
        double d5 = 0.010101010101010102 * (Math.pow(10.0, 0.2 * d4) - 1.0);
        if ((double)(n3 * n2) == d3) {
            n = 2 * n3 + 1;
            fArray = new float[n * n];
            float f2 = 1.0f / (float)(n * n);
            Arrays.fill(fArray, f2);
        } else {
            int n4 = 2 * n3 + 1;
            n = n4 + 2;
            fArray = new float[n * n];
            float f3 = 1.0f / (float)(n4 * n4) * (1.0f - (float)d5);
            int n5 = n;
            int n6 = 1;
            while (n6 < n - 1) {
                int n7 = 1;
                while (n7 < n - 1) {
                    fArray[n5 + n7] = f3;
                    ++n7;
                }
                n5 += n;
                ++n6;
            }
            float f4 = 1.0f / (float)(n * n) * (float)d5;
            int n8 = 0;
            while (n8 < fArray.length) {
                int n9 = n8++;
                fArray[n9] = fArray[n9] + f4;
            }
        }
        if (d2 > 0.0) {
            int n10 = 0;
            while (n10 < fArray.length) {
                int n11 = n10++;
                fArray[n11] = (float)((double)fArray[n11] * -1.0);
            }
            int n12 = fArray.length / 2;
            fArray[n12] = fArray[n12] + 2.0f;
        }
        return new KernelJAI(n, n, fArray);
    }
}

