/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

public class Rational {
    public long num;
    public long denom;
    private static final int MAX_TERMS = 8;

    public Rational(long l2, long l3) {
        this.num = l2;
        this.denom = l3;
    }

    public Rational(Rational rational) {
        this.num = rational.num;
        this.denom = rational.denom;
    }

    public final void add(long l2) {
        this.num += l2 * this.denom;
        this.normalize();
    }

    public final void add(Rational rational) {
        this.num = this.num * rational.denom + rational.num * this.denom;
        this.denom *= rational.denom;
        this.normalize();
    }

    public static final Rational approximate(double d2, double d3) {
        double d4 = d2;
        long[] lArray = new long[8];
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            long l2 = (long)Math.floor(d4);
            lArray[n++] = l2;
            if ((d4 -= (double)l2) == 0.0) break;
            d4 = 1.0 / d4;
            ++n2;
        }
        Rational rational = null;
        int n3 = 1;
        while (n3 <= n) {
            rational = Rational.createFromFrac(lArray, n3);
            if (Math.abs(rational.doubleValue() - d2) < d3) {
                return rational;
            }
            ++n3;
        }
        return rational;
    }

    public static final Rational approximate(float f2, float f3) {
        float f4 = f2;
        long[] lArray = new long[8];
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = (int)Math.floor(f4);
            lArray[n++] = n3;
            if ((f4 -= (float)n3) == 0.0f) break;
            f4 = 1.0f / f4;
            ++n2;
        }
        Rational rational = null;
        int n4 = 1;
        while (n4 <= n) {
            rational = Rational.createFromFrac(lArray, n4);
            if (Math.abs(rational.floatValue() - f2) < f3) {
                return rational;
            }
            ++n4;
        }
        return rational;
    }

    public static final int ceil(long l2, long l3) {
        int n;
        if (l2 > 0L) {
            n = (int)(l2 / l3);
            if (l2 % l3 != 0L) {
                ++n;
            }
        } else {
            n = (int)(l2 / l3);
        }
        return n;
    }

    public static final Rational createFromFrac(long[] lArray, int n) {
        Rational rational = new Rational(0L, 1L);
        int n2 = n - 1;
        while (n2 >= 0) {
            rational.add(lArray[n2]);
            if (n2 != 0) {
                rational.invert();
            }
            --n2;
        }
        return rational;
    }

    public final double doubleValue() {
        return (double)this.num / (double)this.denom;
    }

    public final float floatValue() {
        return (float)this.num / (float)this.denom;
    }

    public static final int floor(long l2, long l3) {
        int n = (int)(l2 / l3);
        if (l2 < 0L) {
            --n;
        }
        return n;
    }

    private static long gcd(long l2, long l3) {
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l3 < 0L) {
            l3 = -l3;
        }
        while (l3 > 0L) {
            long l4 = l2 % l3;
            l2 = l3;
            l3 = l4;
        }
        return l2;
    }

    public final void invert() {
        long l2 = this.num;
        this.num = this.denom;
        this.denom = l2;
    }

    public static final void main(String[] stringArray) {
        float f2 = Float.parseFloat(stringArray[0]);
        int n = 1;
        while (n < 15) {
            Rational rational = Rational.approximate(f2, (float)Math.pow(10.0, -n));
            System.out.println(String.valueOf(String.valueOf(rational)) + " = " + rational.floatValue());
            ++n;
        }
    }

    public final void multiply(long l2) {
        this.num *= l2;
        this.normalize();
    }

    public final void multiply(Rational rational) {
        this.num *= rational.num;
        this.denom *= rational.denom;
        this.normalize();
    }

    private void normalize() {
        long l2;
        if (this.denom < 0L) {
            this.num = -this.num;
            this.denom = -this.denom;
        }
        if ((l2 = Rational.gcd(this.num, this.denom)) > 1L) {
            this.num /= l2;
            this.denom /= l2;
        }
    }

    public final void subtract(long l2) {
        this.num -= l2 * this.denom;
        this.normalize();
    }

    public final void subtract(Rational rational) {
        this.num = this.num * rational.denom - rational.num * this.denom;
        this.denom *= rational.denom;
        this.normalize();
    }

    public final String toString() {
        return String.valueOf(this.num) + "/" + this.denom;
    }
}

