/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import java.io.File;
import java.util.Map;

public class AlgMap {
    public static final String getExcludeName(Map map) {
        return AlgMap.getParam("EXCLUDE_NAME", map);
    }

    public static final File getDir(Map map) {
        return new File(AlgMap.getParam("DIR", map));
    }

    public static final int getTopX(Map map) {
        return AlgMap.getParam("TOP_X", map, 10);
    }

    public static final int getBotX(Map map) {
        return AlgMap.getParam("BOT_X", map, 10);
    }

    public static final String[] getColNames(Map map) {
        return AlgMap.getParamArr("COL_NAMES", map);
    }

    public static final String[] getRowNames(Map map) {
        return AlgMap.getParamArr("ROW_NAMES", map);
    }

    public static final boolean isUp(Map map) {
        return AlgMap.getParamReqd("UP", map);
    }

    public static final boolean isDown(Map map) {
        return AlgMap.getParamReqd("DOWN", map);
    }

    public static final boolean isMedian(Map map) {
        return AlgMap.getParam("USE_MEDIAN", map, true);
    }

    public static final boolean isMean(Map map) {
        return !AlgMap.getParam("USE_MEDIAN", map, true);
    }

    public static final boolean isBiased(Map map) {
        return AlgMap.getParam("USE_BIASED", map, false);
    }

    public static final boolean isFixLowVar(Map map) {
        return AlgMap.getParam("FIX_LOW", map, true);
    }

    public static final String getMedianOrMeanLabel(Map map) {
        boolean bl = AlgMap.getParam("USE_MEDIAN", map, true);
        if (bl) {
            return "median";
        }
        return "mean";
    }

    private static boolean getParamReqd(String string, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("No defaults params null");
        }
        if (map.get(string) != null) {
            return (Boolean)map.get(string);
        }
        throw new IllegalArgumentException("No defaults unspecified value for: " + string);
    }

    private static String getParam(String string, Map map) {
        if (map == null) {
            return null;
        }
        if (map.get(string) != null) {
            return (String)map.get(string);
        }
        return null;
    }

    private static boolean getParam(String string, Map map, boolean bl) {
        if (map == null) {
            return bl;
        }
        boolean bl2 = bl;
        if (map.get(string) != null) {
            bl2 = (Boolean)map.get(string);
        }
        return bl2;
    }

    private static int getParam(String string, Map map, int n) {
        if (map == null) {
            return n;
        }
        int n2 = n;
        if (map.get(string) != null) {
            n2 = (Integer)map.get(string);
        }
        return n2;
    }

    private static String[] getParamArr(String string, Map map) {
        if (map == null) {
            return null;
        }
        if (map.get(string) != null) {
            return (String[])map.get(string);
        }
        return null;
    }
}

