/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import java.util.ArrayList;
import java.util.List;

public class DatasetBuilder {
    public String fName;
    public List fRows;
    public List fRowNames;
    public List fRowDescs;
    public List fColNames;
    public boolean fDoneBuilding;

    public DatasetBuilder(String string, List list) {
        if (string == null) {
            throw new IllegalArgumentException("Name param cant be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("colanmes param cant be null");
        }
        this.fName = string;
        this.fDoneBuilding = false;
        this.fColNames = new ArrayList(list);
        this.fRowNames = new ArrayList();
        this.fRows = new ArrayList();
        this.fRowDescs = new ArrayList();
    }

    public final void addRow(int n, Dataset dataset) {
        this.checkBuild();
        this.fRows.add(dataset.getRow(n));
        this.fRowNames.add(dataset.getRowName(n));
    }

    public final void addRow(String string, Vector vector) {
        this.checkBuild();
        this.fRows.add(vector);
        this.fRowNames.add(string);
    }

    public final void addRow(String string, String string2, Vector vector) {
        if (this.fRowNames.size() != this.fRowDescs.size()) {
            throw new IllegalStateException("RowNames:" + this.fRowNames.size() + "  and RowDescs: " + this.fRowDescs.size() + "  arent in synch");
        }
        this.addRow(string, vector);
        this.fRowDescs.add(string2);
    }

    public final Dataset generate(Annot annot) {
        Matrix matrix = new Matrix(this.fRows.size(), this.fColNames.size());
        for (int i2 = 0; i2 < this.fRows.size(); ++i2) {
            matrix.setRow(i2, (Vector)this.fRows.get(i2));
        }
        DefaultDataset defaultDataset = new DefaultDataset(this.fName, matrix, this.fRowNames, this.fColNames, true, annot);
        this.fDoneBuilding = true;
        return defaultDataset;
    }

    private void checkBuild() {
        if (this.fDoneBuilding) {
            throw new RuntimeException("Already done building -- DatasetBuilder cannot be reused");
        }
    }
}

