/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RankingMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.RankedListDbImpl;
import edu.mit.broad.genome.objects.RankedListDbSimple;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.genome.objects.TemplateCohort$Comp;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RankedListGenerators {
    private static final Logger klog = XLogger.getLogger(RankedListGenerators.class);

    private RankedListGenerators() {
    }

    public static final RankedListDb createRdb(Dataset dataset, SortMode sortMode, Order order) {
        RankedList[] rankedListArray = new RankedList[dataset.getNumCol()];
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            rankedListArray[i2] = dataset.getColumnRL(i2, sortMode, order);
        }
        return new RankedListDbSimple(dataset.getName(), null, null, rankedListArray);
    }

    public static final RankedListDb createRdb(String string, Dataset dataset, TemplateCohort templateCohort) {
        RankedList[] rankedListArray = new RankedList[templateCohort.getNumComps()];
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        for (int i2 = 0; i2 < templateCohort.getNumComps(); ++i2) {
            TemplateCohort$Comp templateCohort$Comp = templateCohort.getComp(i2);
            DatasetTemplate datasetTemplate = templateCohort$Comp.createDatasetTemplate(dataset);
            Template template = datasetTemplate.getTemplate();
            if (!template.getClass(0).getName().equals(templateCohort$Comp.getClassAShortName())) {
                throw new IllegalArgumentException("Mismatched classes: t: <" + template.getClass(0).getName() + "< >" + template.getClass(1).getName() + "> comp: >" + templateCohort$Comp.getClassAShortName() + "< >" + templateCohort$Comp.getClassBShortName() + "<");
            }
            klog.debug("OK classes: t: <" + template.getClass(0).getName() + "< >" + template.getClass(1).getName() + "> comp: >" + templateCohort$Comp.getClassAShortName() + "< >" + templateCohort$Comp.getClassBShortName() + "<");
            rankedListArray[i2] = datasetMetrics.scoreDataset(datasetTemplate).cloneShallowRL(templateCohort$Comp.getName());
            if (i2 % 5 == 0) {
                System.out.println("Done rl: " + (i2 + 1) + " / " + templateCohort.getNumComps());
            }
            klog.debug("@@@ >" + templateCohort$Comp.getClassAShortName() + "< >" + datasetTemplate.getTemplate().getClass(0).getName() + "<");
            System.out.println("Done RL: " + rankedListArray[i2].getName() + " " + (i2 + 1) + " / " + rankedListArray.length);
        }
        AnnotImpl annotImpl = new AnnotImpl(dataset.getAnnot().getFeatureAnnot(), templateCohort.getSampleAnnot());
        return new RankedListDbImpl(string, rankedListArray, dataset.getAnnot().getChip(), annotImpl, dataset, templateCohort);
    }

    public static final RankedListDb createRdb_random(String string, Dataset dataset, TemplateCohort$Comp templateCohort$Comp, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, int n) {
        RankedList[] rankedListArray = new RankedList[n];
        DatasetTemplate datasetTemplate = templateCohort$Comp.createDatasetTemplate(dataset);
        Template[] templateArray = TemplateFactoryRandomizer.createRandomTemplates(n, datasetTemplate.getTemplate(), templateRandomizerType, randomSeedGenerator);
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        for (int i2 = 0; i2 < n; ++i2) {
            rankedListArray[i2] = datasetMetrics.scoreDataset(datasetTemplate.getDataset(), templateArray[i2]).cloneShallowRL(templateCohort$Comp.getName() + "_rnd_" + i2);
            if (i2 % 10 != 0) continue;
            System.out.println("Done rl: " + (i2 + 1) + " / " + n);
        }
        return new RankedListDbSimple(string, null, dataset, rankedListArray);
    }

    public static final RankedList[] createSortedLists(Dataframe dataframe, RankingMode rankingMode) {
        klog.info("Using sort mode: " + rankingMode.getName());
        RankedList[] rankedListArray = new RankedList[dataframe.getNumCol()];
        for (int i2 = 0; i2 < dataframe.getNumCol(); ++i2) {
            LabelledVector labelledVector;
            TFloatArrayList tFloatArrayList = new TFloatArrayList();
            TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Vector vector = dataframe.getColumn(i2);
            for (int i3 = 0; i3 < vector.getSize(); ++i3) {
                if (vector.getElement(i3) >= 0.0f) {
                    tFloatArrayList.add(vector.getElement(i3));
                    arrayList.add(dataframe.getRowName(i3));
                    continue;
                }
                tFloatArrayList2.add(vector.getElement(i3));
                arrayList2.add(dataframe.getRowName(i3));
            }
            if (rankingMode == RankingMode.POSITIVE_ONLY) {
                labelledVector = new LabelledVector(dataframe.getColumnName(i2), arrayList, tFloatArrayList);
                rankedListArray[i2] = labelledVector.sort(SortMode.REAL, Order.DESCENDING);
                continue;
            }
            if (rankingMode == RankingMode.NEGATIVE_ONLY) {
                labelledVector = new LabelledVector(dataframe.getColumnName(i2), arrayList2, tFloatArrayList2);
                rankedListArray[i2] = labelledVector.sort(SortMode.REAL, Order.ASCENDING);
                continue;
            }
            if (rankingMode == RankingMode.ABSOLUTE_VALUE) {
                labelledVector = new LabelledVector(dataframe.getColumnName(i2), dataframe.getRowNamesArray(), vector);
                rankedListArray[i2] = labelledVector.sort(SortMode.ABSOLUTE, Order.DESCENDING);
                continue;
            }
            if (rankingMode == RankingMode.POS_MAX2_MIN_THEN_NEG_MIN_TO_MAX) {
                throw new NotImplementedException();
            }
            if (rankingMode == RankingMode.REAL_SORT_DESC) {
                labelledVector = new LabelledVector(dataframe.getColumnName(i2), dataframe.getRowNamesArray(), vector);
                rankedListArray[i2] = labelledVector.sort(SortMode.REAL, Order.DESCENDING);
                continue;
            }
            throw new IllegalArgumentException("Unknown mode: " + rankingMode);
        }
        return rankedListArray;
    }

    public static final RankedList createRankedList(GeneSet geneSet) {
        String[] stringArray = geneSet.getMembersArray();
        float[] fArray = new float[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fArray[i2] = stringArray.length - i2;
        }
        return new DefaultRankedList(geneSet.getName(true), stringArray, fArray);
    }

    public static final RankedList[] createRankedLists(StringDataframe stringDataframe, SortMode sortMode, Order order) {
        if (stringDataframe.getNumCol() % 2 != 0) {
            throw new IllegalArgumentException("Bad sdf format: expecting 2 column pairs of name\tscore but got ncols: " + stringDataframe.getNumCol());
        }
        klog.info("Number of name-score pairs found: " + stringDataframe.getNumCol() / 2);
        RankedList[] rankedListArray = new RankedList[stringDataframe.getNumCol() / 2];
        int n = 0;
        for (int i2 = 0; i2 < stringDataframe.getNumCol(); i2 += 2) {
            rankedListArray[n++] = new LabelledVector(stringDataframe.getColumnName(i2), stringDataframe.getColumn(i2), stringDataframe.getColumnAsVector(i2 + 1, false)).sort(sortMode, order);
        }
        return rankedListArray;
    }

    public static final RankedList[] createPositiveNegativeRankedLists_ignorezeroes(RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f2 = rankedList.getScore(i2);
            String string = rankedList.getRankName(i2);
            if (f2 > 0.0f) {
                arrayList.add(string);
                tFloatArrayList.add(f2);
                continue;
            }
            if (!(f2 < 0.0f)) continue;
            arrayList2.add(string);
            tFloatArrayList2.add(f2);
        }
        return new RankedList[]{new LabelledVector(rankedList.getName() + "_pos_only", arrayList, tFloatArrayList).sort(SortMode.REAL, Order.DESCENDING), new LabelledVector(rankedList.getName() + "_neg_only", arrayList2, tFloatArrayList2).sort(SortMode.REAL, Order.ASCENDING)};
    }

    public static final RankedList createMappedRankedList(RankedList rankedList, Chip chip) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            String string;
            String string2 = rankedList.getRankName(i2);
            Gene gene = chip.getHugo(string2);
            if (gene == null || arrayList.contains(string = gene.getSymbol())) continue;
            arrayList.add(string);
            tFloatArrayList.add(rankedList.getScore(i2));
        }
        return new DefaultRankedList(rankedList.getName() + "_symbolized", arrayList, tFloatArrayList);
    }

    public static final RankedList createBySorting(RankedList rankedList, SortMode sortMode, Order order) {
        LabelledVector labelledVector = new LabelledVector(rankedList, true);
        return labelledVector.sort(sortMode, order);
    }

    public static final RankedList createBySorting(String string, String[] stringArray, float[] fArray, SortMode sortMode, Order order) {
        LabelledVector labelledVector = new LabelledVector(string, stringArray, fArray);
        return labelledVector.sort(sortMode, order);
    }

    public static final RankedList createBySorting(String string, List list, TFloatArrayList tFloatArrayList, SortMode sortMode, Order order) {
        LabelledVector labelledVector = new LabelledVector(string, list, tFloatArrayList);
        return labelledVector.sort(sortMode, order);
    }

    public static final RankedList sort(LabelledVector labelledVector, SortMode sortMode, Order order) {
        return labelledVector.sort(sortMode, order);
    }

    public static final RankedList sortByVectorAndGetRankedList(String string, Vector vector, SortMode sortMode, Order order, List list) {
        DoubleElement[] doubleElementArray = RankedListGenerators._sort(new AddressedVector(vector, true), sortMode, order);
        Vector vector2 = new Vector(doubleElementArray.length);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < doubleElementArray.length; ++i2) {
            vector2.setElement(i2, (float)doubleElementArray[i2].fValue);
            arrayList.add(list.get(doubleElementArray[i2].fIndex));
        }
        if (string == null) {
            return new DefaultRankedList(arrayList, vector2, true, true);
        }
        return new DefaultRankedList(string, arrayList, vector2, true, true);
    }

    public static final RankedList sortByVectorAndGetRankedList(Vector vector, SortMode sortMode, Order order, List list) {
        return RankedListGenerators.sortByVectorAndGetRankedList(null, vector, sortMode, order, list);
    }

    public static final RankedList sortByVectorAndGetRankedList(AddressedVector addressedVector, SortMode sortMode, Order order, List list) {
        DoubleElement[] doubleElementArray = RankedListGenerators._sort(addressedVector, sortMode, order);
        Vector vector = new Vector(doubleElementArray.length);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < doubleElementArray.length; ++i2) {
            vector.setElement(i2, (float)doubleElementArray[i2].fValue);
            arrayList.add(list.get(doubleElementArray[i2].fIndex));
        }
        return new DefaultRankedList(arrayList, vector, true, true);
    }

    public static final LabelledVector createLV(Vector vector, String[] stringArray, SortMode sortMode, Order order) {
        if (vector.getSize() != stringArray.length) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels", stringArray.length);
        }
        AddressedVector addressedVector = new AddressedVector(vector, false);
        int[] nArray = RankedListGenerators.sortByVectorAndGetAddresses(addressedVector, sortMode, order);
        Vector vector2 = new Vector(nArray.length);
        String[] stringArray2 = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            vector2.setElement(i2, addressedVector.getScore(nArray[i2]));
            stringArray2[i2] = stringArray[nArray[i2]];
        }
        return new LabelledVector(stringArray2, vector2);
    }

    public static final LabelledVector createLV(GeneSet geneSet, RankedList rankedList) {
        if (rankedList == null) {
            throw new IllegalArgumentException("Parameter corrs cannot be null");
        }
        float[] fArray = new float[geneSet.getNumMembers()];
        String[] stringArray = new String[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            stringArray[i2] = geneSet.getMember(i2);
            fArray[i2] = rankedList.getScore(stringArray[i2]);
        }
        return new LabelledVector(geneSet.getName() + "_" + rankedList.getName(), stringArray, fArray);
    }

    protected static final DoubleElement[] _sort(AddressedVector addressedVector, SortMode sortMode, Order order) {
        DoubleElement[] doubleElementArray = new DoubleElement[addressedVector.getSize()];
        for (int i2 = 0; i2 < addressedVector.getSize(); ++i2) {
            doubleElementArray[i2] = new DoubleElement(addressedVector.getAddress(i2), addressedVector.getScore(i2));
        }
        return DoubleElement.sort(sortMode, order, doubleElementArray);
    }

    public static final int[] sortByVectorAndGetAddresses(AddressedVector addressedVector, SortMode sortMode, Order order) {
        DoubleElement[] doubleElementArray = RankedListGenerators._sort(addressedVector, sortMode, order);
        return DoubleElement.indexArray(doubleElementArray);
    }

    public static final double[] sortByVectorAndGetScores(AddressedVector addressedVector, SortMode sortMode, Order order) {
        DoubleElement[] doubleElementArray = RankedListGenerators._sort(addressedVector, sortMode, order);
        return DoubleElement.valueArray(doubleElementArray);
    }

    public static final int[] sortByVectorAndGetRanks(AddressedVector addressedVector, SortMode sortMode, Order order, boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        DoubleElement[] doubleElementArray = RankedListGenerators._sort(addressedVector, sortMode, order);
        int[] nArray = new int[addressedVector.getSize()];
        for (int i2 = 0; i2 < doubleElementArray.length; ++i2) {
            nArray[i2] = doubleElementArray[i2].fIndex + n;
        }
        Printf.out(nArray);
        return nArray;
    }
}

