/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneToGeneSetMap;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.THashSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class AbstractGeneSetCohort
implements GeneSetCohort {
    protected GeneSet[] fGeneSets;
    private THashSet[] fFastSets;
    private RankedList fRankedList;
    private Map fGeneSetNameGeneSetMap;
    protected Logger log = XLogger.getLogger(AbstractGeneSetCohort.class);
    protected boolean fSilent;
    private GeneToGeneSetMap fGeneToGeneSetMap;

    protected AbstractGeneSetCohort() {
    }

    protected final void init(RankedList rankedList, GeneSet[] geneSetArray, GeneToGeneSetMap geneToGeneSetMap, boolean bl, boolean bl2) {
        if (rankedList == null) {
            throw new IllegalArgumentException("Parameter rl cannot be null");
        }
        if (geneSetArray == null) {
            throw new IllegalArgumentException("Parameter gsets cannot be null");
        }
        if (geneSetArray.length == 0) {
            this.log.warn("zero length gsets array: " + geneSetArray.length);
        }
        this.fRankedList = rankedList;
        this.fGeneSets = new GeneSet[geneSetArray.length];
        this.fFastSets = new THashSet[geneSetArray.length];
        this.fGeneSetNameGeneSetMap = new HashMap();
        this.fSilent = bl;
        boolean bl3 = false;
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            this.fGeneSets[i2] = bl2 ? geneSetArray[i2].cloneDeep(rankedList) : geneSetArray[i2];
            this.fFastSets[i2] = new THashSet(this.fGeneSets[i2].getMembers());
            this.fGeneSetNameGeneSetMap.put(this.fGeneSets[i2].getName(), this.fGeneSets[i2]);
            if (!bl3 && this.fGeneSets[i2].getNumMembers() > 0) {
                bl3 = true;
            }
            if (bl || i2 < 500 || i2 % 500 != 0) continue;
            System.out.println("GeneSetCohorted: " + (i2 + 1) + " / " + this.fGeneSets.length);
        }
        if (!bl3) {
            System.out.println("rl: " + rankedList.getName() + " \n" + rankedList.getRankedNames().subList(0, 10));
            if (geneSetArray.length > 0) {
                System.out.println("gset: " + geneSetArray[0].getMembersS());
            }
            TraceUtils.showTrace();
            this.log.warn("No hits in the ranked list to any of the gene sets!");
        }
        this.fGeneToGeneSetMap = geneToGeneSetMap == null ? GeneToGeneSetMap.generateGeneToGenesetMap(this.fGeneSets) : geneToGeneSetMap;
    }

    @Override
    public int[] genesetIndicesForGene(String string) {
        return this.fGeneToGeneSetMap.getGenesetIndicesForGene(string);
    }

    @Override
    public boolean isMember(int n, String string) {
        return this.fFastSets[n].contains(string);
    }

    @Override
    public GeneSet getGeneSet(int n) {
        return this.fGeneSets[n];
    }

    @Override
    public GeneSet getGeneSet(String string) {
        Object v = this.fGeneSetNameGeneSetMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such gene set: " + string);
        }
        return (GeneSet)v;
    }

    @Override
    public GeneSet[] getGeneSets() {
        GeneSet[] geneSetArray = new GeneSet[this.getNumGeneSets()];
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            geneSetArray[i2] = this.getGeneSet(i2);
        }
        return geneSetArray;
    }

    @Override
    public GeneSetMatrix getGeneSetMatrix(String[] stringArray) {
        GeneSet[] geneSetArray = new GeneSet[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            geneSetArray[i2] = this.getGeneSet(stringArray[i2]);
        }
        return new DefaultGeneSetMatrix("cohort_" + this.getNumLabels(), geneSetArray);
    }

    @Override
    public GeneSetMatrix getGeneSetMatrix() {
        return this.getGeneSetMatrix(this.getGeneSetNamesArray());
    }

    @Override
    public List getGeneSetNames() {
        return AlgUtils.getAllPobNamesL(this.fGeneSets, false);
    }

    @Override
    public String[] getGeneSetNamesArray() {
        List list = AlgUtils.getAllPobNamesL(this.fGeneSets, false);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public int getNumGeneSets() {
        return this.fGeneSets.length;
    }

    @Override
    public int getNumGenes(boolean bl) {
        AbstractCollection abstractCollection = bl ? new HashSet() : new ArrayList();
        for (int i2 = 0; i2 < this.fGeneSets.length; ++i2) {
            abstractCollection.addAll(this.fGeneSets[i2].getMembers());
        }
        return abstractCollection.size();
    }

    @Override
    public int getNumTrue(int n) {
        return this.fGeneSets[n].getNumMembers();
    }

    @Override
    public int getNumLabels() {
        return this.fRankedList.getSize();
    }

    @Override
    public RankedList getRankedList() {
        return this.fRankedList;
    }

    @Override
    public double getPotential(int n, boolean bl) {
        return 1.0;
    }
}

