/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.KSCore$EnrichmentScoreCohort;
import edu.mit.broad.genome.alg.gsea.KSCore$EnrichmentScoreImplSlim;
import edu.mit.broad.genome.alg.gsea.KSCore$HitIndices;
import edu.mit.broad.genome.math.BooleanVector;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import gnu.trove.TFloatArrayList;
import org.apache.log4j.Logger;

public class KSCore {
    private final Logger log = XLogger.getLogger(this.getClass());

    public final EnrichmentScore[] calculateKSScore(GeneSetCohort geneSetCohort, boolean bl) {
        KSCore$EnrichmentScoreCohort[] kSCore$EnrichmentScoreCohortArray = this.calculateKSScore_all_modes(geneSetCohort, bl, true);
        EnrichmentScore[] enrichmentScoreArray = new EnrichmentScore[kSCore$EnrichmentScoreCohortArray.length];
        for (int i2 = 0; i2 < enrichmentScoreArray.length; ++i2) {
            enrichmentScoreArray[i2] = KSCore$EnrichmentScoreCohort.access$000(kSCore$EnrichmentScoreCohortArray[i2]);
        }
        return enrichmentScoreArray;
    }

    public final EnrichmentScore[] calculateKSScore(GeneSetCohort geneSetCohort, boolean bl, boolean bl2) {
        KSCore$EnrichmentScoreCohort[] kSCore$EnrichmentScoreCohortArray = this.calculateKSScore_all_modes(geneSetCohort, bl, bl2);
        EnrichmentScore[] enrichmentScoreArray = new EnrichmentScore[kSCore$EnrichmentScoreCohortArray.length];
        for (int i2 = 0; i2 < enrichmentScoreArray.length; ++i2) {
            enrichmentScoreArray[i2] = KSCore$EnrichmentScoreCohort.access$000(kSCore$EnrichmentScoreCohortArray[i2]);
        }
        return enrichmentScoreArray;
    }

    public final KSCore$EnrichmentScoreCohort[] calculateKSScore_all_modes(GeneSetCohort geneSetCohort, boolean bl, boolean bl2) {
        float f2;
        if (geneSetCohort == null) {
            throw new IllegalArgumentException("Param gcoh cannot be null");
        }
        TFloatArrayList[] tFloatArrayListArray = null;
        int[] nArray = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray = new float[geneSetCohort.getNumGeneSets()];
        if (bl) {
            tFloatArrayListArray = new TFloatArrayList[geneSetCohort.getNumGeneSets()];
            for (int i2 = 0; i2 < geneSetCohort.getNumGeneSets(); ++i2) {
                tFloatArrayListArray[i2] = new TFloatArrayList();
            }
        }
        Vector[] vectorArray = null;
        if (bl2) {
            vectorArray = new Vector[geneSetCohort.getNumGeneSets()];
            for (int i3 = 0; i3 < geneSetCohort.getNumGeneSets(); ++i3) {
                vectorArray[i3] = new Vector(geneSetCohort.getNumLabels());
            }
        }
        KSCore$HitIndices[] kSCore$HitIndicesArray = new KSCore$HitIndices[geneSetCohort.getNumGeneSets()];
        for (int i4 = 0; i4 < geneSetCohort.getNumGeneSets(); ++i4) {
            kSCore$HitIndicesArray[i4] = new KSCore$HitIndices(geneSetCohort.getNumTrue(i4));
        }
        float[] fArray2 = new float[geneSetCohort.getNumGeneSets()];
        double[] dArray = new double[geneSetCohort.getNumGeneSets()];
        int[] nArray2 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray3 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray3 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray4 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray5 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray4 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray6 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray7 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray5 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray8 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray9 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray6 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray10 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray7 = new int[geneSetCohort.getNumGeneSets()];
        for (int i5 = 0; i5 < geneSetCohort.getNumGeneSets(); ++i5) {
            fArray2[i5] = 0.0f;
            fArray3[i5] = 0.0f;
            fArray5[i5] = 0.0f;
            fArray7[i5] = 0.0f;
            fArray9[i5] = 0.0f;
            dArray[i5] = 0.0;
            nArray2[i5] = 0;
            nArray7[i5] = -1;
        }
        RankedList rankedList = geneSetCohort.getRankedList();
        boolean bl3 = false;
        for (int i6 = 0; i6 < rankedList.getSize(); ++i6) {
            int n;
            bl3 = i6 == rankedList.getSize() - 1;
            String string = rankedList.getRankName(i6);
            f2 = rankedList.getScore(i6);
            boolean bl4 = XMath.isPositive(f2);
            int[] nArray8 = null;
            if (bl3) {
                nArray8 = new int[geneSetCohort.getNumGeneSets()];
                for (n = 0; n < nArray8.length; ++n) {
                    nArray8[n] = n;
                }
            } else {
                nArray8 = geneSetCohort.genesetIndicesForGene(string);
            }
            if (nArray8 == null) continue;
            for (n = 0; n < nArray8.length; ++n) {
                double d2;
                int n2 = nArray8[n];
                int n3 = i6 - nArray7[n2] - 1;
                if (n3 > 0) {
                    d2 = geneSetCohort.getMissPoints(n2, string);
                    if (bl2) {
                        double d3 = dArray[n2];
                        for (int i7 = nArray7[n2] + 1; i7 < i6; ++i7) {
                            vectorArray[n2].setElement(i7, d3 -= d2);
                        }
                    }
                    int n4 = n2;
                    dArray[n4] = dArray[n4] - (double)n3 * d2;
                    if ((double)Math.abs(fArray2[n2]) < Math.abs(dArray[n2])) {
                        fArray2[n2] = (float)dArray[n2];
                        nArray[n2] = i6 - 1;
                        fArray[n2] = rankedList.getScore(i6 - 1);
                    }
                }
                if (bl3 && !geneSetCohort.isMember(n, string)) {
                    int n5 = n2;
                    dArray[n5] = dArray[n5] - geneSetCohort.getMissPoints(n2, string);
                } else {
                    nArray7[n2] = i6;
                    d2 = geneSetCohort.getHitPoints(n2, string);
                    if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                        d2 = 1.0E-6;
                    }
                    int n6 = n2;
                    dArray[n6] = dArray[n6] + d2;
                    int n7 = n2;
                    int n8 = nArray2[n7];
                    nArray2[n7] = n8 + 1;
                    kSCore$HitIndicesArray[n2].hitsIndices[n8] = i6;
                    if (bl) {
                        tFloatArrayListArray[n2].add((float)dArray[n2]);
                    }
                }
                if (bl2) {
                    vectorArray[n2].setElement(i6, (float)dArray[n2]);
                }
                if ((double)Math.abs(fArray2[n2]) < Math.abs(dArray[n2])) {
                    fArray2[n2] = (float)dArray[n2];
                    nArray[n2] = i6;
                    fArray[n2] = rankedList.getScore(i6);
                }
                if (bl4) {
                    if ((double)fArray3[n2] < dArray[n2]) {
                        fArray3[n2] = (float)dArray[n2];
                        nArray3[n2] = i6;
                        fArray4[n2] = rankedList.getScore(i6);
                    }
                    if (!((double)Math.abs(fArray5[n2]) < Math.abs(dArray[n2]))) continue;
                    fArray5[n2] = (float)dArray[n2];
                    nArray4[n2] = i6;
                    fArray6[n2] = rankedList.getScore(i6);
                    continue;
                }
                if ((double)fArray7[n2] > dArray[n2]) {
                    fArray7[n2] = (float)dArray[n2];
                    nArray5[n2] = i6;
                    fArray8[n2] = rankedList.getScore(i6);
                }
                if (!((double)Math.abs(fArray9[n2]) < Math.abs(dArray[n2]))) continue;
                fArray9[n2] = (float)dArray[n2];
                nArray6[n2] = i6;
                fArray10[n2] = rankedList.getScore(i6);
            }
        }
        KSCore$EnrichmentScoreCohort[] kSCore$EnrichmentScoreCohortArray = new KSCore$EnrichmentScoreCohort[geneSetCohort.getNumGeneSets()];
        for (int i8 = 0; i8 < geneSetCohort.getNumGeneSets(); ++i8) {
            f2 = (float)XMath.mannWhitney(kSCore$HitIndicesArray[i8].hitsIndices, rankedList.getSize());
            kSCore$EnrichmentScoreCohortArray[i8] = new KSCore$EnrichmentScoreCohort(null);
            KSCore$EnrichmentScoreCohort.access$002(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray2[i8], nArray[i8], fArray[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$202(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray3[i8], nArray3[i8], fArray4[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$302(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray5[i8], nArray4[i8], fArray6[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$402(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray7[i8], nArray5[i8], fArray8[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$502(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray9[i8], nArray6[i8], fArray10[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$602(kSCore$EnrichmentScoreCohortArray[i8], f2);
            KSCore$EnrichmentScoreCohort.access$702(kSCore$EnrichmentScoreCohortArray[i8], geneSetCohort.getNumTrue(i8));
            if (bl) {
                KSCore$EnrichmentScoreCohort.access$802(kSCore$EnrichmentScoreCohortArray[i8], kSCore$HitIndicesArray[i8].hitsIndices);
                KSCore$EnrichmentScoreCohort.access$902(kSCore$EnrichmentScoreCohortArray[i8], new Vector(tFloatArrayListArray[i8]));
            }
            if (!bl2) continue;
            KSCore$EnrichmentScoreCohort.access$1002(kSCore$EnrichmentScoreCohortArray[i8], new Vector(vectorArray[i8]));
        }
        return kSCore$EnrichmentScoreCohortArray;
    }

    public final KSCore$EnrichmentScoreCohort[] calculateKSScore_all_modes_AS_ORIG(GeneSetCohort geneSetCohort, boolean bl, boolean bl2) {
        float f2;
        if (geneSetCohort == null) {
            throw new IllegalArgumentException("Param gcoh cannot be null");
        }
        TFloatArrayList[] tFloatArrayListArray = null;
        int[] nArray = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray = new float[geneSetCohort.getNumGeneSets()];
        if (bl) {
            tFloatArrayListArray = new TFloatArrayList[geneSetCohort.getNumGeneSets()];
            for (int i2 = 0; i2 < geneSetCohort.getNumGeneSets(); ++i2) {
                tFloatArrayListArray[i2] = new TFloatArrayList();
            }
        }
        Vector[] vectorArray = null;
        if (bl2) {
            vectorArray = new Vector[geneSetCohort.getNumGeneSets()];
            for (int i3 = 0; i3 < geneSetCohort.getNumGeneSets(); ++i3) {
                vectorArray[i3] = new Vector(geneSetCohort.getNumLabels());
            }
        }
        KSCore$HitIndices[] kSCore$HitIndicesArray = new KSCore$HitIndices[geneSetCohort.getNumGeneSets()];
        for (int i4 = 0; i4 < geneSetCohort.getNumGeneSets(); ++i4) {
            kSCore$HitIndicesArray[i4] = new KSCore$HitIndices(geneSetCohort.getNumTrue(i4));
        }
        float[] fArray2 = new float[geneSetCohort.getNumGeneSets()];
        double[] dArray = new double[geneSetCohort.getNumGeneSets()];
        int[] nArray2 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray3 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray3 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray4 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray5 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray4 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray6 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray7 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray5 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray8 = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray9 = new float[geneSetCohort.getNumGeneSets()];
        int[] nArray6 = new int[geneSetCohort.getNumGeneSets()];
        float[] fArray10 = new float[geneSetCohort.getNumGeneSets()];
        for (int i5 = 0; i5 < geneSetCohort.getNumGeneSets(); ++i5) {
            fArray2[i5] = 0.0f;
            fArray3[i5] = 0.0f;
            fArray5[i5] = 0.0f;
            fArray7[i5] = 0.0f;
            fArray9[i5] = 0.0f;
            dArray[i5] = 0.0;
            nArray2[i5] = 0;
        }
        RankedList rankedList = geneSetCohort.getRankedList();
        for (int i6 = 0; i6 < rankedList.getSize(); ++i6) {
            String string = rankedList.getRankName(i6);
            f2 = rankedList.getScore(i6);
            boolean bl3 = XMath.isPositive(f2);
            for (int i7 = 0; i7 < geneSetCohort.getNumGeneSets(); ++i7) {
                if (geneSetCohort.isMember(i7, string)) {
                    double d2 = geneSetCohort.getHitPoints(i7, string);
                    if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                        throw new IllegalStateException("Nan hit score for feature: " + string);
                    }
                    int n = i7;
                    dArray[n] = dArray[n] + d2;
                    int n2 = i7;
                    int n3 = nArray2[n2];
                    nArray2[n2] = n3 + 1;
                    kSCore$HitIndicesArray[i7].hitsIndices[n3] = i6;
                    if (bl) {
                        tFloatArrayListArray[i7].add((float)dArray[i7]);
                    }
                } else {
                    int n = i7;
                    dArray[n] = dArray[n] - geneSetCohort.getMissPoints(i7, string);
                }
                if (bl2) {
                    vectorArray[i7].setElement(i6, (float)dArray[i7]);
                }
                if ((double)Math.abs(fArray2[i7]) < Math.abs(dArray[i7])) {
                    fArray2[i7] = (float)dArray[i7];
                    nArray[i7] = i6;
                    fArray[i7] = rankedList.getScore(i6);
                }
                if (bl3) {
                    if ((double)fArray3[i7] < dArray[i7]) {
                        fArray3[i7] = (float)dArray[i7];
                        nArray3[i7] = i6;
                        fArray4[i7] = rankedList.getScore(i6);
                    }
                    if (!((double)Math.abs(fArray5[i7]) < Math.abs(dArray[i7]))) continue;
                    fArray5[i7] = (float)dArray[i7];
                    nArray4[i7] = i6;
                    fArray6[i7] = rankedList.getScore(i6);
                    continue;
                }
                if ((double)fArray7[i7] > dArray[i7]) {
                    fArray7[i7] = (float)dArray[i7];
                    nArray5[i7] = i6;
                    fArray8[i7] = rankedList.getScore(i6);
                }
                if (!((double)Math.abs(fArray9[i7]) < Math.abs(dArray[i7]))) continue;
                fArray9[i7] = (float)dArray[i7];
                nArray6[i7] = i6;
                fArray10[i7] = rankedList.getScore(i6);
            }
        }
        KSCore$EnrichmentScoreCohort[] kSCore$EnrichmentScoreCohortArray = new KSCore$EnrichmentScoreCohort[geneSetCohort.getNumGeneSets()];
        for (int i8 = 0; i8 < geneSetCohort.getNumGeneSets(); ++i8) {
            f2 = (float)XMath.mannWhitney(kSCore$HitIndicesArray[i8].hitsIndices, rankedList.getSize());
            kSCore$EnrichmentScoreCohortArray[i8] = new KSCore$EnrichmentScoreCohort(null);
            KSCore$EnrichmentScoreCohort.access$002(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray2[i8], nArray[i8], fArray[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$202(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray3[i8], nArray3[i8], fArray4[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$302(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray5[i8], nArray4[i8], fArray6[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$402(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray7[i8], nArray5[i8], fArray8[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$502(kSCore$EnrichmentScoreCohortArray[i8], new KSCore$EnrichmentScoreImplSlim(fArray9[i8], nArray6[i8], fArray10[i8], kSCore$EnrichmentScoreCohortArray[i8]));
            KSCore$EnrichmentScoreCohort.access$602(kSCore$EnrichmentScoreCohortArray[i8], f2);
            KSCore$EnrichmentScoreCohort.access$702(kSCore$EnrichmentScoreCohortArray[i8], geneSetCohort.getNumTrue(i8));
            if (bl) {
                KSCore$EnrichmentScoreCohort.access$802(kSCore$EnrichmentScoreCohortArray[i8], kSCore$HitIndicesArray[i8].hitsIndices);
                KSCore$EnrichmentScoreCohort.access$902(kSCore$EnrichmentScoreCohortArray[i8], new Vector(tFloatArrayListArray[i8]));
            }
            if (!bl2) continue;
            KSCore$EnrichmentScoreCohort.access$1002(kSCore$EnrichmentScoreCohortArray[i8], new Vector(vectorArray[i8]));
        }
        return kSCore$EnrichmentScoreCohortArray;
    }

    public final float[] calculateKSScores(GeneSetCohort geneSetCohort) {
        if (geneSetCohort == null) {
            throw new IllegalArgumentException("Param sets cannot be null");
        }
        float[] fArray = new float[geneSetCohort.getNumGeneSets()];
        float[] fArray2 = new float[geneSetCohort.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetCohort.getNumGeneSets(); ++i2) {
            fArray[i2] = 0.0f;
            fArray2[i2] = 0.0f;
        }
        RankedList rankedList = geneSetCohort.getRankedList();
        for (int i3 = 0; i3 < rankedList.getSize(); ++i3) {
            String string = rankedList.getRankName(i3);
            for (int i4 = 0; i4 < geneSetCohort.getNumGeneSets(); ++i4) {
                if (geneSetCohort.isMember(i4, string)) {
                    int n = i4;
                    fArray2[n] = (float)((double)fArray2[n] + geneSetCohort.getHitPoints(i4, string));
                } else {
                    int n = i4;
                    fArray2[n] = (float)((double)fArray2[n] - geneSetCohort.getMissPoints(i4, string));
                }
                if (!(Math.abs(fArray[i4]) < Math.abs(fArray2[i4]))) continue;
                fArray[i4] = fArray2[i4];
            }
        }
        return fArray;
    }

    public final BooleanVector calculateHitProfile(GeneSet geneSet, RankedList rankedList) {
        BooleanVector booleanVector = new BooleanVector(rankedList.getSize());
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            if (geneSet.isMember(rankedList.getRankName(i2))) {
                booleanVector.setElement(i2, true);
                continue;
            }
            booleanVector.setElement(i2, false);
        }
        return booleanVector;
    }
}

