/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes;
import edu.mit.broad.genome.alg.gsea.MhtModes$Base;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;

public class MhtModes$Linear
extends MhtModes$Base {
    public MhtModes$Linear() {
        super("linear_norm");
    }

    public MhtModes$Linear(EnrichmentResult[] enrichmentResultArray) {
        this();
        this.setData(enrichmentResultArray);
    }

    @Override
    public final MhtMode cloneShallow() {
        return new MhtModes$Linear();
    }

    @Override
    public final void setData(EnrichmentResult[] enrichmentResultArray) {
        super.setData(enrichmentResultArray);
        int n = MhtModes.checkAndGetNumPerms(enrichmentResultArray);
        this.fRndMatrix = new Matrix(enrichmentResultArray.length, n);
        this.fRndMatrix_mw = new Matrix(enrichmentResultArray.length, n);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (enrichmentResultArray[i2] == null) {
                throw new IllegalArgumentException("dtgs cannot be null at: " + i2);
            }
            this.fRndMatrix.setRow(i2, this.getRndNES(i2));
            this.fRndMatrix_mw.setRow(i2, this.getRndNMW(i2));
        }
    }

    @Override
    public final Vector getRndNES(int n) {
        Vector vector = this.fDtgs[n].getRndESS();
        vector.divide(this.fDtgs[n].getScore().getNumHits());
        return vector;
    }

    @Override
    public final float getRealNES(int n) {
        int n2 = this.fDtgs[n].getScore().getNumHits();
        return this.fDtgs[n].getScore().getES() / (float)n2;
    }
}

