/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.fdr.FdrAlgs;
import edu.mit.broad.genome.alg.fdr.FdrAlgs$FdrMap;
import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.alg.gsea.Norms;
import edu.mit.broad.genome.alg.gsea.Norms$Struc;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResultImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScoreImpl;
import edu.mit.broad.genome.objects.strucs.SkewCorrectedFdrStruc;
import org.apache.log4j.Logger;

public class PValueCalculatorImpls {
    private static final Logger klog = XLogger.getLogger(PValueCalculatorImpls.class);

    private static EnrichmentResult[] _calcGseaMethod(String string, EnrichmentResult[] enrichmentResultArray) {
        LabelledVector labelledVector = EdbAlgs.createRealES(enrichmentResultArray);
        Dataset dataset = EdbAlgs.createRndESDataset("some_name", enrichmentResultArray);
        klog.debug("Norm mode: " + string);
        Norms$Struc norms$Struc = Norms.normalize(string, labelledVector, dataset);
        return PValueCalculatorImpls._calcGseaMethod(labelledVector, norms$Struc.normReal, dataset, norms$Struc.normRnd, enrichmentResultArray);
    }

    private static EnrichmentResult[] _calcGseaMethod(String string, EnrichmentResult[] enrichmentResultArray, Dataset dataset) {
        LabelledVector labelledVector = EdbAlgs.createRealES(enrichmentResultArray);
        klog.debug("Norm mode: " + string);
        Norms$Struc norms$Struc = Norms.normalize(string, labelledVector, dataset);
        return PValueCalculatorImpls._calcGseaMethod(labelledVector, norms$Struc.normReal, dataset, norms$Struc.normRnd, enrichmentResultArray);
    }

    private static EnrichmentResult[] _calcGseaMethod(LabelledVector labelledVector, LabelledVector labelledVector2, Dataset dataset, Dataset dataset2, EnrichmentResult[] enrichmentResultArray) {
        klog.debug("Started calcFdrs_skewed");
        Dataset dataset3 = new DatasetGenerators().extractRows(dataset2, labelledVector.getLabels());
        DatasetModed datasetModed = new DatasetModed(dataset3, ScoreMode.POS_ONLY, SortMode.REAL, Order.DESCENDING);
        DatasetModed datasetModed2 = new DatasetModed(dataset3, ScoreMode.NEG_ONLY, SortMode.REAL, Order.ASCENDING);
        FdrAlgs$FdrMap fdrAlgs$FdrMap = FdrAlgs.calcFdrs_skewed(labelledVector, dataset, labelledVector2, datasetModed, datasetModed2, SortMode.REAL);
        klog.debug("done fdrMap");
        EnrichmentResult[] enrichmentResultArray2 = new EnrichmentResult[enrichmentResultArray.length];
        klog.debug("Started core calcFdrs in _calcGseaMethod for results: " + enrichmentResultArray.length);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string = enrichmentResultArray[i2].getGeneSetName();
            SkewCorrectedFdrStruc skewCorrectedFdrStruc = fdrAlgs$FdrMap.getFdr(string);
            float f2 = labelledVector.getScore(string);
            float f3 = labelledVector2.getScore(string);
            Vector vector = dataset.getRow(string);
            float f4 = XMath.getPValueTwoTailed_pos_neg_seperate(f2, vector);
            float f5 = XMath.getFWERTwoTailed(f3, dataset2.getMatrix());
            float f6 = skewCorrectedFdrStruc.getFdr();
            if (Float.isNaN(f6)) {
                // empty if block
            }
            if (!XMath.isSameSign(f3, f2)) {
                f6 = 1.0f;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            EnrichmentScoreImpl enrichmentScoreImpl = new EnrichmentScoreImpl(enrichmentResultArray[i2].getScore(), f3, f4, f6, f5);
            enrichmentResultArray2[i2] = new EnrichmentResultImpl(enrichmentResultArray[i2].getRankedList(), enrichmentResultArray[i2].getTemplate(), enrichmentResultArray[i2].getGeneSet(), enrichmentResultArray[i2].getChip(), enrichmentScoreImpl, enrichmentResultArray[i2].getRndESS(), skewCorrectedFdrStruc);
            if (i2 % 25 != 0) continue;
            klog.debug("Done loop: " + i2 + " / " + enrichmentResultArray.length);
        }
        klog.debug("Done core calcFdrs in _calcGseaMethod for results: " + enrichmentResultArray.length);
        return enrichmentResultArray2;
    }

    static final /* synthetic */ EnrichmentResult[] access$000(String string, EnrichmentResult[] enrichmentResultArray) {
        return PValueCalculatorImpls._calcGseaMethod(string, enrichmentResultArray);
    }

    static final /* synthetic */ EnrichmentResult[] access$100(String string, EnrichmentResult[] enrichmentResultArray, Dataset dataset) {
        return PValueCalculatorImpls._calcGseaMethod(string, enrichmentResultArray, dataset);
    }
}

