/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPermutationTest
implements PermutationTest {
    protected final Logger log = XLogger.getLogger(this.getClass());
    private Dataset fDataset;
    private Template fTemplate;
    protected int fNumMarkers;
    protected int fNumPerms;
    protected LabelledVectorProcessor fLabelledVectorProc;
    protected Metric fMetric;
    protected SortMode fSort;
    protected Order fOrder;
    protected Map fMetricParams;
    private String fName;
    public static final float[] DEFAULT_SIG_LEVELS = new float[]{0.01f, 0.05f, 0.5f};
    private TFloatArrayList fSigLevels;
    private Matrix fUpSignificanceLevelsMatrix;
    private Matrix fDnSignificanceLevelsMatrix;
    private Matrix fNmarkersUpMatrix;
    private Matrix fNmarkersDnMatrix;

    AbstractPermutationTest() {
    }

    protected final void init(String string, int n, int n2, LabelledVectorProcessor labelledVectorProcessor, Metric metric, SortMode sortMode, Order order, Map map, Dataset dataset, Template template, float[] fArray, boolean bl) {
        if (n > dataset.getNumRow()) {
            throw new IllegalArgumentException("numMarkers: " + n + " cannot be larger than dataset size: " + dataset.getNumRow());
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Param template cannot be null");
        }
        if (bl) {
            if (!metric.isCategorical()) {
                throw new StandardException("As the phenotype choosen was categorical, only categorical metrics are allowed. Got: " + metric.getName(), 1010);
            }
            if (!template.isCategorical()) {
                throw new IllegalArgumentException("Only categorical templates allowed. Got: " + template.getName());
            }
        }
        if (!bl) {
            if (!metric.isContinuous()) {
                throw new StandardException("As the phenotype choosen was continuous, only continuous class metrics are allowed. Got: " + metric.getName(), 1011);
            }
            if (!template.isContinuous()) {
                throw new IllegalArgumentException("Only continuous templates allowed. Got: " + template.getName());
            }
        }
        this.fName = string;
        this.fNumMarkers = n;
        this.fNumPerms = n2;
        this.fLabelledVectorProc = labelledVectorProcessor;
        this.fMetric = metric;
        this.fSort = sortMode;
        this.fOrder = order;
        this.fMetricParams = map;
        this.fDataset = dataset;
        this.fTemplate = template;
        this.fSigLevels = new TFloatArrayList();
        if (fArray == null || fArray.length == 0) {
            this.fSigLevels.add(DEFAULT_SIG_LEVELS);
        } else {
            this.fSigLevels.add(fArray);
        }
    }

    @Override
    public SortMode getSortMode() {
        return this.fSort;
    }

    @Override
    public Order getOrder() {
        return this.fOrder;
    }

    @Override
    public LabelledVectorProcessor getLabelledVectorProcessor() {
        return this.fLabelledVectorProc;
    }

    @Override
    public int getNumMarkers() {
        return this.fNumMarkers;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getNumPerms() {
        return this.fNumPerms;
    }

    @Override
    public Metric getMetric() {
        return this.fMetric;
    }

    @Override
    public Map getMetricParams() {
        return this.fMetricParams;
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate;
    }

    @Override
    public Dataset getDataset() {
        return this.fDataset;
    }

    @Override
    public GeneSetPair getUpandDnMarkers() {
        this.checkCalced();
        return this.getRankedList().getNamesOfUpAndDnXRanks(this.getNumMarkers());
    }

    @Override
    public float[] getSigLevels() {
        return this.fSigLevels.toNativeArray();
    }

    @Override
    public Dataset getSigLevels(boolean bl) {
        this.checkCalced();
        this.checkCalced();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumMarkers(); ++i2) {
            arrayList.add("rank_" + i2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i3 = 0; i3 < this.getSigLevels().length; ++i3) {
            arrayList2.add("sig_" + this.getSigLevels()[i3]);
        }
        if (bl) {
            return new DefaultDataset(this.getName() + "_up_rnd", this.fUpSignificanceLevelsMatrix, arrayList, arrayList2, true, null);
        }
        return new DefaultDataset(this.getName() + "_dn_rnd", this.fDnSignificanceLevelsMatrix, arrayList, arrayList2, true, null);
    }

    @Override
    public Matrix getSigLevelsMatrix(boolean bl) {
        this.checkCalced();
        if (bl) {
            return this.fUpSignificanceLevelsMatrix;
        }
        return this.fDnSignificanceLevelsMatrix;
    }

    private void checkCalced() {
        if (this.fUpSignificanceLevelsMatrix == null || this.fDnSignificanceLevelsMatrix == null) {
            throw new IllegalStateException("calcAndSetSignificanceLevels not yet called");
        }
    }

    @Override
    public Dataset getRandomScores(boolean bl) {
        this.checkCalced();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumMarkers(); ++i2) {
            arrayList.add("rank_" + i2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i3 = 0; i3 < this.getNumPerms(); ++i3) {
            arrayList2.add("perm_" + i3);
        }
        if (bl) {
            return new DefaultDataset(this.getName() + "_up_rnd_score_matrix", this.fNmarkersUpMatrix, arrayList, arrayList2, true, null);
        }
        return new DefaultDataset(this.getName() + "_dn_rnd_score_matrix", this.fNmarkersDnMatrix, arrayList, arrayList2, true, null);
    }

    protected final void calcAndSetSignificanceLevels(Matrix matrix, Matrix matrix2) {
        if (this.fNmarkersUpMatrix != null) {
            this.log.warn("Already filled markers -- refilling ...");
        }
        this.fNmarkersUpMatrix = matrix;
        this.fNmarkersDnMatrix = matrix2;
        int n = this.getSigLevels().length;
        int n2 = matrix.getNumRow();
        this.fUpSignificanceLevelsMatrix = new Matrix(matrix.getNumRow(), n);
        this.fDnSignificanceLevelsMatrix = new Matrix(matrix2.getNumRow(), n);
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            int n3;
            Vector vector = matrix.getRowV(i2);
            for (n3 = 0; n3 < n; ++n3) {
                f2 = AbstractPermutationTest._getSignificanceLevel(vector, this.fSigLevels.get(n3), this.fSort, this.fOrder);
                this.fUpSignificanceLevelsMatrix.setElement(i2, n3, f2);
            }
            vector = matrix2.getRowV(i2);
            for (n3 = 0; n3 < n; ++n3) {
                f2 = AbstractPermutationTest._getSignificanceLevel(vector, 1.0f - this.fSigLevels.get(n3), this.fSort, this.fOrder);
                this.fDnSignificanceLevelsMatrix.setElement(i2, n3, f2);
            }
        }
    }

    private static float _getSignificanceLevel(Vector vector, float f2, SortMode sortMode, Order order) {
        if (vector.getSize() == 0) {
            return Float.NaN;
        }
        vector.sort(sortMode, order);
        int n = (int)(f2 * (float)vector.getSize());
        return vector.getElement(n);
    }
}

