/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.jfreechart.editor.GenomeChartPanel;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SimpleRange;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.XChartModelFactory;
import edu.mit.broad.genome.models.XYDatasetMultiTmp;
import edu.mit.broad.genome.models.XYDatasetProxy2;
import edu.mit.broad.genome.objects.Dataset;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XChartUtils {
    private static final transient Logger klog = XLogger.getLogger(XChartUtils.class);

    private XChartUtils() {
    }

    public static final JFreeChart createHistogramChart(Dataset dataset, int n) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(dataset, n);
        return XChartUtils._createHistogramChart(dataset.getName(), histogramDataset);
    }

    public static final JFreeChart createHistogramChart(Dataset dataset, int n, float f2, float f3) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(dataset, n, (double)f2, (double)f3);
        return XChartUtils._createHistogramChart(dataset.getName(), histogramDataset);
    }

    public static final JFreeChart createHistogramChart(Dataset dataset, int n, HistogramType histogramType) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(dataset, n);
        histogramDataset.setType(histogramType);
        return XChartUtils._createHistogramChart(dataset.getName(), histogramDataset);
    }

    public static final JFreeChart createHistogramChart(Dataset dataset, int n, float f2, float f3, HistogramType histogramType) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(dataset, n, (double)f2, (double)f3);
        histogramDataset.setType(histogramType);
        return XChartUtils._createHistogramChart(dataset.getName(), histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Vector vector, int n) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(vector, n);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Vector vector, int n, float f2, float f3) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(vector, n, (double)f2, (double)f3);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Vector vector, int n, HistogramType histogramType) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(vector, n);
        histogramDataset.setType(histogramType);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Vector vector, int n, float f2, float f3, HistogramType histogramType) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(vector, n, (double)f2, (double)f3);
        histogramDataset.setType(histogramType);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Matrix matrix, int n) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(matrix, n);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    public static final JFreeChart createHistogramChart(String string, Matrix matrix, int n, float f2, float f3) {
        HistogramDataset histogramDataset = XChartModelFactory.createHistogramDataset(matrix, n, (double)f2, (double)f3);
        return XChartUtils._createHistogramChart(string, histogramDataset);
    }

    private static JFreeChart _createHistogramChart(String string, IntervalXYDataset intervalXYDataset) {
        if (intervalXYDataset == null) {
            throw new IllegalArgumentException("Param dataset cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param title cannot be null");
        }
        JFreeChart jFreeChart = ChartFactory.createHistogram(string, "foox", "fooy", intervalXYDataset, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    public static final JFreeChart lineY(String string, String string2, String string3, Vector vector) {
        XYDatasetProxy2 xYDatasetProxy2 = new XYDatasetProxy2(vector, string3);
        return ChartFactory.createXYLineChart(string, string2, string3, xYDatasetProxy2, PlotOrientation.VERTICAL, true, false, false);
    }

    public static final JFreeChart lineOneXManyY(String string, String[] stringArray, String string2, String string3, Vector[] vectorArray) {
        XYDatasetMultiTmp xYDatasetMultiTmp = new XYDatasetMultiTmp(stringArray, vectorArray);
        return ChartFactory.createXYLineChart(string, string2, string3, xYDatasetMultiTmp, PlotOrientation.VERTICAL, true, false, false);
    }

    public static final JFreeChart scatterOneXManyY(String string, String[] stringArray, String string2, String string3, Vector[] vectorArray) {
        XYDatasetMultiTmp xYDatasetMultiTmp = new XYDatasetMultiTmp(stringArray, vectorArray);
        return ChartFactory.createScatterPlot(string, string2, string3, xYDatasetMultiTmp, PlotOrientation.VERTICAL, true, false, false);
    }

    public static final JFreeChart scatterOneXManyY(String string, String[] stringArray, String string2, String string3, Vector vector, Vector[] vectorArray) {
        XYDatasetMultiTmp xYDatasetMultiTmp = new XYDatasetMultiTmp(stringArray, vector, vectorArray);
        return ChartFactory.createScatterPlot(string, string2, string3, xYDatasetMultiTmp, PlotOrientation.VERTICAL, false, false, false);
    }

    public static final JFreeChart lineY(String string, Vector vector) {
        return XChartUtils.lineY(string, "X", "Y", vector);
    }

    public static final XYPlot lineYHits(String string, String string2, String string3, Vector vector) {
        XYDatasetProxy2 xYDatasetProxy2 = new XYDatasetProxy2(vector, string3);
        NumberAxis numberAxis = new NumberAxis(string);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string2);
        numberAxis2.setTickMarksVisible(false);
        numberAxis2.setTickLabelsVisible(true);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(10);
        return new XYPlot(xYDatasetProxy2, numberAxis, numberAxis2, standardXYItemRenderer);
    }

    public static final void display(XChart xChart) {
        XChartUtils.display(xChart.getFreeChart());
    }

    public static final void display(JFreeChart jFreeChart) {
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        JFrame jFrame = new JFrame();
        jFrame.setSize(500, 500);
        jFrame.setContentPane(chartPanel);
        jFrame.setVisible(true);
    }

    public static final String getTitle(JFreeChart jFreeChart) {
        TextTitle textTitle = jFreeChart.getTitle();
        if (textTitle instanceof TextTitle) {
            return textTitle.getText();
        }
        return "Dummy title";
    }

    public static final GenomeChartPanel createPanel(XChart xChart) {
        return XChartUtils.createPanel(xChart.getFreeChart());
    }

    public static final GenomeChartPanel createPanel(JFreeChart jFreeChart) {
        GenomeChartPanel genomeChartPanel = new GenomeChartPanel(jFreeChart);
        genomeChartPanel.setGenerateToolTips(true);
        genomeChartPanel.setMouseZoomable(true);
        return genomeChartPanel;
    }

    public static final JFreeChart lineManyXOneY(String string, String string2, Vector[] vectorArray, String[] stringArray, String string3, Vector vector) {
        XChartUtils.ensureEqualSizes(vector, vectorArray);
        if (stringArray.length != vectorArray.length) {
            throw new IllegalArgumentException("Unequal lengths for xvectors: " + vectorArray.length + " and xlabels: " + stringArray);
        }
        XYSeries[] xYSeriesArray = new XYSeries[vectorArray.length];
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            xYSeriesArray[i2] = new XYSeries((Comparable)((Object)stringArray[i2]));
            for (int i3 = 0; i3 < vectorArray[i2].getSize(); ++i3) {
                xYSeriesArray[i2].add((double)vectorArray[i2].getElement(i3), vector.getElement(i3));
            }
            xYSeriesCollection.addSeries(xYSeriesArray[i2]);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.WHITE);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.LIGHT_GRAY);
        xYPlot.setDomainGridlinePaint(Color.WHITE);
        xYPlot.setRangeGridlinePaint(Color.WHITE);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setSeriesLinesVisible(0, false);
        xYLineAndShapeRenderer.setSeriesShapesVisible(1, false);
        xYPlot.setRenderer(0, xYLineAndShapeRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static final void makeYAxisLogarithmic(XChart xChart) {
        XYPlot xYPlot = xChart.getFreeChart().getXYPlot();
        NumberAxis numberAxis = new NumberAxis("range");
        xYPlot.setRangeAxis(numberAxis);
    }

    public static final void makeXAxisLogarithmic(XChart xChart) {
        XYPlot xYPlot = xChart.getFreeChart().getXYPlot();
        NumberAxis numberAxis = new NumberAxis("domain");
        xYPlot.setDomainAxis(numberAxis);
    }

    public static final JFreeChart createHistogram(String string, boolean bl, String string2, String string3, Vector vector, boolean bl2, int n, HistogramType histogramType) {
        return XChartUtils.createHistogram(string, bl, string2, string3, new String[]{string3}, new Vector[]{vector}, bl2, n, histogramType);
    }

    public static final JFreeChart createHistogram(String string, boolean bl, String string2, String string3, String[] stringArray, Vector[] vectorArray, boolean bl2, int n, HistogramType histogramType) {
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        HistogramDataset histogramDataset = new HistogramDataset();
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (Float.isNaN(f2)) {
                histogramDataset.addSeries((Comparable)((Object)stringArray[i2]), vectorArray[i2].toArrayDouble(), n);
                continue;
            }
            histogramDataset.addSeries((Comparable)((Object)stringArray[i2]), vectorArray[i2].toArrayDouble(), n, f2, f3);
        }
        histogramDataset.setType(histogramType);
        JFreeChart jFreeChart = bl2 ? ChartFactory.createXYLineChart(string, string2, string3, histogramDataset, PlotOrientation.VERTICAL, bl, bl3, bl4) : ChartFactory.createHistogram(string, "fooX", "fooY", histogramDataset, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    private static void ensureEqualSizes(Vector vector, Vector[] vectorArray) {
        int n = vector.getSize();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (vectorArray[i2].getSize() == n) continue;
            throw new IllegalArgumentException("Unequal vector sizes x: " + vector.getSize() + " yvector at: " + i2 + " size: " + vectorArray[i2].getSize());
        }
    }

    public static final Range[] createRanges(HistogramDataset histogramDataset) {
        int n = histogramDataset.getSeriesCount();
        if (n > 1) {
            throw new NotImplementedException("Not implemented for more than 1 series: " + n);
        }
        ArrayList<SimpleRange> arrayList = new ArrayList<SimpleRange>();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = histogramDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d2 = histogramDataset.getStartXValue(i2, i3);
                double d3 = histogramDataset.getEndXValue(i2, i3);
                arrayList.add(new SimpleRange(d2, d3));
            }
        }
        return arrayList.toArray(new Range[arrayList.size()]);
    }
}

