/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.io;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.io.PobFlavor;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PobTransferable
implements Transferable,
ClipboardOwner {
    private final List fPobs;
    private final List fFiles;
    private final String fPaths;
    private final Logger log = XLogger.getLogger(PobTransferable.class);

    public PobTransferable(PersistentObject persistentObject) {
        this(new PersistentObject[]{persistentObject});
    }

    public PobTransferable(PersistentObject[] persistentObjectArray) {
        if (persistentObjectArray != null) {
            this.fPobs = new ArrayList(persistentObjectArray.length);
            this.fFiles = new ArrayList(persistentObjectArray.length);
            for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
                this.fPobs.add(persistentObjectArray[i2]);
                File file = ParserFactory.getCache().getSourceFile(persistentObjectArray[i2]);
                this.fFiles.add(file);
            }
            this.fPaths = this.toPathString();
        } else {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            this.fPaths = "";
        }
    }

    public PobTransferable(Object[] objectArray) {
        if (objectArray != null) {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] instanceof File) {
                    this.fFiles.add(objectArray[i2]);
                    continue;
                }
                if (!(objectArray[i2] instanceof PersistentObject)) continue;
                PersistentObject persistentObject = (PersistentObject)objectArray[i2];
                this.fPobs.add(persistentObject);
                File file = ParserFactory.getCache().getSourceFile(persistentObject);
                this.fFiles.add(file);
            }
            this.fPaths = this.toPathString();
        } else {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            this.fPaths = "";
        }
    }

    public PobTransferable(File file) {
        this(new File[]{file});
    }

    public PobTransferable(File[] fileArray) {
        if (fileArray != null) {
            this.fPobs = new ArrayList(fileArray.length);
            this.fFiles = new ArrayList(fileArray.length);
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                this.fFiles.add(fileArray[i2]);
                try {
                    if (!DataFormat.isParsable(fileArray[i2])) continue;
                    this.fPobs.add(ParserFactory.read(fileArray[i2]));
                    continue;
                }
                catch (Exception exception) {
                    this.log.error(exception);
                }
            }
            this.fPaths = this.toPathString();
        } else {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            this.fPaths = "";
        }
    }

    @Override
    public final Object getTransferData(DataFlavor dataFlavor) {
        if (dataFlavor.equals(PobFlavor.pobListFlavor)) {
            return this.fPobs;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.fFiles;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.fPaths;
        }
        return null;
    }

    @Override
    public final DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor, PobFlavor.pobListFlavor};
    }

    @Override
    public final boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.javaFileListFlavor) || dataFlavor.equals(DataFlavor.stringFlavor) || dataFlavor.equals(PobFlavor.pobListFlavor);
    }

    @Override
    public final void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private String toPathString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.fFiles.size(); ++i2) {
            File file = (File)this.fFiles.get(i2);
            stringBuffer.append(file.getAbsolutePath()).append('\n');
        }
        return stringBuffer.toString();
    }
}

