/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;

public class BooleanVector {
    protected int elementCount;
    protected boolean[] elementData;
    private boolean fImmutable;

    public BooleanVector(int n) {
        this.elementCount = n;
        this.elementData = new boolean[n];
    }

    public BooleanVector(boolean[] blArray) {
        this(blArray.length);
        System.arraycopy(blArray, 0, this.elementData, 0, this.elementCount);
    }

    public BooleanVector(BooleanVector booleanVector) {
        this(booleanVector.elementCount, booleanVector);
    }

    public BooleanVector(int n, BooleanVector booleanVector) {
        this(n);
        System.arraycopy(booleanVector.elementData, 0, this.elementData, 0, n);
    }

    public BooleanVector(boolean[] blArray, int n) {
        this(n);
        System.arraycopy(blArray, 0, this.elementData, 0, this.elementCount);
    }

    public BooleanVector(BooleanVector booleanVector, BooleanVector booleanVector2) {
        this(new BooleanVector[]{booleanVector, booleanVector2});
    }

    public BooleanVector(BooleanVector[] booleanVectorArray) {
        int n;
        if (booleanVectorArray == null) {
            throw new IllegalArgumentException("Param vectors cannot be null");
        }
        int n2 = 0;
        for (n = 0; n < booleanVectorArray.length; ++n) {
            n2 += booleanVectorArray[n].getSize();
        }
        this.elementCount = n2;
        this.elementData = new boolean[n2];
        n = 0;
        for (int i2 = 0; i2 < booleanVectorArray.length; ++i2) {
            System.arraycopy(booleanVectorArray[i2].elementData, 0, this.elementData, n, booleanVectorArray[i2].elementCount);
            n += booleanVectorArray[i2].elementCount;
        }
    }

    public final void truncate(int n) {
        this.checkImmutable();
        if (n == this.elementCount) {
            return;
        }
        if (n > this.getSize()) {
            throw new IllegalArgumentException("Truncated size: " + n + " cannot be more than current size: " + this.getSize());
        }
        boolean[] blArray = this.elementData;
        this.elementData = new boolean[n];
        System.arraycopy(blArray, 0, this.elementData, 0, n);
        this.elementCount = n;
    }

    public final void set(boolean[] blArray) {
        this.checkImmutable();
        System.arraycopy(blArray, 0, this.elementData, 0, this.elementCount);
    }

    public final void setDirectly(boolean[] blArray) {
        this.checkImmutable();
        this.elementData = blArray;
        this.elementCount = blArray.length;
    }

    public final void set(BooleanVector booleanVector) {
        this.checkImmutable();
        System.arraycopy(booleanVector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public final int getSize() {
        return this.elementCount;
    }

    public final int getNumTrue() {
        int n = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!this.elementData[i2]) continue;
            ++n;
        }
        return n;
    }

    public final int getNumFalse() {
        int n = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (this.elementData[i2]) continue;
            ++n;
        }
        return n;
    }

    public final Vector toVector() {
        Vector vector = new Vector(this.getSize());
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (this.elementData[i2]) {
                vector.setElement(i2, 1.0f);
                continue;
            }
            vector.setElement(i2, 0.0f);
        }
        return vector;
    }

    public final int[] getTrueIndices() {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!this.elementData[i2]) continue;
            tIntArrayList.add(i2);
        }
        return tIntArrayList.toNativeArray();
    }

    public final Vector getTrueIndicesV() {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!this.elementData[i2]) continue;
            tFloatArrayList.add(i2);
        }
        return new Vector(tFloatArrayList.toNativeArray());
    }

    public final int[] getFalseIndices() {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (this.elementData[i2]) continue;
            tIntArrayList.add(i2);
        }
        return tIntArrayList.toNativeArray();
    }

    public final Vector getFalseIndicesV() {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (this.elementData[i2]) continue;
            tFloatArrayList.add(i2);
        }
        return new Vector(tFloatArrayList.toNativeArray());
    }

    public final boolean getElement(int n) {
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + "must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final boolean isTrue(int n) {
        return this.getElement(n);
    }

    public final boolean isFalse(int n) {
        return !this.getElement(n);
    }

    public final float getElementAsFloat(int n) {
        boolean bl = this.getElement(n);
        if (bl) {
            return 1.0f;
        }
        return 0.0f;
    }

    public final void setElement(int n, boolean bl) {
        this.checkImmutable();
        try {
            this.elementData[n] = bl;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i2 = 0; i2 < this.elementCount - 1; ++i2) {
            stringBuffer.append(this.elementData[i2]);
            stringBuffer.append(",");
        }
        stringBuffer.append(this.elementData[this.elementCount - 1]);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final String toString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.elementCount - 1; ++i2) {
            stringBuffer.append(this.elementData[i2]);
            stringBuffer.append(c2);
        }
        stringBuffer.append(this.elementData[this.elementCount - 1]);
        return stringBuffer.toString();
    }

    public final boolean[] toArray() {
        boolean[] blArray = new boolean[this.elementData.length];
        System.arraycopy(this.elementData, 0, blArray, 0, this.elementData.length);
        return blArray;
    }

    public static final int maxSize(BooleanVector[] booleanVectorArray) {
        int n = 0;
        for (int i2 = 0; i2 < booleanVectorArray.length; ++i2) {
            if (n >= booleanVectorArray[i2].getSize()) continue;
            n = booleanVectorArray[i2].getSize();
        }
        return n;
    }

    public final void setImmutable() {
        this.fImmutable = true;
    }

    public final boolean isImmutable() {
        return this.fImmutable;
    }

    private void checkImmutable() {
        if (this.fImmutable) {
            throw new ImmutedException();
        }
    }
}

