/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.utils.ImmutedException;
import org.apache.log4j.Logger;

public class FuzzyRange
implements Range {
    private static final Logger klog = XLogger.getLogger(FuzzyRange.class);
    private double fMin;
    private double fMax;
    private double fFuzz;
    private int fCount;
    private boolean fImmutable;

    @Override
    public final Range cloneShallow() {
        return new FuzzyRange(this.getMin(), this.getMax(), this.getFuzz());
    }

    public FuzzyRange(double d2, double d3) {
        this.init(d2, d3);
    }

    public FuzzyRange(double d2, double d3, double d4) {
        this.init(d2 - d4, d3 + d4);
        this.fFuzz = d4;
    }

    private void init(double d2, double d3) {
        if (d3 < d2) {
            throw new IllegalArgumentException("max: " + d3 + " is less than min: " + d2);
        }
        this.fMin = d2;
        this.fMax = d3;
    }

    @Override
    public final void setImmutable() {
        this.fImmutable = true;
    }

    private void checkImmutable() {
        if (this.fImmutable) {
            throw new ImmutedException();
        }
    }

    @Override
    public final void increment() {
        this.checkImmutable();
        ++this.fCount;
    }

    @Override
    public final int getCount() {
        return this.fCount;
    }

    @Override
    public final boolean isInRange(double d2) {
        return d2 >= this.fMin && d2 <= this.fMax;
    }

    @Override
    public final double getMax() {
        return this.fMax;
    }

    @Override
    public final double getMin() {
        return this.fMin;
    }

    @Override
    public final double getFuzz() {
        return this.fFuzz;
    }

    @Override
    public final double getSpread() {
        return this.fMax - this.fMin + 1.0;
    }

    @Override
    public final double getMean() {
        return (this.fMin + this.fMax) / 2.0;
    }

    @Override
    public final String getName() {
        return new StringBuffer().append(this.fMin).append(':').append(this.fMax).toString();
    }

    public final String getIntFuzzyRangeName() {
        return new StringBuffer().append((int)this.fMin).append('-').append((int)this.fMax).toString();
    }

    public final String getSummary() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Data Max: ").append(this.getMax());
        stringBuffer.append("Data Min: ").append(this.getMin());
        stringBuffer.append("Spread  : ").append(this.getSpread());
        stringBuffer.append("Fuzz  : ").append(this.getFuzz());
        stringBuffer.append("Count   :  ").append(this.getCount());
        return stringBuffer.toString();
    }
}

