/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.containers.ClassNamePair;

public class Order {
    public static final Order ASCENDING = new Order("ascending");
    public static final Order DESCENDING = new Order("descending");
    public static final Order[] ALL = new Order[]{ASCENDING, DESCENDING};
    public static final ClassNamePair[] ALL_CNP = new ClassNamePair[]{new ClassNamePair(ASCENDING.getClass(), Order.ASCENDING.fType), new ClassNamePair(DESCENDING.getClass(), Order.DESCENDING.fType)};
    private final String fType;

    private Order(String string) {
        this.fType = string;
    }

    public final int hashCode() {
        return this.fType.hashCode();
    }

    public final String toString() {
        return this.fType;
    }

    public final boolean isAscending() {
        return this.fType.equalsIgnoreCase(Order.ASCENDING.fType);
    }

    public final boolean isDescending() {
        return this.fType.equalsIgnoreCase(Order.DESCENDING.fType);
    }

    public final boolean equals(Object object) {
        return object instanceof Order && ((Order)object).fType.equals(this.fType);
    }

    public static final Order lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null dir not allowed");
        }
        if (object instanceof Order) {
            return (Order)object;
        }
        if (object instanceof String) {
            if (object.toString().equalsIgnoreCase(Order.ASCENDING.fType)) {
                return ASCENDING;
            }
            if (object.toString().equalsIgnoreCase(Order.DESCENDING.fType)) {
                return DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unable to lookup Order for: " + object);
    }
}

