/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Range;

public class SimpleRange
implements Range {
    private double fMin;
    private double fMax;
    private int fCount;
    private boolean fMutable = true;

    public SimpleRange(int n, int n2) {
        this.fMin = n;
        this.fMax = n2;
    }

    public SimpleRange(double d2, double d3) {
        this.fMin = d2;
        this.fMax = d3;
    }

    public static final String toString_counts_only(Range[] rangeArray, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            stringBuffer.append(rangeArray[i2].getCount());
            if (i2 == rangeArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final Range[] cloneShallow(Range[] rangeArray) {
        Range[] rangeArray2 = new Range[rangeArray.length];
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            rangeArray2[i2] = rangeArray[i2].cloneShallow();
        }
        return rangeArray2;
    }

    @Override
    public final Range cloneShallow() {
        return new SimpleRange(this.getMin(), this.getMax());
    }

    @Override
    public final void increment() {
        this.checkMutable();
        ++this.fCount;
    }

    @Override
    public final int getCount() {
        return this.fCount;
    }

    @Override
    public final void setImmutable() {
        this.fMutable = false;
    }

    private void checkMutable() {
        if (!this.fMutable) {
            throw new IllegalStateException("SimpleBin is not mutable");
        }
    }

    @Override
    public final double getSpread() {
        return this.fMax - this.fMin + 1.0;
    }

    @Override
    public final boolean isInRange(double d2) {
        return d2 >= this.fMin && d2 <= this.fMax;
    }

    @Override
    public final double getMin() {
        return this.fMin;
    }

    @Override
    public final double getMax() {
        return this.fMax;
    }

    @Override
    public final double getMean() {
        return (this.fMin + this.fMax) / 2.0;
    }

    @Override
    public final double getFuzz() {
        return 0.0;
    }

    @Override
    public final String getName() {
        return this.fMin + ":" + this.fMax;
    }

    public final String toString() {
        return this.getName();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }
}

