/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.AbstractXYDatasetStruc;
import edu.mit.broad.genome.models.MiscChartModels$GaddyPlotModel$1;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.vdb.chip.Chip;
import java.util.ArrayList;
import org.jfree.chart.labels.XYToolTipGenerator;

public class MiscChartModels$GaddyPlotModel
extends AbstractXYDatasetStruc {
    private Dataset fDataset;
    private Chip chip;
    private float[] fRowIndexMeanHashMap;
    private float[] fRowIndexStdDevHashMap;

    public MiscChartModels$GaddyPlotModel(Dataset dataset) {
        this.fDataset = dataset;
        this.chip = dataset.getAnnot().getChip();
        this.fRowIndexMeanHashMap = new float[dataset.getNumRow()];
        this.fRowIndexStdDevHashMap = new float[dataset.getNumRow()];
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Vector vector = dataset.getRow(i2);
            float f2 = (float)vector.mean();
            float f3 = (float)vector.stddev(true, false);
            if (d2 > (double)f2) {
                d2 = f2;
            }
            if (d3 < (double)f2) {
                d3 = f2;
            }
            if (d4 > (double)f3) {
                d4 = f3;
            }
            if (d5 < (double)f3) {
                d5 = f3;
            }
            this.fRowIndexMeanHashMap[i2] = f2;
            this.fRowIndexStdDevHashMap[i2] = f3;
        }
    }

    @Override
    public final int getItemCount(int n) {
        return this.fDataset.getNumRow();
    }

    @Override
    public final String getSeriesName(int n) {
        return this.fDataset.getName();
    }

    @Override
    public final int getSeriesCount() {
        return 1;
    }

    @Override
    public final Number getX(int n, int n2) {
        return new Float(this.fRowIndexMeanHashMap[n2]);
    }

    @Override
    public final double getXValue(int n, int n2) {
        return this.fRowIndexMeanHashMap[n2];
    }

    @Override
    public final Number getY(int n, int n2) {
        return new Float(this.fRowIndexStdDevHashMap[n2]);
    }

    @Override
    public final double getYValue(int n, int n2) {
        return this.fRowIndexStdDevHashMap[n2];
    }

    public final Dataframe getSeriesDF() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getItemCount(0));
        Matrix matrix = new Matrix(this.getItemCount(0), 2);
        for (int i2 = 0; i2 < this.getItemCount(0); ++i2) {
            arrayList.add(this.fDataset.getRowName(i2));
            matrix.setElement(i2, 0, this.getX(0, i2).floatValue());
            matrix.setElement(i2, 1, this.getY(0, i2).floatValue());
        }
        return new Dataframe(this.getSeriesName(0), matrix, arrayList, new String[]{"X", "Y"}, true, true);
    }

    public final XYToolTipGenerator createXYToolTipGenerator() {
        return new MiscChartModels$GaddyPlotModel$1(this);
    }

    static final /* synthetic */ Dataset access$000(MiscChartModels$GaddyPlotModel miscChartModels$GaddyPlotModel) {
        return miscChartModels$GaddyPlotModel.fDataset;
    }

    static final /* synthetic */ Chip access$100(MiscChartModels$GaddyPlotModel miscChartModels$GaddyPlotModel) {
        return miscChartModels$GaddyPlotModel.chip;
    }
}

