/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Template;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class TemplateModel
extends AbstractTableModel {
    private final Template fTemplate;
    private static final String[] kColNames = new String[]{"Class Name", "Class Id", "Class Count"};
    private final Logger log = XLogger.getLogger(TemplateModel.class);

    public TemplateModel(Template template) {
        this.fTemplate = template;
    }

    @Override
    public final int getColumnCount() {
        return kColNames.length;
    }

    @Override
    public final int getRowCount() {
        return this.fTemplate.getNumClasses();
    }

    @Override
    public final String getColumnName(int n) {
        return kColNames[n];
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fTemplate.getClassName(n);
        }
        if (n2 == 1) {
            return this.fTemplate.getClass(n).getItem(0).getId();
        }
        if (n2 == 2) {
            return Integer.toString(this.fTemplate.getClass(n).getSize());
        }
        this.log.warn("Unexpectedly i was asked for coln=" + n2);
        return null;
    }

    public final Class getColumnClass(int n) {
        return String.class;
    }

    public final boolean isEditable() {
        return false;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return false;
    }
}

