/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractGeneSetMatrix;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultGeneSetMatrix
extends AbstractGeneSetMatrix {
    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray) {
        this.initMatrix(string, geneSetArray);
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, boolean bl) {
        if (bl) {
            GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                geneSetArray2[i2] = geneSetArray[i2].cloneShallow(AuxUtils.getAuxNameOnlyNoHash(geneSetArray[i2].getName()));
            }
            this.initMatrix(string, geneSetArray2);
        } else {
            this.initMatrix(string, geneSetArray);
        }
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, int n, int n2) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet geneSet = geneSetArray[i2];
            if (geneSet.getNumMembers() < n || geneSet.getNumMembers() > n2) continue;
            arrayList.add(geneSet);
        }
        this.initMatrix(string, arrayList.toArray(new GeneSet[arrayList.size()]));
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix[] geneSetMatrixArray, boolean bl) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            if (bl) {
                GeneSet[] geneSetArray = geneSetMatrixArray[i2].getGeneSets();
                for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                    arrayList.add(geneSetArray[i3].cloneShallow(AuxUtils.getAuxNameOnlyNoHash(geneSetArray[i3].getName())));
                }
                continue;
            }
            arrayList.addAll(geneSetMatrixArray[i2].getGeneSetsL());
        }
        this.initMatrix(string, arrayList.toArray(new GeneSet[arrayList.size()]));
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix[] geneSetMatrixArray, int n, int n2, boolean bl) {
        int n3;
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (n3 = 0; n3 < geneSetMatrixArray.length; ++n3) {
            arrayList.addAll(geneSetMatrixArray[n3].getGeneSetsL(n, n2));
        }
        if (bl) {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                FSet fSet = (FSet)arrayList.get(n3);
                String string2 = AuxUtils.getAuxNameOnlyNoHash(fSet.getName());
                arrayList.set(n3, fSet.cloneShallow(string2));
            }
        }
        this.initMatrix(string, arrayList.toArray(new GeneSet[arrayList.size()]));
    }

    public DefaultGeneSetMatrix(String string, List list) {
        this.initMatrix(string, list.toArray(new GeneSet[list.size()]));
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, RankedList[] rankedListArray) {
        this.initHere_R(string, geneSetArray, rankedListArray);
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, RankedList rankedList) {
        this.initHere_R(string, geneSetArray, new RankedList[]{rankedList});
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix geneSetMatrix, RankedList rankedList) {
        this.initHere_R(string, geneSetMatrix.getGeneSets(), new RankedList[]{rankedList});
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix geneSetMatrix, RankedList[] rankedListArray) {
        this(string, geneSetMatrix.getGeneSets(), rankedListArray);
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, Dataset[] datasetArray) {
        this.initHere_D(string, geneSetArray, datasetArray);
    }

    public DefaultGeneSetMatrix(String string, GeneSet[] geneSetArray, Dataset dataset) {
        this.initHere_D(string, geneSetArray, new Dataset[]{dataset});
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix geneSetMatrix, Dataset[] datasetArray) {
        this(string, geneSetMatrix.getGeneSets(), datasetArray);
    }

    public DefaultGeneSetMatrix(String string, GeneSetMatrix[] geneSetMatrixArray, Dataset[] datasetArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            arrayList.addAll(geneSetMatrixArray[i2].getGeneSetsL());
        }
        this.initHere_D(string, arrayList.toArray(new GeneSet[arrayList.size()]), datasetArray);
    }

    public static final DefaultGeneSetMatrix createGeneSetMatrix(String string, List list) {
        HashSet hashSet;
        String string2;
        Object object;
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = new StringTokenizer(list.get(i2).toString(), "\t");
            if (((StringTokenizer)object).countTokens() != 2) {
                throw new IllegalArgumentException("Bad format at line: " + (i2 + 1) + " expecting 2 tokens, got: " + ((StringTokenizer)object).countTokens() + " " + list.get(i2).toString());
            }
            String string3 = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, new HashSet());
            }
            hashSet = (HashSet)hashMap.get(string2);
            hashSet.add(string3);
        }
        GeneSet[] geneSetArray = new GeneSet[hashMap.size()];
        object = hashMap.keySet().iterator();
        int n = 0;
        while (object.hasNext()) {
            string2 = object.next().toString();
            hashSet = (HashSet)hashMap.get(string2);
            geneSetArray[n++] = new FSet(string2, hashSet);
        }
        return new DefaultGeneSetMatrix(string, geneSetArray);
    }

    private void initHere_D(String string, GeneSet[] geneSetArray, Dataset[] datasetArray) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (i2 == 0) {
                    geneSetArray2[i3] = geneSetArray[i3].cloneDeep();
                }
                geneSetArray2[i3] = geneSetArray2[i3].cloneDeep(datasetArray[i2]);
            }
        }
        this.initMatrix(string, geneSetArray2);
    }

    @Override
    public final GeneSetMatrix cloneShallow(String string) {
        this.setName(string);
        return this;
    }

    private void initHere_R(String string, GeneSet[] geneSetArray, RankedList[] rankedListArray) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (i2 == 0) {
                    geneSetArray2[i3] = geneSetArray[i3].cloneDeep();
                }
                geneSetArray2[i3] = geneSetArray2[i3].cloneDeep(rankedListArray[i2]);
            }
        }
        this.initMatrix(string, geneSetArray2);
    }
}

