/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.GeneSetPairImpl;

public class GeneSetMatrixPairImpl
implements GeneSetMatrixPair {
    private GeneSetMatrix gm_up;
    private GeneSetMatrix gm_dn;
    private String fName;

    public GeneSetMatrixPairImpl(String string, GeneSetPair[] geneSetPairArray) {
        this(string, GeneSetMatrixPairImpl._gm(geneSetPairArray, true), GeneSetMatrixPairImpl._gm(geneSetPairArray, false));
    }

    public GeneSetMatrixPairImpl(String string, GeneSet[] geneSetArray, GeneSet[] geneSetArray2) {
        this(string, new DefaultGeneSetMatrix("up", geneSetArray), new DefaultGeneSetMatrix("dn", geneSetArray2));
    }

    public GeneSetMatrixPairImpl(String string, GeneSetMatrix geneSetMatrix, GeneSetMatrix geneSetMatrix2) {
        if (geneSetMatrix == null) {
            throw new IllegalArgumentException("Param gm_up cannot be null");
        }
        if (geneSetMatrix2 == null) {
            throw new IllegalArgumentException("Param gm_dn cannot be null");
        }
        if (geneSetMatrix.getNumGeneSets() != geneSetMatrix2.getNumGeneSets()) {
            throw new MismatchedSizeException("gene matrix up", geneSetMatrix.getNumGeneSets(), "gene matrix down", geneSetMatrix2.getNumGeneSets());
        }
        this.fName = string;
        this.gm_up = geneSetMatrix;
        this.gm_dn = geneSetMatrix2;
    }

    public GeneSetMatrixPairImpl(GeneSetMatrix geneSetMatrix, GeneSetMatrix geneSetMatrix2) {
        this(geneSetMatrix.getName() + "_" + geneSetMatrix2.getName(), geneSetMatrix, geneSetMatrix2);
    }

    @Override
    public final String getName() {
        return this.fName;
    }

    @Override
    public final int getSize() {
        return this.gm_up.getNumGeneSets();
    }

    @Override
    public final GeneSetPair get(int n) {
        return new GeneSetPairImpl(this.getUp().getGeneSet(n), this.getDown().getGeneSet(n));
    }

    @Override
    public final GeneSetMatrix getUp() {
        return this.gm_up;
    }

    @Override
    public final GeneSetMatrix getDown() {
        return this.gm_dn;
    }

    @Override
    public final GeneSetMatrix getAll(String string) {
        return new DefaultGeneSetMatrix(string, new GeneSetMatrix[]{this.gm_up, this.gm_dn}, true);
    }

    private static GeneSetMatrix _gm(GeneSetPair[] geneSetPairArray, boolean bl) {
        GeneSet[] geneSetArray = new GeneSet[geneSetPairArray.length];
        for (int i2 = 0; i2 < geneSetPairArray.length; ++i2) {
            geneSetArray[i2] = bl ? geneSetPairArray[i2].getUp() : geneSetPairArray[i2].getDown();
        }
        String string = bl ? "up" : "dn";
        return new DefaultGeneSetMatrix(string, geneSetArray);
    }
}

