/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.GenesOfInterest$GeneList;
import edu.mit.broad.genome.objects.GenesOfInterestImpl$MyColorMap;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenesOfInterestImpl
extends AbstractObject
implements GenesOfInterest {
    private String fName;
    private GenesOfInterest$GeneList[] fGeneLists;
    private Map fGeneListNameGeneListMap;
    private GeneSetMatrix fGeneSetMatrix;
    private ColorMap$Rows fColorMap;
    private TObjectIntHashMap glNameIndexMap;
    private int fMaxNumGenes = -1;
    private static final Logger klog = XLogger.getLogger(GenesOfInterestImpl.class);

    public GenesOfInterestImpl(String string, GenesOfInterest$GeneList[] genesOfInterest$GeneListArray) {
        this.init(string, genesOfInterest$GeneListArray);
    }

    @Override
    public final String[] getMembershipNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumGeneLists(); ++i2) {
            if (!this.getGeneList(i2).isMember(string)) continue;
            arrayList.add(this.getGeneList(i2).getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public final ColorMap$Rows getAsColorMap() {
        if (this.fColorMap == null) {
            this.fColorMap = new GenesOfInterestImpl$MyColorMap(this);
        }
        return this.fColorMap;
    }

    @Override
    public final GeneSetMatrix getAsGeneSetMatrix() {
        if (this.fGeneSetMatrix == null) {
            GeneSet[] geneSetArray = new GeneSet[this.getNumGeneLists()];
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                geneSetArray[i2] = this.getGeneList(i2).toGeneSet();
            }
            this.fGeneSetMatrix = new DefaultGeneSetMatrix(this.getName(), geneSetArray);
        }
        return this.fGeneSetMatrix;
    }

    @Override
    public final GeneSet getAsOneGeneSet() {
        GeneSet geneSet = this.getAsGeneSetMatrix().getAllMemberNames_gset();
        this.log.debug("Total # of genes in GIN: " + geneSet.getNumMembers());
        return geneSet;
    }

    @Override
    public final GeneSet getAsOneGeneSet(Chip chip) {
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), chip);
        return chip2ChipMapperSymbol.map(this.getAsOneGeneSet(), false).getMappedGeneSet(true);
    }

    @Override
    public final GeneSet getGeneSet(int n, Chip chip) {
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), chip);
        return chip2ChipMapperSymbol.map(this.getGeneSet(n), false).getMappedGeneSet(true);
    }

    @Override
    public final GeneSet getGeneSet(String string, Chip chip) {
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), chip);
        return chip2ChipMapperSymbol.map(this.getGeneSet(string), false).getMappedGeneSet(true);
    }

    @Override
    public final int getMaxNumOfGenes() {
        if (this.fMaxNumGenes == -1) {
            for (int i2 = 0; i2 < this.getNumGeneLists(); ++i2) {
                if (this.getGeneList(i2).getNumGenes() <= this.fMaxNumGenes) continue;
                this.fMaxNumGenes = this.getGeneList(i2).getNumGenes();
            }
        }
        return this.fMaxNumGenes;
    }

    @Override
    public final String[] getGeneListNames() {
        return this.fGeneListNameGeneListMap.keySet().toArray(new String[this.fGeneListNameGeneListMap.size()]);
    }

    @Override
    public final GenesOfInterest$GeneList[] getGeneLists() {
        return this.fGeneLists;
    }

    @Override
    public final GeneSet[] getGeneSets() {
        GeneSet[] geneSetArray = new GeneSet[this.getNumGeneLists()];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray[i2] = this.getGeneList(i2).toGeneSet();
        }
        return geneSetArray;
    }

    @Override
    public final GeneSet[] getGeneSets_as_symbols_restricted(Chip chip) {
        GeneSet[] geneSetArray = new GeneSet[this.getNumGeneLists()];
        Set set = chip.getSymbols(Chip.OMIT_NULLS);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray[i2] = this.getGeneList(i2).toGeneSet().cloneDeep(set);
        }
        return geneSetArray;
    }

    @Override
    public final GeneSet[] getGeneSets(Chip chip) {
        GeneSet[] geneSetArray = new GeneSet[this.getNumGeneLists()];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray[i2] = this.getGeneList(i2).toGeneSet(chip);
        }
        return geneSetArray;
    }

    @Override
    public final GenesOfInterest$GeneList getGeneList(int n) {
        return this.fGeneLists[n];
    }

    @Override
    public final GeneSet getGeneSet(int n) {
        return this.fGeneLists[n].toGeneSet();
    }

    @Override
    public final GeneSet getGeneSet(String string) {
        return this.getGeneList(string).toGeneSet();
    }

    @Override
    public final int getGeneListIndex(String string) {
        if (this.glNameIndexMap == null) {
            this.glNameIndexMap = new TObjectIntHashMap();
            for (int i2 = 0; i2 < this.getNumGeneLists(); ++i2) {
                this.glNameIndexMap.put(this.getGeneList(i2), i2);
            }
        }
        return this.glNameIndexMap.get(string);
    }

    @Override
    public final GenesOfInterest$GeneList getGeneList(String string) {
        Object v = this.fGeneListNameGeneListMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such geneList: " + string);
        }
        return (GenesOfInterest$GeneList)v;
    }

    @Override
    public final boolean isGeneList(String string) {
        return this.fGeneListNameGeneListMap.containsKey(string);
    }

    @Override
    public final int getNumGeneLists() {
        return this.fGeneLists.length;
    }

    private void init(String string, GenesOfInterest$GeneList[] genesOfInterest$GeneListArray) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (genesOfInterest$GeneListArray == null) {
            throw new IllegalArgumentException("Parameter geneLists cannot be null");
        }
        this.fGeneListNameGeneListMap = new HashMap();
        for (int i2 = 0; i2 < genesOfInterest$GeneListArray.length; ++i2) {
            if (this.fGeneListNameGeneListMap.containsKey(genesOfInterest$GeneListArray[i2].getName())) {
                throw new IllegalArgumentException("Duplicate geneList: " + genesOfInterest$GeneListArray[i2].getName());
            }
            this.fGeneListNameGeneListMap.put(genesOfInterest$GeneListArray[i2].getName(), genesOfInterest$GeneListArray[i2]);
        }
        this.fName = string;
        this.fGeneLists = genesOfInterest$GeneListArray;
    }

    @Override
    public final String getQuickInfo() {
        return this.fGeneListNameGeneListMap.size() + "";
    }

    @Override
    public final String getName() {
        return FileUtils.getCrossPlatformName(this.fName);
    }
}

