/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractPreTemplate;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.PreTemplateImpl$NumPair;
import edu.mit.broad.genome.objects.PreTemplateImpl$Pair;
import edu.mit.broad.genome.objects.PreTemplateImpl$StringPair;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ClassImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ItemImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PreTemplateImpl
extends AbstractPreTemplate {
    private PreTemplateImpl$Pair[] fPairs;
    private Map fSampleNamePairMap;
    private boolean fContinuous;
    private int fNumClasses;

    public PreTemplateImpl(String string, String string2, PreTemplateImpl$Pair[] preTemplateImpl$PairArray, boolean bl) {
        super(string + "#" + string2);
        for (int i2 = 0; i2 < preTemplateImpl$PairArray.length; ++i2) {
            if (preTemplateImpl$PairArray[i2] instanceof PreTemplateImpl$NumPair && !bl) {
                throw new IllegalArgumentException("NumPair but not continuous");
            }
            if (!(preTemplateImpl$PairArray[i2] instanceof PreTemplateImpl$StringPair) || !bl) continue;
            throw new IllegalArgumentException("StringPair but continuous");
        }
        this.fPairs = preTemplateImpl$PairArray;
        this.fContinuous = bl;
        this.fSampleNamePairMap = new HashMap();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i3 = 0; i3 < preTemplateImpl$PairArray.length; ++i3) {
            if (preTemplateImpl$PairArray[i3] == null) {
                throw new IllegalArgumentException("Param pairs cannot be null at index: " + i3);
            }
            if (this.fSampleNamePairMap.containsKey(preTemplateImpl$PairArray[i3].getSampleName())) {
                throw new IllegalArgumentException("Duplicate sample names: " + preTemplateImpl$PairArray[i3].getSampleName());
            }
            this.fSampleNamePairMap.put(preTemplateImpl$PairArray[i3].getSampleName(), preTemplateImpl$PairArray[i3]);
            if (this.fContinuous) continue;
            hashSet.add(preTemplateImpl$PairArray[i3].getValue());
        }
        this.fNumClasses = this.fContinuous ? this.fSampleNamePairMap.size() : hashSet.size();
    }

    @Override
    public final int getNumClasses() {
        return this.fNumClasses;
    }

    @Override
    public final boolean isContinuous() {
        return this.fContinuous;
    }

    @Override
    public final boolean isCategorical() {
        return !this.fContinuous;
    }

    @Override
    public final boolean isAux() {
        return this.fContinuous;
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isContinuous()) {
            stringBuffer.append(this.fPairs.length).append("=>C");
        } else {
            stringBuffer.append(this.fPairs.length).append("=>").append(this.getNumClasses());
        }
        return stringBuffer.toString();
    }

    public final PreTemplateImpl$Pair[] getPairs() {
        return this.fPairs;
    }

    @Override
    public final boolean isSampleNamesFromDataset() {
        return true;
    }

    @Override
    public final Template createTemplate(Dataset dataset) {
        TemplateImpl templateImpl = new TemplateImpl(this.getName());
        boolean bl = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            String string;
            Object object;
            String string2 = dataset.getColumnName(i2);
            Object v = this.fSampleNamePairMap.get(string2);
            if (v == null) continue;
            int n = dataset.getColumnIndex(string2);
            PreTemplateImpl$Pair preTemplateImpl$Pair = (PreTemplateImpl$Pair)v;
            if (preTemplateImpl$Pair instanceof PreTemplateImpl$StringPair) {
                object = (PreTemplateImpl$StringPair)preTemplateImpl$Pair;
                string = ((PreTemplateImpl$StringPair)object).className;
            } else {
                bl = true;
                object = (PreTemplateImpl$NumPair)preTemplateImpl$Pair;
                string = ((PreTemplateImpl$NumPair)object).classValue + "";
            }
            Object v2 = hashMap.get(string);
            if (v2 != null) {
                object = (TemplateImpl$ClassImpl)v2;
            } else {
                object = new TemplateImpl$ClassImpl(string);
                hashMap.put(string, object);
                templateImpl.add((Template$Class)object);
            }
            TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string, n);
            templateImpl.add(templateImpl$ItemImpl);
            ((TemplateImpl$ClassImpl)object).add(templateImpl$ItemImpl);
        }
        templateImpl.setContinuous(bl);
        templateImpl.makeImmutable();
        return templateImpl;
    }
}

