/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.GeneSetPairImpl;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;

public class RankedList$Helper {
    public static final int[] getRanks(GeneSet geneSet, RankedList rankedList) {
        int[] nArray = new int[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            nArray[i2] = rankedList.getRank(geneSet.getMember(i2));
        }
        return nArray;
    }

    public static final Vector getRanksV(GeneSet geneSet, RankedList rankedList) {
        return new Vector(RankedList$Helper.getRanks(geneSet, rankedList));
    }

    public static final String toString(char c2, boolean bl, RankedList rankedList) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
                stringBuffer.append(rankedList.getRankName(i2)).append(c2).append(rankedList.getScore(i2)).append('\n');
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < rankedList.getSize(); ++i3) {
            stringBuffer.append(rankedList.getRankName(i3)).append('=').append(rankedList.getScore(i3)).append(c2);
        }
        return stringBuffer.toString();
    }

    public static final RankedList extract(GeneSet geneSet, RankedList rankedList) {
        DoubleElement[] doubleElementArray = new DoubleElement[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            int n = rankedList.getRank(geneSet.getMember(i2));
            doubleElementArray[i2] = new DoubleElement(i2, n);
        }
        doubleElementArray = DoubleElement.sort(SortMode.REAL, Order.ASCENDING, doubleElementArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = new Vector(doubleElementArray.length);
        for (int i3 = 0; i3 < doubleElementArray.length; ++i3) {
            String string = geneSet.getMember(doubleElementArray[i3].fIndex);
            arrayList.add(string);
            vector.setElement(i3, rankedList.getScore(string));
        }
        return new DefaultRankedList(geneSet.getName(true), arrayList, vector, true, true);
    }

    public static final RankedList extract(String[] stringArray, RankedList rankedList) {
        DoubleElement[] doubleElementArray = new DoubleElement[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n = rankedList.getRank(stringArray[i2]);
            doubleElementArray[i2] = new DoubleElement(i2, n);
        }
        doubleElementArray = DoubleElement.sort(SortMode.REAL, Order.ASCENDING, doubleElementArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = new Vector(doubleElementArray.length);
        for (int i3 = 0; i3 < doubleElementArray.length; ++i3) {
            String string = stringArray[doubleElementArray[i3].fIndex];
            arrayList.add(string);
            vector.setElement(i3, rankedList.getScore(string));
        }
        return new DefaultRankedList(rankedList.getName() + "_ex", arrayList, vector, true, true);
    }

    public static final RankedList extract(float f2, float f3, RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f4 = rankedList.getScore(i2);
            if (!(f4 <= f3) || !(f4 >= f2)) continue;
            arrayList.add(rankedList.getRankName(i2));
            tFloatArrayList.add(f4);
        }
        return new DefaultRankedList(rankedList.getName() + "_" + f2 + "_" + f3, arrayList, tFloatArrayList);
    }

    public static final int getNumScores(float f2, float f3, RankedList rankedList) {
        return RankedList$Helper.getScores_gs(f2, f3, rankedList).getNumMembers();
    }

    public static final GeneSet getScores_gs(float f2, float f3, RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f4 = rankedList.getScore(i2);
            if (!(f4 <= f3) || !(f4 >= f2)) continue;
            arrayList.add(rankedList.getRankName(i2));
        }
        return new FSet(rankedList.getName() + "_" + f2 + "_" + f3, arrayList, true);
    }

    public static final RankedList extract(List list, RankedList rankedList) {
        return RankedList$Helper.extract(list.toArray(new String[list.size()]), rankedList);
    }

    public static final RankedList extract(boolean bl, RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        String string = bl ? "pos" : "neg";
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f2 = rankedList.getScore(i2);
            if (bl && XMath.isPositive(f2)) {
                arrayList.add(rankedList.getRankName(i2));
                tFloatArrayList.add(f2);
                continue;
            }
            if (bl || !XMath.isNegative(f2)) continue;
            arrayList.add(rankedList.getRankName(i2));
            tFloatArrayList.add(f2);
        }
        return new DefaultRankedList(rankedList.getName() + "_" + string, arrayList, tFloatArrayList);
    }

    public static final RankedList extractRanked(int n, boolean bl, RankedList rankedList) {
        return rankedList.extractRanked(rankedList.getNamesOfUpOrDnXRanks(n, bl));
    }

    public static final RankedList extractRanked(int n, RankedList rankedList) {
        List list = rankedList.getNamesOfUpOrDnXRanks(n, true);
        list.addAll(rankedList.getNamesOfUpOrDnXRanks(n, false));
        return rankedList.extractRanked(list);
    }

    public static final String[] getLabelsOfUpOrDnXRanks_array(int n, boolean bl, RankedList rankedList) {
        List list = RankedList$Helper.getLabelsOfUpOrDnXRanks(n, bl, rankedList);
        return list.toArray(new String[list.size()]);
    }

    public static final GeneSet getLabelsOfUpOrDnXRanks_gs(int n, boolean bl, RankedList rankedList) {
        String string = rankedList.getName();
        string = bl ? string + "_up_" + n : string + "_dn_" + n;
        return new FSet(string, RankedList$Helper.getLabelsOfUpOrDnXRanks(n, bl, rankedList), false);
    }

    public static final GeneSetPair getLabelsOfUpAndDnXRanks(int n, RankedList rankedList) {
        return new GeneSetPairImpl(rankedList.getName(), RankedList$Helper.getLabelsOfUpOrDnXRanks_gs(n, true, rankedList), RankedList$Helper.getLabelsOfUpOrDnXRanks_gs(n, false, rankedList));
    }

    public static final List getLabelsOfUpOrDnXRanks(int n, boolean bl, RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n > rankedList.getSize()) {
            n = rankedList.getSize();
        }
        if (bl) {
            for (int i2 = 0; i2 < n; ++i2) {
                arrayList.add(rankedList.getRankName(i2));
            }
        } else {
            int n2 = rankedList.getSize() - 1;
            for (int i3 = 0; i3 < n; ++i3) {
                arrayList.add(rankedList.getRankName(n2));
                --n2;
            }
        }
        return arrayList;
    }

    public static final RankedList extractRanked(ScoreMode scoreMode, RankedList rankedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        String string = scoreMode.getName();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f2 = rankedList.getScore(i2);
            if (scoreMode.isPostiveOnly() && XMath.isPositive(f2)) {
                arrayList.add(rankedList.getRankName(i2));
                tFloatArrayList.add(f2);
                continue;
            }
            if (!scoreMode.isNegativeOnly() || !XMath.isNegative(f2)) continue;
            arrayList.add(rankedList.getRankName(i2));
            tFloatArrayList.add(f2);
        }
        return new DefaultRankedList(rankedList.getName() + "_" + string, arrayList, tFloatArrayList);
    }
}

