/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractRankedListDb;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.vdb.chip.Chip;
import java.util.ArrayList;

public class RankedListDbImpl
extends AbstractRankedListDb {
    private RankedList[] fRankedLists;

    public RankedListDbImpl(String string, RankedList[] rankedListArray, Chip chip, Annot annot, Dataset dataset, TemplateCohort templateCohort) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (rankedListArray.length > 0) {
            int n = rankedListArray[0].getSize();
            for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
                if (rankedListArray[i2].getSize() != n) {
                    throw new IllegalArgumentException("Unequal length of ranked lists: " + n + " and " + rankedListArray[i2].getSize() + " at index: " + i2 + " name: " + rankedListArray[i2].getName());
                }
                arrayList.add(rankedListArray[i2].getName());
            }
        }
        if (rankedListArray.length == 0) {
            throw new IllegalArgumentException("Zero length ranled list: " + rankedListArray);
        }
        this.fRankedLists = rankedListArray;
        super.init(string, rankedListArray[0].getRankedNames(), arrayList, chip, annot, dataset, templateCohort);
    }

    @Override
    public final RankedList getRankedList(int n) {
        return this.fRankedLists[n];
    }

    @Override
    public final RankedList getRankedList(String string) {
        return this.fRankedLists[this.getRankedListIndex(string)];
    }
}

