/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.ISet;
import edu.mit.broad.genome.objects.LabelledList;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.vdb.chip.Chip;
import java.util.Collection;
import java.util.Iterator;

final class SetHelper {
    private SetHelper() {
    }

    static final String toString(char c2, ISet iSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < iSet.getNumMembers(); ++i2) {
            stringBuffer.append(iSet.getMember(i2));
            if (i2 == iSet.getNumMembers() - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static final String toString(char c2, GeneSet geneSet, Chip chip) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
                stringBuffer.append(chip.getProbe(geneSet.getMember(i2)).getGene().getSymbol());
                if (i2 == geneSet.getNumMembers() - 1) continue;
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getMessage();
        }
    }

    static final int getNumMembers(GeneSet geneSet, Dataset dataset) {
        int n = 0;
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            if (!geneSet.isMember(dataset.getRowName(i2))) continue;
            ++n;
        }
        return n;
    }

    static final int getNumMembers(GeneSet geneSet, GeneSet geneSet2) {
        int n = 0;
        for (int i2 = 0; i2 < geneSet2.getNumMembers(); ++i2) {
            if (!geneSet.isMember(geneSet2.getMember(i2))) continue;
            ++n;
        }
        return n;
    }

    static final int getNumMembers(ISet iSet, Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!iSet.isMember(string)) continue;
            ++n;
        }
        return n;
    }

    private static final int getNumMembers(ISet iSet, GeneSet geneSet) {
        int n = 0;
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            if (!iSet.isMember(geneSet.getMember(i2))) continue;
            ++n;
        }
        return n;
    }

    static final int getNumMembers(ISet iSet, RankedList rankedList) {
        int n = 0;
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            if (!iSet.isMember(rankedList.getRankName(i2))) continue;
            ++n;
        }
        return n;
    }

    static final int getNumMembers(ISet iSet, LabelledList labelledList) {
        int n = 0;
        for (int i2 = 0; i2 < labelledList.getSize(); ++i2) {
            if (!iSet.isMember(labelledList.getLabel(i2))) continue;
            ++n;
        }
        return n;
    }
}

