/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ClassImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ItemImpl;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import org.apache.log4j.Logger;

public class TemplateFactoryRandomizer {
    private static final Logger klog = XLogger.getLogger(TemplateFactoryRandomizer.class);

    public static final Template[] createRandomTemplates(int n, Template template, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator) {
        return TemplateFactoryRandomizer.createRandomTemplates(n, template, templateRandomizerType, randomSeedGenerator, false);
    }

    public static final Template[] createRandomTemplates(int n, Template template, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, boolean bl) {
        Template[] templateArray;
        if (!bl) {
            klog.debug("TemplateRandomizerType: " + templateRandomizerType.toString());
        }
        if (templateRandomizerType == TemplateRandomizerType.NO_BALANCE) {
            templateArray = TemplateFactoryRandomizer.createRandomTemplates(n, template, randomSeedGenerator);
        } else if (templateRandomizerType == TemplateRandomizerType.BALANCED_CLASS0) {
            templateArray = TemplateFactoryRandomizer.createRandomAuxBalancedTemplates(n, template, true, randomSeedGenerator);
        } else if (templateRandomizerType == TemplateRandomizerType.BALANCED_CLASS1) {
            templateArray = TemplateFactoryRandomizer.createRandomAuxBalancedTemplates(n, template, false, randomSeedGenerator);
        } else if (templateRandomizerType == TemplateRandomizerType.EQUALIZE_AND_BALANCE) {
            templateArray = TemplateFactoryRandomizer.createRandomAuxEqualizedAndBalancedTemplates(n, template, randomSeedGenerator);
        } else {
            throw new IllegalArgumentException("Unknown RandomizerType: " + templateRandomizerType);
        }
        return templateArray;
    }

    public static final Template createRandomTemplate(Template template, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator) {
        return TemplateFactoryRandomizer.createRandomTemplate(template, templateRandomizerType, randomSeedGenerator, true);
    }

    public static final Template createRandomTemplate(Template template, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, boolean bl) {
        if (bl) {
            klog.debug("TemplateRandomizerType: " + templateRandomizerType.toString());
        }
        if (templateRandomizerType == TemplateRandomizerType.NO_BALANCE) {
            return TemplateFactoryRandomizer.createRandomTemplate(template, randomSeedGenerator);
        }
        if (templateRandomizerType == TemplateRandomizerType.BALANCED_CLASS0) {
            return TemplateFactoryRandomizer.createRandomAuxBalancedTemplate(template, true, randomSeedGenerator);
        }
        if (templateRandomizerType == TemplateRandomizerType.BALANCED_CLASS1) {
            return TemplateFactoryRandomizer.createRandomAuxBalancedTemplate(template, false, randomSeedGenerator);
        }
        if (templateRandomizerType == TemplateRandomizerType.EQUALIZE_AND_BALANCE) {
            return TemplateFactoryRandomizer.createRandomAuxEqualizedAndBalancedTemplate(template, randomSeedGenerator);
        }
        throw new IllegalArgumentException("Unknown RandomizerType: " + templateRandomizerType);
    }

    public static final Template[] createRandomTemplates(int n, Template template, RandomSeedGenerator randomSeedGenerator) {
        Template[] templateArray = new Template[n];
        for (int i2 = 0; i2 < n; ++i2) {
            templateArray[i2] = TemplateFactoryRandomizer.createRandomTemplate(template, randomSeedGenerator);
        }
        return templateArray;
    }

    public static final Template createRandomTemplate(Template template, RandomSeedGenerator randomSeedGenerator) {
        Object object;
        if (template.isContinuous()) {
            Vector vector = TemplateFactoryRandomizer.createRandomTemplateContinuousV(template, randomSeedGenerator);
            return TemplateFactory.createContinuousTemplate(template.getName(), vector);
        }
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates rnd allowed: " + template.getNumClasses());
        }
        int[] nArray = XMath.randomizeWithoutReplacement(template.getNumItems(), randomSeedGenerator);
        Template$Item[] template$ItemArray = template.getItemsOrderedByProfilePos();
        Template$Item[] template$ItemArray2 = new Template$Item[template$ItemArray.length];
        TemplateImpl templateImpl = new TemplateImpl(template.getName());
        for (int i2 = 0; i2 < template$ItemArray.length; ++i2) {
            object = template$ItemArray[i2];
            Template$Item template$Item = template$ItemArray[nArray[i2]];
            Template$Class template$Class = template.getClass(template$Item);
            template$ItemArray2[i2] = TemplateImpl$ItemImpl.createItem(template$Class.getName(), object.getProfilePosition());
            templateImpl.add(template$ItemArray2[i2]);
        }
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template.getClass(0).getName());
        object = new TemplateImpl$ClassImpl(template.getClass(1).getName());
        for (int i3 = 0; i3 < template$ItemArray2.length; ++i3) {
            if (template$ItemArray2[i3].getId().equals(templateImpl$ClassImpl.getName())) {
                templateImpl$ClassImpl.add(template$ItemArray2[i3]);
                continue;
            }
            if (template$ItemArray2[i3].getId().equals(((TemplateImpl$ClassImpl)object).getName())) {
                ((TemplateImpl$ClassImpl)object).add(template$ItemArray2[i3]);
                continue;
            }
            throw new IllegalStateException("Unknown item class: " + template$ItemArray2[i3].getId());
        }
        templateImpl.add(templateImpl$ClassImpl);
        templateImpl.add((Template$Class)object);
        templateImpl.setClassOfInterestIndex(template.getClassOfInterestIndex());
        templateImpl.setAux(template.isAux());
        templateImpl.setContinuous(false);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final Vector createRandomTemplateContinuousV(Template template, RandomSeedGenerator randomSeedGenerator) {
        if (!template.isContinuous()) {
            throw new IllegalArgumentException("Only valid to call for continuous templates");
        }
        Vector vector = new Vector(template.getNumItems());
        int[] nArray = XMath.randomizeWithoutReplacement(template.getNumItems(), randomSeedGenerator);
        int[] nArray2 = template.getProfilePositionsOrdered();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n = nArray2[nArray[i2]];
            Template$Item template$Item = template.getItemByProfilePos(n);
            vector.setElement(i2, Float.parseFloat(template$Item.getId()));
        }
        return vector;
    }

    public static final Template createRandomAuxBalancedTemplate(Template template, boolean bl, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Balanced rnd only possible for 2 class templates");
        }
        if (bl) {
            Template$Class template$Class = template.getClass(0);
            int n = template$Class.getSize() / 2;
            int n2 = template$Class.getSize() - n;
            Template$Class template$Class2 = template.getClass(1);
            return TemplateFactoryRandomizer.createRandomConstrainedTemplate(template, template$Class, n, template$Class2, n2, randomSeedGenerator);
        }
        Template$Class template$Class = template.getClass(0);
        Template$Class template$Class3 = template.getClass(1);
        int n = template$Class3.getSize() / 2;
        int n3 = template$Class.getSize() - n;
        return TemplateFactoryRandomizer.createRandomConstrainedTemplate(template, template$Class, n3, template$Class3, n, randomSeedGenerator);
    }

    public static final Template[] createRandomAuxBalancedTemplates(int n, Template template, boolean bl, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        Template[] templateArray = new Template[n];
        for (int i2 = 0; i2 < n; ++i2) {
            templateArray[i2] = TemplateFactoryRandomizer.createRandomAuxBalancedTemplate(template, bl, randomSeedGenerator);
        }
        return templateArray;
    }

    public static final Template[] createRandomAuxEqualizedAndBalancedTemplates(int n, Template template, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        Template[] templateArray = new Template[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Template$Class template$Class = template.getClass(0);
            int n2 = template$Class.getSize() / 2;
            int n3 = template$Class.getSize() - n2;
            Template$Class template$Class2 = template.getClass(1);
            templateArray[i2] = TemplateFactoryRandomizer.createRandomConstrainedTemplate(template, template$Class, n3, template$Class2, n2, randomSeedGenerator);
        }
        return templateArray;
    }

    public static final Template createRandomAuxEqualizedAndBalancedTemplate(Template template, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        int n = XMath.min(new int[]{template.getClass(0).getSize(), template.getClass(1).getSize()});
        Template template2 = TemplateFactory.createAuxConstrainedRealTemplate(template, n, n, randomSeedGenerator);
        return TemplateFactoryRandomizer.createRandomAuxBalancedTemplate(template2, true, randomSeedGenerator);
    }

    public static final Template createRandomConstrainedTemplate(Template template, Template$Class template$Class, int n, Template$Class template$Class2, int n2, RandomSeedGenerator randomSeedGenerator) {
        TemplateImpl$ItemImpl templateImpl$ItemImpl;
        Template$Item template$Item;
        int n3;
        TemplateImpl$ItemImpl templateImpl$ItemImpl2;
        Object object;
        int n4;
        if (n > template$Class.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0:   cannot be larger than size of templateclass 0: " + template$Class.getSize());
        }
        if (n2 > template$Class2.getSize()) {
            throw new IllegalArgumentException("numFromC1inC0: " + n2 + " cannot be larger than size of templateclass 1: " + template$Class2.getSize());
        }
        if (n + n2 != template$Class.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0 + numFromC1inC0: " + (n + n2) + " not equal to size of class0: " + template$Class.getSize());
        }
        int[] nArray = XMath.randomizeWithoutReplacement(template$Class.getSize(), randomSeedGenerator);
        TemplateImpl templateImpl = new TemplateImpl(template.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl(template$Class2.getName());
        String string = template$Class.getItem(0).getId();
        String string2 = template$Class2.getItem(0).getId();
        for (n4 = 0; n4 < n; ++n4) {
            object = template$Class.getItem(nArray[n4]);
            templateImpl$ItemImpl2 = TemplateImpl$ItemImpl.createItem(string, object.getProfilePosition());
            templateImpl$ClassImpl.add(templateImpl$ItemImpl2);
            templateImpl.add(templateImpl$ItemImpl2);
        }
        while (n4 < nArray.length) {
            object = template$Class.getItem(nArray[n4]);
            templateImpl$ItemImpl2 = TemplateImpl$ItemImpl.createItem(string2, object.getProfilePosition());
            templateImpl$ClassImpl2.add(templateImpl$ItemImpl2);
            templateImpl.add(templateImpl$ItemImpl2);
            ++n4;
        }
        object = XMath.randomizeWithoutReplacement(template$Class2.getSize(), randomSeedGenerator);
        for (n3 = 0; n3 < n2; ++n3) {
            template$Item = template$Class2.getItem((int)object[n3]);
            templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string, template$Item.getProfilePosition());
            templateImpl$ClassImpl.add(templateImpl$ItemImpl);
            templateImpl.add(templateImpl$ItemImpl);
        }
        while (n3 < ((Object)object).length) {
            template$Item = template$Class2.getItem((int)object[n3]);
            templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string2, template$Item.getProfilePosition());
            templateImpl$ClassImpl2.add(templateImpl$ItemImpl);
            templateImpl.add(templateImpl$ItemImpl);
            ++n3;
        }
        templateImpl.add(templateImpl$ClassImpl);
        templateImpl.add(templateImpl$ClassImpl2);
        templateImpl.setClassOfInterestIndex(template.getClassOfInterestIndex());
        if (template.isAux()) {
            templateImpl.setAux(true);
        }
        if (template.isContinuous()) {
            templateImpl.setContinuous(true);
        }
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final Template createRandomConstrainedTemplate_ORIG(Template template, Template$Class template$Class, int n, Template$Class template$Class2, int n2, RandomSeedGenerator randomSeedGenerator) {
        TemplateImpl$ItemImpl templateImpl$ItemImpl;
        Template$Item template$Item;
        int n3;
        TemplateImpl$ItemImpl templateImpl$ItemImpl2;
        Object object;
        int n4;
        if (n > template$Class.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0:   cannot be larger than size of templateclass 0: " + template$Class.getSize());
        }
        if (n2 > template$Class2.getSize()) {
            throw new IllegalArgumentException("numFromC1inC0: " + n2 + " cannot be larger than size of templateclass 1: " + template$Class2.getSize());
        }
        if (n + n2 != template$Class.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0 + numFromC1inC0: " + (n + n2) + " not equal to size of class0: " + template$Class.getSize());
        }
        int[] nArray = XMath.randomizeWithoutReplacement(template$Class.getSize(), randomSeedGenerator);
        TemplateImpl templateImpl = new TemplateImpl(template.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl(template$Class2.getName());
        String string = template$Class.getItem(0).getId();
        String string2 = template$Class2.getItem(0).getId();
        for (n4 = 0; n4 < n; ++n4) {
            object = template$Class.getItem(nArray[n4]);
            templateImpl$ItemImpl2 = TemplateImpl$ItemImpl.createItem(string, object.getProfilePosition());
            templateImpl$ClassImpl.add(templateImpl$ItemImpl2);
            templateImpl.add(templateImpl$ItemImpl2);
        }
        while (n4 < nArray.length) {
            object = template$Class.getItem(nArray[n4]);
            templateImpl$ItemImpl2 = TemplateImpl$ItemImpl.createItem(string2, object.getProfilePosition());
            templateImpl$ClassImpl2.add(templateImpl$ItemImpl2);
            templateImpl.add(templateImpl$ItemImpl2);
            ++n4;
        }
        object = XMath.randomizeWithoutReplacement(template$Class2.getSize(), randomSeedGenerator);
        for (n3 = 0; n3 < n2; ++n3) {
            template$Item = template$Class2.getItem((int)object[n3]);
            templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string, template$Item.getProfilePosition());
            templateImpl$ClassImpl.add(templateImpl$ItemImpl);
            templateImpl.add(templateImpl$ItemImpl);
        }
        while (n3 < ((Object)object).length) {
            template$Item = template$Class2.getItem((int)object[n3]);
            templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string2, template$Item.getProfilePosition());
            templateImpl$ClassImpl2.add(templateImpl$ItemImpl);
            templateImpl.add(templateImpl$ItemImpl);
            ++n3;
        }
        templateImpl.add(templateImpl$ClassImpl);
        templateImpl.add(templateImpl$ClassImpl2);
        templateImpl.setClassOfInterestIndex(template.getClassOfInterestIndex());
        if (template.isAux()) {
            templateImpl.setAux(true);
        }
        if (template.isContinuous()) {
            templateImpl.setContinuous(true);
        }
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final Template[] createRandomConstrainedTemplates(int n, Template template, int n2, int n3, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates implemented");
        }
        Template[] templateArray = new Template[n];
        for (int i2 = 0; i2 < n; ++i2) {
            templateArray[i2] = TemplateFactoryRandomizer.createRandomConstrainedTemplate(template, template.getClass(0), n2, template.getClass(1), n3, randomSeedGenerator);
        }
        return templateArray;
    }
}

