/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.DatasetWrapper;
import edu.mit.broad.genome.objects.strucs.TemplateWrapper;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.utils.FileUtils;
import java.io.File;

public class DatasetTemplate
implements DatasetWrapper,
TemplateWrapper {
    private Dataset fDataset;
    private Template fTemplate;
    private File fDatasetFile;
    private File fTemplateFile;
    private boolean fAdd2Cache;
    private GeneSet fGeneSpace;
    private File fGeneSpaceFile;

    public DatasetTemplate(Dataset dataset, Template template) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Param t cannot be null");
        }
        this.fDataset = dataset;
        this.fTemplate = template;
    }

    public DatasetTemplate(Dataset dataset, Template template, GeneSet geneSet) {
        this(dataset, template);
        this.fGeneSpace = geneSet;
    }

    public DatasetTemplate(File file, File file2, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("Param dsFile cannot be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Param tFile cannot be null");
        }
        this.fDatasetFile = file;
        this.fTemplateFile = file2;
        this.fAdd2Cache = bl;
    }

    public DatasetTemplate(File file, File file2, boolean bl, File file3) {
        this(file, file2, bl);
        this.fGeneSpaceFile = file3;
    }

    public final String getName() {
        String string = FileUtils.removeExtension(this.getDatasetName());
        return NamingConventions.createSafeFileName(string + "_" + AuxUtils.getAuxNameOnlyNoHash(this.getTemplate()));
    }

    @Override
    public final String getDatasetName() {
        if (this.fDataset != null) {
            return this.fDataset.getName();
        }
        return NamingConventions.removeExtension(this.fDatasetFile.getName());
    }

    public final File getDatasetFile() {
        if (this.fDatasetFile == null) {
            this.fDatasetFile = ParserFactory.getCache().getSourceFile(this.fDataset);
        }
        return this.fDatasetFile;
    }

    public final File getTemplateFile() {
        if (this.fTemplateFile == null) {
            this.fTemplateFile = ParserFactory.getCache().getSourceFile(this.fTemplate);
        }
        return this.fTemplateFile;
    }

    @Override
    public final String getTemplateName() {
        if (this.fTemplate != null) {
            return this.fTemplate.getName();
        }
        return NamingConventions.removeExtension(this.fTemplateFile.getName());
    }

    @Override
    public final Dataset getDataset(boolean bl) {
        if (this.fDataset == null) {
            try {
                this.fDataset = ParserFactory.readDataset(this.fDatasetFile, bl, bl);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (this.fGeneSpace != null) {
            return new DatasetGenerators().extractRows(this.fDataset, this.fGeneSpace);
        }
        if (this.fGeneSpaceFile != null) {
            try {
                this.fGeneSpace = ParserFactory.readGeneSet(this.fGeneSpaceFile, false);
                return new DatasetGenerators().extractRows(this.fDataset, this.fGeneSpace);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return this.fDataset;
    }

    @Override
    public final Dataset getDataset() {
        return this.getDataset(this.fAdd2Cache);
    }

    @Override
    public final Template getTemplate() {
        if (this.fTemplate == null) {
            try {
                this.fTemplate = ParserFactory.readTemplate(this.fTemplateFile, this.fAdd2Cache, this.fAdd2Cache);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return this.fTemplate;
    }

    public static final Dataset[] toDatasets(DatasetTemplate[] datasetTemplateArray, boolean bl) {
        Dataset[] datasetArray = new Dataset[datasetTemplateArray.length];
        for (int i2 = 0; i2 < datasetTemplateArray.length; ++i2) {
            datasetArray[i2] = datasetTemplateArray[i2].getDataset(bl);
        }
        return datasetArray;
    }

    @Override
    public final String getPath() {
        throw new NotImplementedException();
    }

    @Override
    public final File getFile() {
        throw new NotImplementedException();
    }
}

