/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.ObjectMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.esmatrix.db.DtgDataset;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DtgDatasetParser
extends AbstractParser {
    public DtgDatasetParser() {
        super(DtgDataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        DtgDataset dtgDataset = (DtgDataset)persistentObject;
        this.export(dtgDataset, printWriter);
        this.doneExport();
    }

    public final void export(DtgDataset dtgDataset, PrintWriter printWriter) {
        int n;
        printWriter.print("NAME\t");
        for (n = 0; n < dtgDataset.getNumCol(); ++n) {
            printWriter.print(dtgDataset.getColName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dtgDataset.getNumRow(); ++n) {
            printWriter.print(dtgDataset.getRowName(n));
            printWriter.print('\t');
            for (int i2 = 0; i2 < dtgDataset.getNumCol(); ++i2) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(dtgDataset.getRealEs(n, i2)).append(',');
                stringBuffer.append(dtgDataset.getNes(n, i2)).append(',');
                stringBuffer.append(dtgDataset.getNominalPValue(n, i2)).append(',');
                stringBuffer.append(dtgDataset.getDiscoveryPValue(n, i2)).append(',');
                stringBuffer.append(dtgDataset.getValidationPValue(n, i2));
                stringBuffer.append('\t');
                printWriter.print(stringBuffer.toString());
            }
            printWriter.println();
        }
        printWriter.close();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        DtgDataset dtgDataset = this.parse(string, bufferedReader);
        return DtgDatasetParser.unmodlist(new PersistentObject[]{dtgDataset});
    }

    public final DtgDataset parse(String string, BufferedReader bufferedReader) {
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        this.log.debug("# cols found: " + list.size());
        list.remove(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            arrayList.add(string2);
            string2 = this.nextLine(bufferedReader);
        }
        DtgDataset dtgDataset = this._parse(string, arrayList, list);
        bufferedReader.close();
        this.doneImport();
        return dtgDataset;
    }

    private DtgDataset _parse(String string, List list, List list2) {
        ObjectMatrix objectMatrix = new ObjectMatrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2 = (String)list.get(i2);
            List list3 = ParseUtils.string2stringsList(string2, " \t");
            if (list3.size() != list2.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 1) + " but found: " + list3.size() + " on line: " + string2);
            }
            String string3 = (String)list3.get(0);
            arrayList.add(string3);
            for (int i3 = 1; i3 < list3.size(); ++i3) {
                String string4 = list3.get(i3).toString();
                float[] fArray = ParseUtils.string2floats(string4, "\",");
                objectMatrix.setElement(i2, i3 - 1, fArray);
            }
        }
        this.log.info("Completed parsing DtgDataset");
        DtgDataset dtgDataset = new DtgDataset(string, objectMatrix, arrayList, list2);
        dtgDataset.addComment(this.fComment.toString());
        return dtgDataset;
    }
}

